/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.render;

import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.CoreEvent;
import com.kamesuta.mc.signpic.attr.AttrReaders;
import com.kamesuta.mc.signpic.attr.prop.SizeData;
import com.kamesuta.mc.signpic.entry.Entry;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.mode.CurrentMode;
import com.kamesuta.mc.signpic.render.RenderHelper;
import com.kamesuta.mc.signpic.util.Sign;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class SignPicRender {
    @Nonnull
    public static final ResourceLocation resSign = new ResourceLocation("textures/items/sign.png");

    @CoreEvent
    public void onRender(@Nonnull RenderWorldLastEvent event) {
        float opacity = Config.getConfig().renderPreviewFixedOpacity.get().floatValue();
        if (CurrentMode.instance.isMode(CurrentMode.Mode.SETPREVIEW) || CurrentMode.instance.isMode(CurrentMode.Mode.PLACE)) {
            Sign.preview.capturePlace();
            opacity = Config.getConfig().renderPreviewFloatedOpacity.get().floatValue();
        }
        if (CurrentMode.instance.isState(CurrentMode.State.PREVIEW) && Sign.preview.isRenderable() && Sign.preview.isVisible()) {
            TileEntitySign tile = Sign.preview.getRenderTileEntity();
            BlockPos pos = tile.func_174877_v();
            Client.renderer.renderSignPictureBase(tile, (double)pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b, (double)pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c, (double)pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d, event.getPartialTicks(), -1, opacity);
        }
    }

    @CoreEvent
    public void onDraw(@Nonnull RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && CurrentMode.instance.isMode() && (int)(System.currentTimeMillis() / 500L) % 2 == 0) {
            FontRenderer fontrenderer = WRenderer.font();
            WRenderer.startTexture();
            OpenGL.glPushMatrix();
            OpenGL.glTranslatef(5.0f, 5.0f, 0.0f);
            OpenGL.glScalef(2.0f, 2.0f, 1.0f);
            OpenGL.glPushMatrix();
            OpenGL.glScalef(fontrenderer.field_78288_b, fontrenderer.field_78288_b, 1.0f);
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            WRenderer.texture().func_110577_a(resSign);
            WRenderer.startTexture();
            RenderHelper.drawRectTexture(7);
            OpenGL.glPopMatrix();
            OpenGL.glTranslatef(fontrenderer.field_78288_b, 0.0f, 0.0f);
            String str = I18n.func_135052_a((String)CurrentMode.instance.getMode().message, (Object[])new Object[0]);
            fontrenderer.func_175063_a(str, 0.0f, 0.0f, 0xFFFFFF);
            OpenGL.glPopMatrix();
        }
    }

    @CoreEvent
    public void onText(@Nonnull RenderGameOverlayEvent.Text event) {
        Entry entry;
        TileEntitySign tilesign;
        if (Client.mc.field_71474_y.field_74330_P && (tilesign = Client.getTileSignLooking()) != null && (entry = EntryId.SignEntryId.fromTile(tilesign).entry()).isValid()) {
            Content content;
            AttrReaders meta = entry.getMeta();
            SizeData signsize = meta.sizes.getMovie().get();
            ArrayList left = event.getLeft();
            left.add("");
            left.add(I18n.func_135052_a((String)"signpic.over.sign", (Object[])new Object[]{entry.id.id()}));
            if (entry.contentId != null) {
                left.add(I18n.func_135052_a((String)"signpic.over.id", (Object[])new Object[]{entry.contentId.getURI()}));
            }
            SizeData imagesize = (content = entry.getContent()) != null ? content.image.getSize() : SizeData.UnknownSize;
            SizeData viewsize = signsize.aspectSize(imagesize);
            left.add(I18n.func_135052_a((String)"signpic.over.size", (Object[])new Object[]{signsize, Float.valueOf(signsize.getWidth()), Float.valueOf(signsize.getHeight()), Float.valueOf(imagesize.getWidth()), Float.valueOf(imagesize.getHeight()), Float.valueOf(viewsize.getWidth()), Float.valueOf(viewsize.getHeight())}));
            if (content != null) {
                left.add(I18n.func_135052_a((String)"signpic.over.status", (Object[])new Object[]{content.state.getStateMessage()}));
            }
            if (entry.isNotSupported()) {
                left.add(I18n.func_135052_a((String)"signpic.over.advmsg", (Object[])new Object[]{I18n.func_135052_a((String)"signpic.state.format.unsupported", (Object[])new Object[0])}));
            } else if (content != null) {
                String advmsg = content.state.getMessage();
                left.add(I18n.func_135052_a((String)"signpic.over.advmsg", (Object[])new Object[]{advmsg}));
            }
            if (tilesign.field_145915_a != null) {
                left.add(I18n.func_135052_a((String)"signpic.over.raw", (Object[])new Object[]{tilesign.field_145915_a[0], tilesign.field_145915_a[1], tilesign.field_145915_a[2], tilesign.field_145915_a[3]}));
            }
            if (content != null) {
                left.add(I18n.func_135052_a((String)"signpic.over.local", (Object[])new Object[]{content.image.getLocal()}));
            }
        }
    }
}

