/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.render;

import com.kamesuta.mc.bnnwidget.render.OpenGL;
import com.kamesuta.mc.bnnwidget.render.WRenderer;
import com.kamesuta.mc.signpic.entry.content.Content;
import com.kamesuta.mc.signpic.render.RenderHelper;
import com.kamesuta.mc.signpic.state.Progress;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.util.Color;

public class StateRender {
    public static void drawLoading(@Nonnull Progress progress, @Nonnull LoadingCircle type, @Nonnull LoadingCircleType speed) {
        if (type != LoadingCircle.DEFAULT) {
            OpenGL.glLineWidth(3.0f);
            WRenderer.startShape();
            OpenGL.glPushMatrix();
            OpenGL.glScalef(0.5f, 0.5f, 1.0f);
            type.loadingColor();
            RenderHelper.drawLoadingCircle(speed.inner, speed.outer);
            type.designColor();
            RenderHelper.drawDesignCircle();
            type.progressColor();
            float p = progress.getProgress();
            RenderHelper.drawProgressCircle(p);
            OpenGL.glPopMatrix();
        }
    }

    public static void drawMessage(@Nonnull Content content, @Nonnull FontRenderer fontrenderer) {
        WRenderer.startTexture();
        float f1 = 0.6666667f;
        float f3 = 0.044444453f;
        OpenGL.glTranslatef(0.0f, 1.0f, 0.0f);
        OpenGL.glPushMatrix();
        OpenGL.glScalef(f3, f3, 1.0f);
        String msg1 = content.state.getStateMessage();
        fontrenderer.func_175063_a(msg1, (float)(-fontrenderer.func_78256_a(msg1) / 2), (float)(-fontrenderer.field_78288_b), 0xFFFFFF);
        OpenGL.glPopMatrix();
        f3 = 0.024444446f;
        OpenGL.glPushMatrix();
        OpenGL.glScalef(f3, f3, 1.0f);
        String msg2 = content.id.getID();
        fontrenderer.func_175063_a(msg2, (float)(-fontrenderer.func_78256_a(msg2) / 2), 0.0f, 0xFFFFFF);
        OpenGL.glPopMatrix();
        String msg3 = content.state.getMessage();
        OpenGL.glPushMatrix();
        OpenGL.glScalef(f3, f3, 1.0f);
        fontrenderer.func_175063_a(msg3, (float)(-fontrenderer.func_78256_a(msg3) / 2), (float)fontrenderer.field_78288_b, 0xFFFFFF);
        OpenGL.glPopMatrix();
    }

    public static enum LoadingCircleType {
        WAIT(-1254, -1786),
        RUN(627, 893),
        DEFAULT(-1, -1);

        public final int inner;
        public final int outer;

        private LoadingCircleType(int inner, int outer) {
            this.inner = inner;
            this.outer = outer;
        }
    }

    public static enum LoadingCircle {
        INIT(new Color(0, 255, 255, 255), new Color(160, 160, 160, 255), new Color(120, 120, 120, 255)),
        DOWNLOAD(new Color(0, 255, 255, 255), new Color(0, 102, 204, 255), new Color(23, 121, 232, 255)),
        CONTENTLOAD(new Color(0, 255, 255, 255), new Color(0, 144, 55), new Color(23, 177, 55, 255)),
        DEFAULT(new Color(), new Color(), new Color());

        @Nonnull
        private final Color loading;
        @Nonnull
        private final Color progress;
        @Nonnull
        private final Color design;

        private LoadingCircle(@Nonnull Color loading, Color progress, Color design) {
            this.loading = loading;
            this.progress = progress;
            this.design = design;
        }

        public void loadingColor() {
            OpenGL.glColor(this.loading);
        }

        public void progressColor() {
            OpenGL.glColor(this.progress);
        }

        public void designColor() {
            OpenGL.glColor(this.design);
        }
    }
}

