/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.state;

import com.google.common.collect.Maps;
import com.kamesuta.mc.signpic.LoadCanceledException;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.entry.content.ContentBlockedException;
import com.kamesuta.mc.signpic.entry.content.ContentCapacityOverException;
import com.kamesuta.mc.signpic.entry.content.RetryCountOverException;
import com.kamesuta.mc.signpic.image.InvaildImageException;
import com.kamesuta.mc.signpic.state.Progress;
import com.kamesuta.mc.signpic.state.StateType;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;

public class State {
    @Nonnull
    private String name = "";
    @Nonnull
    private Progress progress = new Progress();
    @Nonnull
    private StateType type = StateType.INIT;
    @Nonnull
    private String message = "";
    @Nonnull
    private final Map<String, Object> map = Maps.newHashMap();

    @Nonnull
    public State setName(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public State setProgress(@Nonnull Progress progress) {
        this.progress = progress;
        return this;
    }

    @Nonnull
    public Progress getProgress() {
        return this.progress;
    }

    @Nonnull
    public State setMessage(@Nonnull String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    public Map<String, Object> getMeta() {
        return this.map;
    }

    @Nonnull
    public State setErrorMessage(@Nullable Throwable throwable) {
        if (throwable != null) {
            this.setType(StateType.ERROR);
            try {
                throw throwable;
            }
            catch (URISyntaxException e) {
                this.setMessage(I18n.func_135052_a((String)"signpic.advmsg.invalidurl", (Object[])new Object[]{e}));
            }
            catch (LoadCanceledException e) {
                this.setMessage(I18n.func_135052_a((String)"signpic.advmsg.loadstopped", (Object[])new Object[]{e}));
            }
            catch (RetryCountOverException e) {
                this.setMessage(I18n.func_135052_a((String)"signpic.advmsg.retryover", (Object[])new Object[]{e}));
            }
            catch (ContentCapacityOverException e) {
                this.setMessage(I18n.func_135052_a((String)"signpic.advmsg.capacityover", (Object[])new Object[]{e}));
            }
            catch (ContentBlockedException e) {
                this.setMessage(I18n.func_135052_a((String)"signpic.advmsg.blocked", (Object[])new Object[]{e}));
            }
            catch (InvaildImageException e) {
                this.setMessage(I18n.func_135052_a((String)"signpic.advmsg.invalidimage", (Object[])new Object[]{e}));
            }
            catch (IOException e) {
                this.setMessage(I18n.func_135052_a((String)"signpic.advmsg.ioerror", (Object[])new Object[]{e}));
            }
            catch (Throwable e) {
                this.setMessage(I18n.func_135052_a((String)"signpic.advmsg.unknown", (Object[])new Object[]{e}));
            }
            Log.dev.error(this.getMessage(), throwable);
        }
        return this;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public State setType(@Nonnull StateType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public StateType getType() {
        return this.type;
    }

    @Nonnull
    public String getStateMessage() {
        return I18n.func_135052_a((String)this.type.msg, (Object[])new Object[]{(int)(this.progress.getProgress() * 100.0f)});
    }
}

