/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.util;

import com.google.common.collect.Maps;
import com.kamesuta.mc.signpic.Client;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ChatBuilder {
    public static final int DefaultId = 877;
    @Nullable
    private ITextComponent chat = null;
    @Nullable
    private Style style = null;
    @Nonnull
    private String text = "";
    @Nonnull
    private Object[] params = new Object[0];
    private boolean useTranslation = false;
    private boolean useJson = false;
    private boolean useId = false;
    @Nonnull
    private final Map<String, String> replace = Maps.newHashMap();
    private int id = -1;

    @Nonnull
    public ITextComponent build() {
        ITextComponent chat;
        if (this.chat != null) {
            chat = this.chat;
        } else if (this.useTranslation && !this.useJson) {
            chat = new TextComponentTranslation(this.text, this.params);
        } else {
            String s = this.useTranslation ? ChatBuilder.translateToLocal(this.text) : this.text;
            for (Map.Entry<String, String> entry : this.replace.entrySet()) {
                s = StringUtils.replace((String)s, (String)entry.getKey(), (String)entry.getValue());
            }
            if (this.params.length > 0) {
                s = String.format(s, this.params);
            }
            if (this.useJson) {
                try {
                    ITextComponent t = ITextComponent.Serializer.func_150699_a((String)s);
                    chat = t != null ? t : new TextComponentString("Invaild Json: " + this.text);
                }
                catch (Exception e) {
                    chat = new TextComponentString("Invaild Json: " + this.text);
                }
            } else {
                chat = new TextComponentString(this.text);
            }
        }
        if (this.style != null) {
            chat.func_150255_a(this.style);
        }
        return chat;
    }

    @SideOnly(value=Side.CLIENT)
    public static String translateToLocal(String text) {
        return I18n.func_74838_a((String)text);
    }

    public boolean isEmpty() {
        if (StringUtils.isEmpty((CharSequence)this.text)) {
            if (this.chat != null) {
                return StringUtils.isEmpty((CharSequence)this.chat.func_150260_c());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ChatBuilder setId(int id) {
        this.useId = true;
        this.id = id;
        return this;
    }

    @Nonnull
    public ChatBuilder setId() {
        this.setId(877);
        return this;
    }

    @Nonnull
    public ChatBuilder setChat(@Nullable ITextComponent chat) {
        this.chat = chat;
        return this;
    }

    @Nonnull
    public ChatBuilder setText(@Nonnull String text) {
        this.text = text;
        return this;
    }

    @Nonnull
    public ChatBuilder setParams(Object ... params) {
        this.params = params;
        return this;
    }

    @Nonnull
    public ChatBuilder setStyle(@Nullable Style style) {
        this.style = style;
        return this;
    }

    @Nonnull
    public ChatBuilder useTranslation() {
        this.useTranslation = true;
        return this;
    }

    @Nonnull
    public ChatBuilder useJson() {
        this.useJson = true;
        return this;
    }

    @Nonnull
    public ChatBuilder replace(@Nonnull String from, @Nonnull String to) {
        this.replace.put(from, to);
        return this;
    }

    @Nonnull
    public static ChatBuilder create(@Nonnull String text) {
        return new ChatBuilder().setText(text);
    }

    @SideOnly(value=Side.CLIENT)
    public void chatClient() {
        if (!this.isEmpty()) {
            ChatBuilder.chatClient(this);
        }
    }

    public void sendPlayer(@Nonnull ICommandSender target) {
        if (!this.isEmpty()) {
            ChatBuilder.sendPlayer(target, this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void chatClient(@Nonnull ChatBuilder chat) {
        Minecraft mc = Client.mc;
        if (mc.field_71439_g != null) {
            ITextComponent msg = chat.build();
            if (chat.useId) {
                mc.field_71456_v.func_146158_b().func_146234_a(msg, chat.id);
            } else {
                mc.field_71439_g.func_146105_b(msg, false);
            }
        }
    }

    public static void sendPlayer(@Nonnull ICommandSender target, @Nonnull ChatBuilder chat) {
        target.func_145747_a(chat.build());
    }

    @SideOnly(value=Side.SERVER)
    public static void sendServer(@Nonnull ChatBuilder chat) {
        PlayerList player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        player.func_148539_a(chat.build());
    }
}

