/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.util;

import com.kamesuta.mc.signpic.Config;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class Downloader {
    @Nonnull
    public static Downloader downloader = new Downloader();
    @Nonnull
    public final PoolingHttpClientConnectionManager manager;
    @Nonnull
    public HttpClient client;

    public Downloader() {
        Registry registry = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER){

                protected void prepareSocket(@Nullable SSLSocket socket) throws IOException {
                    if (socket != null) {
                        String[] enabledCipherSuites = socket.getEnabledCipherSuites();
                        ArrayList<String> asList = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
                        asList.remove("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
                        asList.remove("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
                        asList.remove("TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
                        String[] array = asList.toArray(new String[0]);
                        socket.setEnabledCipherSuites(array);
                    }
                }
            };
            registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        }
        catch (NoSuchAlgorithmException sslContext) {
        }
        catch (KeyManagementException sslContext) {
        }
        catch (KeyStoreException sslContext) {
            // empty catch block
        }
        this.manager = registry != null ? new PoolingHttpClientConnectionManager(registry) : new PoolingHttpClientConnectionManager();
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        if (Config.getConfig().communicateDLTimedout.get() > 0) {
            requestConfig.setConnectTimeout(Config.getConfig().communicateDLTimedout.get().intValue());
            requestConfig.setSocketTimeout(Config.getConfig().communicateDLTimedout.get().intValue());
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Accept-Charset", "utf-8"));
        headers.add(new BasicHeader("Accept-Language", "ja, en;q=0.8"));
        headers.add(new BasicHeader("User-Agent", "signpic"));
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.manager).setDefaultRequestConfig(requestConfig.build()).setDefaultHeaders(headers).build();
    }
}

