/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.util;

import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Log;
import com.kamesuta.mc.signpic.gui.GuiMain;
import com.kamesuta.mc.signpic.http.upload.UploadApiUtil;
import com.kamesuta.mc.signpic.http.upload.UploadCallback;
import com.kamesuta.mc.signpic.http.upload.UploadRequest;
import com.kamesuta.mc.signpic.state.State;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.resources.I18n;
import org.apache.commons.io.FileUtils;

public class FileUtilitiy {
    public static boolean transfer(@Nonnull Transferable transferable, @Nullable UploadCallback after) {
        block11: {
            try {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String id = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (id != null) {
                        GuiMain.setContentId(id);
                        if (after != null) {
                            after.onDone(id);
                        }
                    }
                    break block11;
                }
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List droppedFiles = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (Object obj : droppedFiles) {
                        if (!(obj instanceof File)) continue;
                        File file = (File)obj;
                        UploadApiUtil.upload(UploadRequest.fromFile(file, new State()), after);
                    }
                    break block11;
                }
                if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    BufferedImage bi = (BufferedImage)transferable.getTransferData(DataFlavor.imageFlavor);
                    if (bi == null) break block11;
                    try {
                        FileUtilitiy.uploadImage(bi, after);
                        break block11;
                    }
                    catch (IOException e) {
                        Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.paste.error", (Object[])new Object[]{e}));
                        return false;
                    }
                }
                Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.paste.typeunsupported", (Object[])new Object[0]));
                return false;
            }
            catch (IOException e) {
                Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.paste.error", (Object[])new Object[]{e}));
                return false;
            }
            catch (UnsupportedFlavorException e) {
                Log.notice(I18n.func_135052_a((String)"signpic.gui.notice.paste.unsupported", (Object[])new Object[]{e}));
            }
        }
        return true;
    }

    public static void uploadImage(@Nonnull BufferedImage image, final @Nullable UploadCallback after) throws IOException {
        final File tmp = Client.getLocation().createCache("paste");
        ImageIO.write((RenderedImage)image, "png", tmp);
        UploadApiUtil.upload(UploadRequest.fromFile(tmp, new State()), new UploadCallback(){

            @Override
            public void onDone(String str) {
                FileUtils.deleteQuietly((File)tmp);
                if (after != null) {
                    after.onDone(str);
                }
            }
        });
    }
}

