/*
 * Decompiled with CFR 0.152.
 */
package com.kamesuta.mc.signpic.util;

import com.kamesuta.mc.signpic.Client;
import com.kamesuta.mc.signpic.Config;
import com.kamesuta.mc.signpic.entry.EntryId;
import com.kamesuta.mc.signpic.entry.EntryIdBuilder;
import com.kamesuta.mc.signpic.gui.GuiPAAS;
import com.kamesuta.mc.signpic.preview.SignEntity;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.tileentity.TileEntitySign;
import org.lwjgl.util.Timer;

public class Sign {
    public static int maxText = 60;
    @Nonnull
    public static final SignEntity preview = new SignEntity();
    @Nonnull
    public static EntryIdBuilder builder = new EntryIdBuilder();

    public static void updatePreview(@Nonnull EntryId entryId) {
        entryId.toEntity(preview.getTileEntity());
    }

    public static void sendSign(@Nonnull EntryId entryId, @Nonnull TileEntitySign sourceentity) {
        entryId.toEntity(sourceentity);
        sourceentity.func_70296_d();
        NetHandlerPlayClient nethandlerplayclient = Client.mc.func_147114_u();
        if (nethandlerplayclient != null) {
            nethandlerplayclient.func_147297_a((Packet)new CPacketUpdateSign(sourceentity.func_174877_v(), sourceentity.field_145915_a));
        }
        sourceentity.func_145913_a(true);
    }

    public static void placeSign(@Nonnull EntryId entryId, @Nonnull TileEntitySign sourceentity) {
        if (Config.getConfig().multiplayPAAS.get().booleanValue() && !Client.mc.func_71356_B()) {
            Client.mc.func_147108_a((GuiScreen)new GuiPAAS(new SendPacketTask(entryId, sourceentity)));
        } else {
            Sign.sendSign(entryId, sourceentity);
        }
    }

    public static void sendRepairName(@Nonnull String name) {
        Client.mc.field_71439_g.field_71174_a.func_147297_a((Packet)new CPacketCustomPayload("MC|ItemName", new PacketBuffer(Unpooled.buffer()).func_180714_a(name)));
    }

    public static void setRepairName(@Nonnull String name, @Nonnull GuiTextField textField, @Nonnull ContainerRepair containerRepair) {
        textField.func_146180_a(name);
        containerRepair.func_82850_a(name);
        Sign.sendRepairName(name);
    }

    public static class SendPacketTask {
        public final long limit;
        @Nonnull
        public final EntryId id;
        @Nonnull
        public final String[] lines;
        @Nonnull
        public final TileEntitySign entity;
        @Nonnull
        public final Timer timer = new Timer();

        public SendPacketTask(@Nonnull EntryId id, @Nonnull TileEntitySign entity) {
            this.lines = new String[4];
            id.toStrings(this.lines);
            this.limit = SendPacketTask.getExpectedEditTime(this.lines, false);
            this.id = id;
            this.entity = entity;
        }

        private void sendPacket() {
            Sign.sendSign(this.id, this.entity);
        }

        public boolean tick() {
            if (this.timer.getTime() * 1000.0f > (float)this.limit) {
                this.sendPacket();
                return true;
            }
            return false;
        }

        private static long getExpectedEditTime(@Nonnull String[] lines, boolean skipEmpty) {
            long expected = Config.getConfig().multiplayPAASMinEditTime.get().intValue();
            int minchartime = Config.getConfig().multiplayPAASMinCharTime.get();
            int n = 0;
            for (String line : lines) {
                if (line == null || (line = line.trim().toLowerCase()).isEmpty()) continue;
                int chars = line.length();
                ++n;
                expected += (long)(minchartime * chars);
            }
            if (skipEmpty && n == 0) {
                return 0L;
            }
            if (n > 1) {
                expected += (long)(Config.getConfig().multiplayPAASMinLineTime.get() * n);
            }
            return expected;
        }
    }
}

