/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedIronBars;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityCageTrap;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedIronBars;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.TriConsumer;

public class BlockCageTrap
extends BlockDisguisable {
    public static final PropertyBool DEACTIVATED = PropertyBool.func_177716_a((String)"deactivated");

    public BlockCageTrap(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == this.func_180664_k();
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            return super.func_180646_a(state, world, pos);
        }
        return null;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCageTrap) {
            TileEntityCageTrap te = (TileEntityCageTrap)tile;
            if (entity instanceof EntityPlayer && (te.getOwner().isOwner((EntityPlayer)entity) || ModuleUtils.isAllowed((IModuleInventory)te, entity))) {
                this.addCorrectShape(state, world, pos, entityBox, collidingBoxes, entity, isActualState, te);
            }
            if (entity instanceof EntityLiving && !((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                if (te.capturesMobs()) {
                    BlockCageTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
                } else {
                    this.addCorrectShape(state, world, pos, entityBox, collidingBoxes, entity, isActualState, te);
                }
                return;
            }
            if (entity instanceof EntityItem) {
                this.addCorrectShape(state, world, pos, entityBox, collidingBoxes, entity, isActualState, te);
                return;
            }
            if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                this.addCorrectShape(state, world, pos, entityBox, collidingBoxes, entity, isActualState, te);
            } else {
                BlockCageTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
            }
        } else {
            BlockCageTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
        }
    }

    private void addCorrectShape(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState, TileEntityDisguisable disguisableTe) {
        ItemStack moduleStack = disguisableTe.getModule(EnumModuleType.DISGUISE);
        if (!moduleStack.func_190926_b() && ((ItemModule)moduleStack.func_77973_b()).getBlockAddon(moduleStack.func_77978_p()) != null) {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
        } else {
            BlockCageTrap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                return;
            }
            TileEntityCageTrap tileEntity = (TileEntityCageTrap)world.func_175625_s(pos);
            boolean isPlayer = entity instanceof EntityPlayer;
            if (isPlayer || entity instanceof EntityMob && tileEntity.capturesMobs()) {
                if (isPlayer && tileEntity.getOwner().isOwner((EntityPlayer)entity)) {
                    return;
                }
                BlockPos topMiddle = pos.func_177981_b(4);
                String ownerName = tileEntity.getOwner().getName();
                BlockModifier placer = new BlockModifier(world, new BlockPos.MutableBlockPos(pos), tileEntity.getOwner());
                placer.loop((TriConsumer<World, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                    if (w.func_175623_d((BlockPos)p)) {
                        if (p.equals((Object)topMiddle)) {
                            w.func_175656_a((BlockPos)p, SCContent.horizontalReinforcedIronBars.func_176223_P());
                        } else {
                            w.func_175656_a((BlockPos)p, ((BlockReinforcedIronBars)SCContent.reinforcedIronBars).func_176221_a(SCContent.reinforcedIronBars.func_176223_P(), (IBlockAccess)w, (BlockPos)p));
                        }
                    }
                }));
                placer.loop((TriConsumer<World, BlockPos.MutableBlockPos, Owner>)((TriConsumer)(w, p, o) -> {
                    TileEntity te = w.func_175625_s((BlockPos)p);
                    if (te instanceof IOwnable) {
                        ((IOwnable)te).setOwner(o.getUUID(), o.getName());
                    }
                    if (te instanceof TileEntityReinforcedIronBars) {
                        ((TileEntityReinforcedIronBars)te).setCanDrop(false);
                    }
                }));
                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                world.func_184133_a(null, pos, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 3.0f, 1.0f);
                if (isPlayer && PlayerUtils.isPlayerOnline(ownerName)) {
                    PlayerUtils.sendMessageToPlayer(PlayerUtils.getPlayerFromName(ownerName), (ITextComponent)Utils.localize("tile.securitycraft:cageTrap.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:cageTrap.captured", entity.func_70005_c_(), pos), TextFormatting.BLACK);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == SCContent.wireCutters) {
            if (!((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                if (!player.func_184812_l_()) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        } else if (stack.func_77973_b() == Items.field_151137_ax && ((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187907_gg, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DEACTIVATED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEACTIVATED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCageTrap();
    }

    public static class BlockModifier {
        private World world;
        private BlockPos.MutableBlockPos pos;
        private BlockPos origin;
        private Owner owner;

        public BlockModifier(World world, BlockPos.MutableBlockPos origin, Owner owner) {
            this.world = world;
            this.pos = origin.func_181079_c(origin.func_177958_n() - 1, origin.func_177956_o() + 1, origin.func_177952_p() - 1);
            this.origin = origin.func_185334_h();
            this.owner = owner;
        }

        public void loop(TriConsumer<World, BlockPos.MutableBlockPos, Owner> ifTrue) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        if (x != 1 || z != 1 || y == 3) {
                            ifTrue.accept((Object)this.world, (Object)this.pos, (Object)this.owner);
                        }
                        this.pos.func_181079_c(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p() + 1);
                    }
                    this.pos.func_181079_c(this.pos.func_177958_n() + 1, this.pos.func_177956_o(), this.pos.func_177952_p() - 3);
                }
                this.pos.func_181079_c(this.pos.func_177958_n() - 3, this.pos.func_177956_o() + 1, this.pos.func_177952_p());
            }
            this.pos.func_189533_g((Vec3i)this.origin);
        }
    }
}

