/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityAllowlistOnly;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockReinforcedPressurePlate
extends BlockPressurePlate
implements IReinforcedBlock {
    private final Block vanillaBlock;

    public BlockReinforcedPressurePlate(Material material, BlockPressurePlate.Sensitivity sensitivity, SoundType soundType, Block vanillaBlock) {
        super(material, sensitivity);
        this.func_149672_a(soundType);
        this.vanillaBlock = vanillaBlock;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te;
        int redstoneStrength = this.func_176576_e(state);
        if (!world.field_72995_K && redstoneStrength == 0 && entity instanceof EntityPlayer && (te = world.func_175625_s(pos)) instanceof TileEntityAllowlistOnly && this.isAllowedToPress(world, pos, (TileEntityAllowlistOnly)te, (EntityPlayer)entity)) {
            this.func_180666_a(world, pos, state, redstoneStrength);
        }
    }

    protected int func_180669_e(World world, BlockPos pos) {
        TileEntity te;
        AxisAlignedBB aabb = field_185511_c.func_186670_a(pos);
        List list = world.func_72839_b(null, aabb);
        if (!list.isEmpty() && (te = world.func_175625_s(pos)) instanceof TileEntityAllowlistOnly) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityPlayer) || !this.isAllowedToPress(world, pos, (TileEntityAllowlistOnly)te, (EntityPlayer)entity)) continue;
                return 15;
            }
        }
        return 0;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, TileEntityAllowlistOnly te, EntityPlayer entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)entity);
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(this.vanillaBlock);
    }

    @Override
    public int getAmount() {
        return 1;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAllowlistOnly();
    }

    public static class DoorActivator
    implements IDoorActivator {
        private final List<Block> blocks = Arrays.asList(SCContent.reinforcedStonePressurePlate, SCContent.reinforcedWoodenPressurePlate);

        @Override
        public boolean isPowering(World world, BlockPos pos, IBlockState state, TileEntity te, EnumFacing direction, int distance) {
            return (Boolean)state.func_177229_b((IProperty)BlockPressurePlate.field_176580_a) != false && (distance < 2 || direction == EnumFacing.UP);
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

