/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui.components;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class PatronScrollList {
    private final Minecraft client;
    protected final int listWidth;
    protected final int listHeight;
    protected final int screenWidth;
    protected final int screenHeight;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    protected final int slotHeight;
    protected int mouseX;
    protected int mouseY;
    private float initialMouseClickY = -2.0f;
    private float scrollFactor;
    public float scrollDistance;
    protected int selectedIndex = -1;
    private int headerHeight;
    protected boolean captureMouse = true;
    public boolean isHovering;

    public PatronScrollList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
        this.client = client;
        this.listWidth = width;
        this.listHeight = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + left;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public abstract int getSize();

    public abstract void drawPanel(int var1, int var2, Tessellator var3, int var4, int var5);

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int scrollBarWidth = 6;
        int scrollBarRight = this.left + this.listWidth;
        int scrollBarLeft = scrollBarRight - scrollBarWidth;
        int viewHeight = this.bottom - this.top;
        int border = 4;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        boolean bl = this.isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                if (this.isHovering) {
                    if (mouseX >= scrollBarLeft && mouseX <= scrollBarRight) {
                        int scrollHeight = this.getContentHeight() - viewHeight - border;
                        this.scrollFactor = -1.0f;
                        if (scrollHeight < 1) {
                            scrollHeight = 1;
                        }
                        this.scrollFactor /= (float)(viewHeight - this.getBarHeight(viewHeight, border)) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = mouseY;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        ScaledResolution res = new ScaledResolution(this.client);
        double scaleW = (double)this.client.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.client.field_71440_d / res.func_78324_d();
        int extraHeight = this.getContentHeight() + border - viewHeight;
        this.applyScrollLimits();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.client.field_71440_d - (double)this.bottom * scaleH)), (int)((int)((double)this.listWidth * scaleW)), (int)((int)((double)viewHeight * scaleH)));
        GuiUtils.drawGradientRect((int)0, (int)this.left, (int)this.top, (int)this.right, (int)this.bottom, (int)-1061176398, (int)-792740942);
        this.drawPanel(this.right, this.top + border - (int)this.scrollDistance, tess, mouseX, mouseY);
        GlStateManager.func_179097_i();
        if (extraHeight > 0) {
            int height = this.getBarHeight(viewHeight, border);
            int barTop = (int)this.scrollDistance * (viewHeight - height) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            GlStateManager.func_179090_x();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(142, 130, 112, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(142, 130, 112, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(142, 130, 112, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(142, 130, 112, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)(barTop + height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 112, 85, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)(barTop + height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 112, 85, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 112, 85, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 112, 85, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)(barTop + height - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(209, 191, 161, 255).func_181675_d();
            worldr.func_181662_b((double)(scrollBarRight - 1), (double)(barTop + height - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(209, 191, 161, 255).func_181675_d();
            worldr.func_181662_b((double)(scrollBarRight - 1), (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(209, 191, 161, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(209, 191, 161, 255).func_181675_d();
            tess.func_78381_a();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)3089);
    }

    public int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerHeight;
    }

    public void applyScrollLimits() {
        int listHeight = this.getContentHeight() - (this.bottom - this.top - 7);
        if (listHeight < 0) {
            listHeight /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        } else if (this.scrollDistance > (float)listHeight) {
            this.scrollDistance = listHeight;
        }
    }

    public void handleMouseInput(int mouseX, int mouseY) throws IOException {
        if (!this.isHovering) {
            return;
        }
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            this.scrollDistance += (float)(-1 * scroll) / 120.0f * (float)this.slotHeight / 2.0f;
        }
    }

    public int getBarHeight(int viewHeight, int border) {
        int barHeight = (int)((float)(viewHeight * viewHeight) / (float)this.getContentHeight());
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > viewHeight - border * 2) {
            barHeight = viewHeight - border * 2;
        }
        return barHeight;
    }
}

