/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSentryRemoteAccessTool
extends Item {
    private static final Style GRAY_STYLE = new Style().func_150238_a(TextFormatting.GRAY);

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            player.openGui((Object)SecurityCraft.instance, 3, world, player.func_184102_h().func_184103_al().func_72372_a(), (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        List sentries = world.func_72872_a(EntitySentry.class, new AxisAlignedBB(pos));
        if (!sentries.isEmpty()) {
            EntitySentry sentry = (EntitySentry)((Object)sentries.get(0));
            BlockPos pos2 = sentry.func_180425_c();
            if (!this.isSentryAdded(stack, pos2)) {
                int availSlot = this.getNextAvailableSlot(stack);
                if (availSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:srat.noSlots", new Object[0]), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                if (!sentry.getOwner().isOwner(player)) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:srat.cantBind", new Object[0]), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74783_a("sentry" + availSlot, BlockUtils.posToIntArray(pos2));
                if (!world.field_72995_K) {
                    SecurityCraft.network.sendTo((IMessage)new UpdateNBTTagOnClient(stack), (EntityPlayerMP)player);
                }
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:srat.bound", pos2), TextFormatting.GREEN);
            } else {
                this.removeTagFromItemAndUpdate(stack, pos2, player);
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:srat.unbound", pos2), TextFormatting.RED);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            if (stack.func_77978_p().func_74759_k("sentry" + i).length > 0) {
                int[] coords = stack.func_77978_p().func_74759_k("sentry" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    list.add("---");
                    continue;
                }
                BlockPos pos = new BlockPos(coords[0], coords[1], coords[2]);
                List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72872_a(EntitySentry.class, new AxisAlignedBB(pos));
                String nameToShow = !sentries.isEmpty() && ((EntitySentry)((Object)sentries.get(0))).func_145818_k_() ? ((EntitySentry)((Object)sentries.get(0))).func_95999_t() : Utils.localize("tooltip.securitycraft:sentry", new Object[0]).func_150254_d() + TextFormatting.GRAY + " " + i;
                list.add(nameToShow + ": " + Utils.getFormattedCoordinates(pos).func_150255_a(GRAY_STYLE).func_150254_d());
                continue;
            }
            list.add("---");
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            stack.func_77978_p().func_74783_a("sentry" + i, new int[]{0, 0, 0});
            if (!player.field_70170_p.field_72995_K) {
                SecurityCraft.network.sendTo((IMessage)new UpdateNBTTagOnClient(stack), (EntityPlayerMP)player);
            }
            return;
        }
    }

    private boolean isSentryAdded(ItemStack stack, BlockPos pos) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvailableSlot(ItemStack stack) {
        for (int i = 1; i <= 12; ++i) {
            if (stack.func_77978_p() == null) {
                return 1;
            }
            int[] pos = stack.func_77978_p().func_74759_k("sentry" + i);
            if (pos.length != 0 && (pos[0] != 0 || pos[1] != 0 || pos[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

