/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client.gui.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import noppes.mpm.client.gui.util.GuiCustomScroll;
import noppes.mpm.client.gui.util.GuiNpcButton;
import noppes.mpm.client.gui.util.GuiNpcLabel;
import noppes.mpm.client.gui.util.GuiNpcSlider;
import noppes.mpm.client.gui.util.GuiNpcTextField;
import noppes.mpm.client.gui.util.ISubGuiListener;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiNPCInterface
extends GuiScreen {
    public EntityPlayerSP player;
    public boolean drawDefaultBackground = true;
    private HashMap<Integer, GuiNpcButton> buttons = new HashMap();
    private HashMap<Integer, GuiNpcTextField> textfields = new HashMap();
    private HashMap<Integer, GuiNpcLabel> labels = new HashMap();
    private HashMap<Integer, GuiCustomScroll> scrolls = new HashMap();
    private HashMap<Integer, GuiNpcSlider> sliders = new HashMap();
    private HashMap<Integer, GuiScreen> extra = new HashMap();
    protected ResourceLocation background = null;
    public boolean closeOnEsc = false;
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;
    private GuiNPCInterface subgui;
    public GuiNPCInterface parent;
    public int mouseX;
    public int mouseY;

    public GuiNPCInterface() {
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.xSize = 200;
        this.ySize = 222;
    }

    public void setBackground(String texture) {
        this.background = new ResourceLocation("moreplayermodels", "textures/gui/" + texture);
    }

    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("moreplayermodels", "textures/gui/" + texture);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiNpcTextField.unfocus();
        if (this.subgui != null) {
            this.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            this.subgui.func_73866_w_();
        }
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        this.labels.clear();
        this.textfields.clear();
        this.buttons.clear();
        this.scrolls.clear();
        this.sliders.clear();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73876_c() {
        if (this.subgui != null) {
            this.subgui.func_73876_c();
        } else {
            for (GuiNpcTextField tf : this.textfields.values()) {
                if (!tf.enabled) continue;
                tf.func_146178_a();
            }
            super.func_73876_c();
        }
    }

    public void func_73864_a(int i, int j, int k) throws IOException {
        if (this.subgui != null) {
            this.subgui.func_73864_a(i, j, k);
        } else {
            for (GuiNpcTextField tf : new ArrayList<GuiNpcTextField>(this.textfields.values())) {
                if (!tf.enabled) continue;
                tf.func_146192_a(i, j, k);
            }
            if (k == 0) {
                for (GuiCustomScroll scroll : new ArrayList<GuiCustomScroll>(this.scrolls.values())) {
                    scroll.func_73864_a(i, j, k);
                }
            }
            this.mouseEvent(i, j, k);
            super.func_73864_a(i, j, k);
        }
    }

    public void mouseEvent(int i, int j, int k) {
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (this.subgui != null) {
            this.subgui.buttonEvent(guibutton);
        } else {
            this.buttonEvent(guibutton);
        }
    }

    public void buttonEvent(GuiButton guibutton) {
    }

    public void func_73869_a(char c, int i) {
        if (this.subgui != null) {
            this.subgui.func_73869_a(c, i);
        } else {
            for (GuiNpcTextField tf : this.textfields.values()) {
                tf.func_146201_a(c, i);
            }
            if (this.closeOnEsc && (i == 1 || !GuiNpcTextField.isActive() && this.isInventoryKey(i))) {
                this.close();
            }
        }
    }

    public void func_146281_b() {
        GuiNpcTextField.unfocus();
    }

    public final void close() {
        if (this.parent != null) {
            this.parent.closeSubGui(this);
        } else {
            this.displayGuiScreen(null);
            this.field_146297_k.func_71381_h();
        }
        this.save();
    }

    public void addButton(GuiNpcButton button) {
        this.buttons.put(button.field_146127_k, button);
        this.field_146292_n.add(button);
    }

    public GuiNpcButton getButton(int i) {
        return this.buttons.get(i);
    }

    public void addTextField(GuiNpcTextField tf) {
        this.textfields.put(tf.field_175208_g, tf);
    }

    public GuiNpcTextField getTextField(int i) {
        return this.textfields.get(i);
    }

    public void addLabel(GuiNpcLabel label) {
        this.labels.put(label.id, label);
    }

    public GuiNpcLabel getLabel(int i) {
        return this.labels.get(i);
    }

    public void addSlider(GuiNpcSlider slider) {
        this.sliders.put(slider.field_146127_k, slider);
        this.field_146292_n.add(slider);
    }

    public GuiNpcSlider getSlider(int i) {
        return this.sliders.get(i);
    }

    public void addScroll(GuiCustomScroll scroll) {
        scroll.func_146280_a(this.field_146297_k, 350, 250);
        this.scrolls.put(scroll.id, scroll);
    }

    public GuiCustomScroll getScroll(int id) {
        return this.scrolls.get(id);
    }

    public abstract void save();

    public void func_73863_a(int i, int j, float f) {
        this.mouseX = i;
        this.mouseY = j;
        if (this.subgui == null || this.subgui.drawSubGuiBackground()) {
            if (this.drawDefaultBackground) {
                this.func_146276_q_();
            }
            if (this.background != null && this.field_146297_k.field_71446_o != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(this.background);
                if (this.xSize > 256) {
                    this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 250, this.ySize);
                    this.func_73729_b(this.guiLeft + 250, this.guiTop, 256 - (this.xSize - 250), 0, this.xSize - 250, this.ySize);
                } else {
                    this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
                }
            }
            for (GuiNpcLabel label : this.labels.values()) {
                label.drawLabel(this, this.field_146289_q);
            }
            for (GuiNpcTextField tf : this.textfields.values()) {
                tf.func_146194_f();
            }
            for (GuiCustomScroll scroll : this.scrolls.values()) {
                scroll.drawScreen(i, j, f, this.hasSubGui() ? 0 : Mouse.getDWheel());
            }
            for (GuiScreen gui : this.extra.values()) {
                gui.func_73863_a(i, j, f);
            }
            super.func_73863_a(i, j, f);
        }
        if (this.subgui != null) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)260.0f);
            this.subgui.func_73863_a(i, j, f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-260.0f);
        }
    }

    public boolean drawSubGuiBackground() {
        return true;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void elementClicked() {
        if (this.subgui != null) {
            this.subgui.elementClicked();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void doubleClicked() {
    }

    public boolean isInventoryKey(int i) {
        return i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i();
    }

    public void func_146276_q_() {
        super.func_146276_q_();
    }

    public void displayGuiScreen(GuiScreen gui) {
        this.field_146297_k.func_147108_a(gui);
    }

    public void setSubGui(GuiNPCInterface gui) {
        this.subgui = gui;
        this.subgui.parent = this;
        this.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.func_73866_w_();
    }

    public void closeSubGui(GuiNPCInterface gui) {
        this.subgui = null;
        if (this instanceof ISubGuiListener) {
            ((ISubGuiListener)((Object)this)).subGuiClosed(gui);
        }
        this.func_73866_w_();
    }

    public boolean hasSubGui() {
        return this.subgui != null;
    }

    public GuiNPCInterface getSubGui() {
        if (this.hasSubGui() && this.subgui.hasSubGui()) {
            return this.subgui.getSubGui();
        }
        return this.subgui;
    }

    public void drawNpc(EntityLivingBase npc, int x, int y, float zoomed, int rotation) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLeft + x), (float)(this.guiTop + y), (float)50.0f);
        float scale = 1.0f;
        if ((double)npc.field_70131_O > 2.4) {
            scale = 2.0f / npc.field_70131_O;
        }
        if (npc instanceof EntityPlayer) {
            // empty if block
        }
        GlStateManager.func_179152_a((float)(-60.0f * scale * zoomed), (float)(60.0f * scale * zoomed), (float)(60.0f * scale * zoomed));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = npc.field_70761_aq;
        float f3 = npc.field_70177_z;
        float f4 = npc.field_70125_A;
        float f7 = npc.field_70759_as;
        float f5 = (float)(this.guiLeft + x) - (float)this.mouseX;
        float f6 = (float)(this.guiTop + y) - 100.0f * scale * zoomed - (float)this.mouseY;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(f6 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        npc.field_70761_aq = rotation;
        npc.field_70177_z = (float)Math.atan(f5 / 80.0f) * 40.0f + (float)rotation;
        npc.field_70125_A = -((float)Math.atan(f6 / 40.0f)) * 20.0f;
        npc.field_70759_as = npc.field_70177_z;
        this.field_146297_k.func_175598_ae().field_78735_i = 180.0f;
        this.field_146297_k.func_175598_ae().func_188391_a((Entity)npc, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        npc.field_70760_ar = npc.field_70761_aq = f2;
        npc.field_70126_B = npc.field_70177_z = f3;
        npc.field_70127_C = npc.field_70125_A = f4;
        npc.field_70758_at = npc.field_70759_as = f7;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void openLink(String link) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(link));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

