/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.commands;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.mpm.ModelData;
import noppes.mpm.Server;
import noppes.mpm.commands.MpmCommandInterface;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumPackets;

public class CommandMPM
extends MpmCommandInterface {
    private HashMap<String, Class<? extends EntityLivingBase>> entities = new HashMap();
    private List<String> sub = Arrays.asList("url", "name", "entity", "scale", "animation", "sendmodel");

    public CommandMPM() {
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValues()) {
            String name = ent.getName();
            try {
                Class c = ent.getEntityClass();
                if (!EntityLiving.class.isAssignableFrom(c) || c.getConstructor(World.class) == null || Modifier.isAbstract(c.getModifiers())) continue;
                this.entities.put(name.toLowerCase(), c.asSubclass(EntityLivingBase.class));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (Exception exception) {}
        }
        this.entities.put("clear", null);
    }

    public String func_71517_b() {
        return "mpm";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender icommandsender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new CommandException("Not enough arguments given", new Object[0]);
        }
        String type = args[0].toLowerCase();
        if (!this.sub.contains(type)) {
            throw new CommandException("Unknown subcommand", new Object[0]);
        }
        args = Arrays.copyOfRange(args, 1, args.length);
        EntityPlayer player = null;
        if (args.length > 1 && this.isPlayerOp(icommandsender)) {
            try {
                player = CommandMPM.func_184888_a((MinecraftServer)server, (ICommandSender)icommandsender, (String)args[0]);
                args = Arrays.copyOfRange(args, 1, args.length);
            }
            catch (PlayerNotFoundException playerNotFoundException) {
                // empty catch block
            }
        }
        if (player == null && icommandsender instanceof EntityPlayer) {
            player = (EntityPlayer)icommandsender;
        }
        if (player == null) {
            throw new PlayerNotFoundException("commands.generic.player.notFound", new Object[]{icommandsender});
        }
        ModelData data = ModelData.get(player);
        if (type.equals("url")) {
            this.url(player, args, data);
        } else if (type.equals("scale")) {
            this.scale(player, args, data);
        } else if (type.equals("name")) {
            this.name(player, args, data);
        } else if (type.equals("entity")) {
            this.entity(player, args, data);
        } else if (type.equals("animation")) {
            this.animation(player, args, data);
        } else if (type.equals("sendmodel")) {
            this.sendmodel(server, player, args, data);
        }
    }

    private void animation(EntityPlayer player, String[] args, ModelData data) throws WrongUsageException {
        if (args.length <= 0) {
            throw new WrongUsageException("/mpm animation [@p] <animation>", new Object[0]);
        }
        String type = args[0];
        EnumAnimation animation = null;
        for (EnumAnimation ani : EnumAnimation.values()) {
            if (!ani.name().equalsIgnoreCase(type)) continue;
            animation = ani;
            break;
        }
        if (animation == null) {
            throw new WrongUsageException("Unknown animation " + type, new Object[0]);
        }
        if (data.animation == animation) {
            animation = EnumAnimation.NONE;
        }
        Server.sendAssociatedData((Entity)player, EnumPackets.ANIMATION, new Object[]{player.func_110124_au(), animation});
        data.setAnimation(animation);
    }

    private void entity(EntityPlayer player, String[] args, ModelData data) throws WrongUsageException {
        int i;
        if (args.length <= 0) {
            throw new WrongUsageException("/mpm entity [@p] <entity> (to go back to default /mpm entity [@p] clear)", new Object[0]);
        }
        String arg = args[0].toLowerCase();
        if (!this.entities.containsKey(arg)) {
            throw new WrongUsageException("Unknown entity: " + args[0], new Object[0]);
        }
        data.setEntityClass(this.entities.get(arg));
        if (args.length > i) {
            for (i = 1; i < args.length; ++i) {
                EntityLivingBase entity = data.getEntity(player);
                String[] split = args[i].split(":");
                if (split.length != 2) continue;
                data.setExtra(entity, split[0], split[1]);
            }
        }
        Server.sendAssociatedData((Entity)player, EnumPackets.SEND_PLAYER_DATA, player.func_110124_au(), data.writeToNBT());
    }

    private void name(EntityPlayer player, String[] args, ModelData data) throws WrongUsageException {
        if (args.length <= 0) {
            throw new WrongUsageException("/mpm name [@p] <name>", new Object[0]);
        }
        if (args.length > 1 && args[0].startsWith("&")) {
            data.displayFormat = args[0].replace('&', Character.toChars(167)[0]);
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        data.displayName = args[0];
        for (int i = 1; i < args.length; ++i) {
            data.displayName = data.displayName + " " + args[i];
        }
        data.displayName = data.displayName.replace('&', Character.toChars(167)[0]);
        if (data.displayName.equalsIgnoreCase("clear")) {
            data.displayName = "";
        }
        player.refreshDisplayName();
        Server.sendAssociatedData((Entity)player, EnumPackets.SEND_PLAYER_DATA, player.func_110124_au(), data.writeToNBT());
    }

    private void url(EntityPlayer player, String[] args, ModelData data) throws WrongUsageException {
        if (args.length <= 0) {
            throw new WrongUsageException("/mpm url [@p] <url> (to go back to default /mpm url [@p] clear)", new Object[0]);
        }
        String url = args[0];
        for (int i = 1; i < args.length; ++i) {
            url = url + " " + args[i];
        }
        if (url.equalsIgnoreCase("clear")) {
            url = "";
        }
        data.url = url;
        Server.sendAssociatedData((Entity)player, EnumPackets.SEND_PLAYER_DATA, player.func_110124_au(), data.writeToNBT());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendmodel(MinecraftServer server, EntityPlayer fromPlayer, String[] args, ModelData fromData) throws WrongUsageException {
        if (args.length < 1) {
            throw new WrongUsageException("/mpm sendmodel [@from_player] <@to_player> (to go back to default /mpm sendmodel [@p] clear)", new Object[0]);
        }
        EntityPlayerMP toPlayer = null;
        ModelData toData = null;
        try {
            toPlayer = CommandMPM.func_184888_a((MinecraftServer)server, (ICommandSender)fromPlayer, (String)args[0]);
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        if (toPlayer == null || toPlayer == fromPlayer) {
            if (!args[0].equalsIgnoreCase("clear")) throw new WrongUsageException("/mpm sendmodel [@from_player] <@to_player> (to go back to default /mpm sendmodel [@p] clear)", new Object[0]);
            fromData = new ModelData();
        } else {
            toData = ModelData.get((EntityPlayer)toPlayer);
        }
        NBTTagCompound compound = fromData.writeToNBT();
        toData.readFromNBT(compound);
        toData.save();
        Server.sendAssociatedData((Entity)toPlayer, EnumPackets.SEND_PLAYER_DATA, toPlayer.func_110124_au(), compound);
    }

    private void scale(EntityPlayer player, String[] args, ModelData data) throws WrongUsageException {
        block4: {
            try {
                if (args.length == 1) {
                    Scale scale = Scale.Parse(args[0]);
                    data.head.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    data.body.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    data.arm1.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    data.arm2.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    data.leg1.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    data.leg2.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    Server.sendAssociatedData((Entity)player, EnumPackets.SEND_PLAYER_DATA, player.func_110124_au(), data.writeToNBT());
                    break block4;
                }
                if (args.length == 4) {
                    Scale scale = Scale.Parse(args[0]);
                    data.head.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    scale = Scale.Parse(args[1]);
                    data.body.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    scale = Scale.Parse(args[2]);
                    data.arm1.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    data.arm2.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    scale = Scale.Parse(args[3]);
                    data.leg1.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    data.leg2.setScale(scale.scaleX, scale.scaleY, scale.scaleZ);
                    Server.sendAssociatedData((Entity)player, EnumPackets.SEND_PLAYER_DATA, player.func_110124_au(), data.writeToNBT());
                    break block4;
                }
                throw new WrongUsageException("/mpm scale [@p] [head x,y,z] [body x,y,z] [arms x,y,z] [legs x,y,z]. Examples: /mpm scale @p 1, /mpm scale @p 1 1 1 1, /mpm scale 1,1,1 1,1,1 1,1,1 1,1,1", new Object[0]);
            }
            catch (NumberFormatException ex) {
                throw new WrongUsageException("None number given", new Object[0]);
            }
        }
    }

    public String func_71518_a(ICommandSender sender) {
        return "/mpm <url/model/scale/name/animation> [@p]";
    }

    @Override
    public int func_82362_a() {
        return 2;
    }

    public List func_184883_a(MinecraftServer server, ICommandSender par1, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandBase.func_175762_a((String[])args, this.sub);
        }
        if (args.length >= 2) {
            String type = args[0].toLowerCase();
            ArrayList<String> list = new ArrayList<String>();
            if (args.length == 2) {
                list.addAll(Arrays.asList(server.func_184103_al().func_72369_d()));
            }
            if (type.equals("model")) {
                list.addAll(this.entities.keySet());
            }
            if (type.equals("animation")) {
                for (EnumAnimation ani : EnumAnimation.values()) {
                    list.add(ani.name().toLowerCase());
                }
            }
            return CommandBase.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, par1, args, pos);
    }

    static class Scale {
        float scaleX;
        float scaleY;
        float scaleZ;

        Scale() {
        }

        private static Scale Parse(String s) throws NumberFormatException {
            Scale scale = new Scale();
            if (s.contains(",")) {
                String[] split = s.split(",");
                if (split.length != 3) {
                    throw new NumberFormatException("Not enough args given");
                }
                scale.scaleX = Float.parseFloat(split[0]);
                scale.scaleY = Float.parseFloat(split[1]);
                scale.scaleZ = Float.parseFloat(split[2]);
            } else {
                scale.scaleY = scale.scaleX = Float.parseFloat(s);
                scale.scaleZ = scale.scaleX;
            }
            return scale;
        }
    }
}

