/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator;

import java.io.File;
import java.util.ArrayList;
import minecrafttransportsimulator.items.instances.ItemPartEffector;
import minecrafttransportsimulator.items.instances.ItemPartEngine;
import minecrafttransportsimulator.items.instances.ItemPartGeneric;
import minecrafttransportsimulator.items.instances.ItemPartGroundDevice;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.items.instances.ItemPartInteractable;
import minecrafttransportsimulator.items.instances.ItemPartPropeller;
import minecrafttransportsimulator.items.instances.ItemPartSeat;
import minecrafttransportsimulator.mcinterface.InterfaceChunkloader;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfaceInput;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="mts", name="Minecraft Transport Simulator", version="20.6.2")
public class MasterLoader {
    public static final String MODID = "mts";
    public static final String MODNAME = "Minecraft Transport Simulator";
    public static final String MODVER = "20.6.2";
    public static Logger logger;
    public static String resourceDomain;
    public static String gameDirectory;
    @Mod.Instance(value="mts")
    public static MasterLoader INSTANCE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        InterfaceCore.flushLogQueue();
        InterfaceCore.logError("Welcome to MTS VERSION:20.6.2");
        gameDirectory = event.getModConfigurationDirectory().getParent();
        ConfigSystem.loadFromDisk(new File(gameDirectory, "config"));
        ArrayList<File> packDirectories = new ArrayList<File>();
        File modDirectory = new File(gameDirectory, "mods");
        if (modDirectory.exists()) {
            packDirectories.add(modDirectory);
            File versionedModDirectory = new File(modDirectory, InterfaceCore.getGameVersion());
            if (versionedModDirectory.exists()) {
                packDirectories.add(versionedModDirectory);
            }
            PackParserSystem.addDefaultItems();
            PackParserSystem.parsePacks(packDirectories);
        } else {
            InterfaceCore.logError("Could not find mods directory!  Game directory is confirmed to: " + gameDirectory);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        InterfacePacket.init();
        ConfigSystem.configObject.fuel.lastLoadedFluids = InterfaceCore.getAllFluids();
        ConfigSystem.saveToDisk();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)INSTANCE, (ForgeChunkManager.LoadingCallback)InterfaceChunkloader.INSTANCE);
        if (event.getSide().isClient()) {
            InterfaceInput.initConfigKey();
        }
    }

    static {
        FluidRegistry.enableUniversalBucket();
        resourceDomain = MODID;
        PackParserSystem.addItemPartCreator(ItemPartEffector.CREATOR);
        PackParserSystem.addItemPartCreator(ItemPartEngine.CREATOR);
        PackParserSystem.addItemPartCreator(ItemPartGeneric.CREATOR);
        PackParserSystem.addItemPartCreator(ItemPartGroundDevice.CREATOR);
        PackParserSystem.addItemPartCreator(ItemPartGun.CREATOR);
        PackParserSystem.addItemPartCreator(ItemPartInteractable.CREATOR);
        PackParserSystem.addItemPartCreator(ItemPartPropeller.CREATOR);
        PackParserSystem.addItemPartCreator(ItemPartSeat.CREATOR);
    }
}

