/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import minecrafttransportsimulator.baseclasses.Point3d;

public class BezierCurve {
    public final Point3d startPos;
    public final Point3d endPos;
    public final float startAngle;
    public final float endAngle;
    public final float pathLength;
    private final float[][] cachedPathPoints;
    private final float[][] cachedPathRotations;
    public static final int CURVE_STEP = 16;

    public BezierCurve(Point3d startPos, Point3d endPos, float startAngle, float endAngle) {
        this.startPos = startPos;
        this.endPos = endPos;
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        float[] startPoint = new float[]{(float)startPos.x, (float)startPos.y, (float)startPos.z};
        float[] endPoint = new float[]{(float)endPos.x, (float)endPos.y, (float)endPos.z};
        float midPointDistance = (float)Math.sqrt(Math.pow(endPoint[0] - startPoint[0], 2.0) + Math.pow(endPoint[1] - startPoint[1], 2.0) + Math.pow(endPoint[2] - startPoint[2], 2.0)) / 3.0f;
        float[] startCurvePoint = new float[]{(float)((double)startPoint[0] + Math.sin(Math.toRadians(startAngle)) * (double)midPointDistance), startPoint[1], (float)((double)startPoint[2] + Math.cos(Math.toRadians(startAngle)) * (double)midPointDistance)};
        float[] endCurvePoint = new float[]{(float)((double)endPoint[0] + Math.sin(Math.toRadians(endAngle)) * (double)midPointDistance), endPoint[1], (float)((double)endPoint[2] + Math.cos(Math.toRadians(endAngle)) * (double)midPointDistance)};
        this.pathLength = BezierCurve.getPathLength(startPoint, endPoint, startCurvePoint, endCurvePoint);
        float[] pathPointsX = BezierCurve.getCachedPathPoints(startPoint[0], endPoint[0], startCurvePoint[0], endCurvePoint[0], this.pathLength);
        float[] pathPointsY = BezierCurve.getCachedPathPoints(startPoint[1], endPoint[1], startCurvePoint[1], endCurvePoint[1], this.pathLength);
        float[] pathPointsZ = BezierCurve.getCachedPathPoints(startPoint[2], endPoint[2], startCurvePoint[2], endCurvePoint[2], this.pathLength);
        this.cachedPathPoints = new float[Math.round(this.pathLength * 16.0f) + 1][3];
        this.cachedPathRotations = new float[Math.round(this.pathLength * 16.0f) + 1][3];
        for (int i = 0; i < this.cachedPathPoints.length; ++i) {
            this.cachedPathPoints[i][0] = pathPointsX[i];
            this.cachedPathPoints[i][1] = pathPointsY[i];
            this.cachedPathPoints[i][2] = pathPointsZ[i];
            if (i <= 0) continue;
            this.cachedPathRotations[i][0] = (float)(-Math.toDegrees(Math.atan((double)(this.cachedPathPoints[i][1] - this.cachedPathPoints[i - 1][1]) / Math.hypot(this.cachedPathPoints[i][0] - this.cachedPathPoints[i - 1][0], this.cachedPathPoints[i][2] - this.cachedPathPoints[i - 1][2]))));
            this.cachedPathRotations[i][1] = (float)((360.0 + Math.toDegrees(Math.atan2(this.cachedPathPoints[i][0] - this.cachedPathPoints[i - 1][0], this.cachedPathPoints[i][2] - this.cachedPathPoints[i - 1][2]))) % 360.0);
            this.cachedPathRotations[i][2] = 0.0f;
        }
        this.cachedPathRotations[0] = this.cachedPathRotations[1];
    }

    public BezierCurve generateOffsetCurve(float offset) {
        Point3d testRotation = new Point3d();
        Point3d newStartPos = new Point3d(offset, 0.0, 0.0);
        this.setPointToRotationAt(testRotation, 0.0f);
        newStartPos.rotateFine(testRotation);
        this.offsetPointByPositionAt(newStartPos, 0.0f);
        Point3d newEndPos = new Point3d(offset, 0.0, 0.0);
        this.setPointToRotationAt(testRotation, this.pathLength);
        newEndPos.rotateFine(testRotation);
        this.offsetPointByPositionAt(newEndPos, this.pathLength);
        return new BezierCurve(newStartPos, newEndPos, this.startAngle, this.endAngle);
    }

    public void setPointToPositionAt(Point3d point, float segmentPoint) {
        float[] cachedPoint = this.cachedPathPoints[Math.round(segmentPoint * 16.0f)];
        point.set(cachedPoint[0], cachedPoint[1], cachedPoint[2]);
    }

    public void offsetPointByPositionAt(Point3d point, float segmentPoint) {
        float delta = segmentPoint * 16.0f;
        int lowIndex = (int)Math.floor(delta);
        int highIndex = (int)Math.ceil(delta);
        if (highIndex >= this.cachedPathPoints.length) {
            highIndex = lowIndex;
            delta = 0.0f;
        } else {
            delta -= (float)lowIndex;
        }
        float[] cachedLowPoint = this.cachedPathPoints[lowIndex];
        float[] cachedHighPoint = this.cachedPathPoints[highIndex];
        point.add(cachedLowPoint[0] + (cachedHighPoint[0] - cachedLowPoint[0]) * delta, cachedLowPoint[1] + (cachedHighPoint[1] - cachedLowPoint[1]) * delta, cachedLowPoint[2] + (cachedHighPoint[2] - cachedLowPoint[2]) * delta);
    }

    public void setPointToRotationAt(Point3d rotation, float segmentPoint) {
        float[] cachedRotation = this.cachedPathRotations[Math.round(segmentPoint * 16.0f)];
        rotation.set(cachedRotation[0], cachedRotation[1], cachedRotation[2]);
    }

    private static float getPathLength(float[] startPoint, float[] endPoint, float[] startCurvePoint, float[] endCurvePoint) {
        float dist1 = (float)Math.sqrt(Math.pow(endPoint[0] - startPoint[0], 2.0) + Math.pow(endPoint[1] - startPoint[1], 2.0) + Math.pow(endPoint[2] - startPoint[2], 2.0));
        float dist2 = (float)Math.sqrt(Math.pow(startCurvePoint[0] - startPoint[0], 2.0) + Math.pow(startCurvePoint[1] - startPoint[1], 2.0) + Math.pow(startCurvePoint[2] - startPoint[2], 2.0));
        float dist3 = (float)Math.sqrt(Math.pow(endCurvePoint[0] - startCurvePoint[0], 2.0) + Math.pow(endCurvePoint[1] - startCurvePoint[1], 2.0) + Math.pow(endCurvePoint[2] - startCurvePoint[2], 2.0));
        float dist4 = (float)Math.sqrt(Math.pow(endPoint[0] - endCurvePoint[0], 2.0) + Math.pow(endPoint[1] - endCurvePoint[1], 2.0) + Math.pow(endPoint[2] - endCurvePoint[2], 2.0));
        return (dist1 + dist2 + dist3 + dist4) / 2.0f;
    }

    private static float[] getCachedPathPoints(float startPoint, float endPoint, float startCurvePoint, float endCurvePoint, float pathLength) {
        float[] points = new float[Math.round(pathLength * 16.0f) + 1];
        if (startPoint == endPoint) {
            for (int i = 0; i < points.length; ++i) {
                points[i] = startPoint;
            }
        } else {
            for (int i = 0; i < points.length; ++i) {
                float segmentPercentage = (float)i / ((float)(points.length - 1) * 1.0f);
                points[i] = (float)(Math.pow(1.0f - segmentPercentage, 3.0) * (double)startPoint + 3.0 * Math.pow(1.0f - segmentPercentage, 2.0) * (double)segmentPercentage * (double)startCurvePoint + (double)(3.0f * (1.0f - segmentPercentage)) * Math.pow(segmentPercentage, 2.0) * (double)endCurvePoint + Math.pow(segmentPercentage, 3.0) * (double)endPoint);
            }
        }
        return points;
    }
}

