/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.mcinterface.InterfaceRender;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import net.minecraft.util.math.AxisAlignedBB;

public class BoundingBox {
    private static final double HITBOX_CLAMP = 0.015625;
    public final Point3d localCenter;
    public final Point3d globalCenter;
    public final Point3d currentCollisionDepth;
    public final List<Point3d> collidingBlockPositions = new ArrayList<Point3d>();
    public final RenderableObject renderable;
    private final Point3d tempGlobalCenter;
    public double widthRadius;
    public double heightRadius;
    public double depthRadius;
    public final boolean collidesWithLiquids;
    public final JSONCollisionBox definition;

    public BoundingBox(Point3d center, double widthRadius, double heightRadius, double depthRadius) {
        this(center, center, widthRadius, heightRadius, depthRadius, false, null, null);
    }

    public BoundingBox(Point3d localCenter, Point3d globalCenter, double widthRadius, double heightRadius, double depthRadius, boolean collidesWithLiquids) {
        this(localCenter, globalCenter, widthRadius, heightRadius, depthRadius, collidesWithLiquids, null, null);
    }

    public BoundingBox(JSONCollisionBox definition, JSONCollisionGroup groupDef) {
        this(definition.pos, definition.pos.copy(), (double)definition.width / 2.0, (double)definition.height / 2.0, (double)definition.width / 2.0, definition.collidesWithLiquids, definition, groupDef);
    }

    private BoundingBox(Point3d localCenter, Point3d globalCenter, double widthRadius, double heightRadius, double depthRadius, boolean collidesWithLiquids, JSONCollisionBox definition, JSONCollisionGroup groupDef) {
        this.localCenter = localCenter;
        this.globalCenter = globalCenter;
        this.tempGlobalCenter = globalCenter.copy();
        this.currentCollisionDepth = new Point3d();
        this.widthRadius = widthRadius;
        this.heightRadius = heightRadius;
        this.depthRadius = depthRadius;
        this.collidesWithLiquids = collidesWithLiquids;
        this.definition = definition;
        ColorRGB boxColor = definition != null ? (definition.variableName != null ? ColorRGB.GREEN : (groupDef != null && !groupDef.isInterior ? ColorRGB.RED : ColorRGB.BLACK)) : ColorRGB.YELLOW;
        this.renderable = new RenderableObject(this, new ColorRGB(boxColor.rgbInt), false);
    }

    public String toString() {
        return "LocalCenter:" + this.localCenter.toString() + " GlobalCenter:" + this.globalCenter.toString() + " Width:" + this.widthRadius + " Height:" + this.heightRadius + " Depth:" + this.depthRadius;
    }

    public boolean updateCollidingBlocks(WrapperWorld world, Point3d offset) {
        return this.updateCollisions(world, offset, false);
    }

    public boolean updateMovingCollisions(WrapperWorld world, Point3d offset) {
        return this.updateCollisions(world, offset, true);
    }

    private boolean updateCollisions(WrapperWorld world, Point3d offset, boolean ignoreIfGreater) {
        this.tempGlobalCenter.setTo(this.globalCenter);
        this.globalCenter.add(offset);
        world.updateBoundingBoxCollisions(this, offset, ignoreIfGreater);
        this.globalCenter.setTo(this.tempGlobalCenter);
        return !this.collidingBlockPositions.isEmpty();
    }

    public void updateToEntity(AEntityD_Definable<?> entity, Point3d optionalOffset) {
        this.globalCenter.setTo(this.localCenter);
        if (optionalOffset != null) {
            this.globalCenter.add(optionalOffset);
        }
        this.globalCenter.rotateFine(entity.angles).add(entity.position);
        if (this.definition != null) {
            this.globalCenter.x = (double)((int)(this.globalCenter.x / 0.015625)) * 0.015625;
            this.globalCenter.y = (double)((int)(this.globalCenter.y / 0.015625)) * 0.015625;
            this.globalCenter.z = (double)((int)(this.globalCenter.z / 0.015625)) * 0.015625;
        }
        if (entity.world.isClient() && InterfaceRender.shouldRenderBoundingBoxes()) {
            this.renderable.setWireframeBoundingBox(this);
        }
    }

    public float[][] getEdgePoints() {
        float[][] points = new float[8][];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    points[i * 4 + j * 2 + k] = new float[]{(float)(i == 0 ? -this.widthRadius : this.widthRadius), (float)(j == 0 ? -this.heightRadius : this.heightRadius), (float)(k == 0 ? -this.depthRadius : this.depthRadius)};
                }
            }
        }
        return points;
    }

    public boolean isPointInside(Point3d point) {
        return this.globalCenter.x - this.widthRadius <= point.x && this.globalCenter.x + this.widthRadius >= point.x && this.globalCenter.y - this.heightRadius <= point.y && this.globalCenter.y + this.heightRadius >= point.y && this.globalCenter.z - this.depthRadius <= point.z && this.globalCenter.z + this.depthRadius >= point.z;
    }

    public boolean intersects(BoundingBox box) {
        return this.globalCenter.x - this.widthRadius < box.globalCenter.x + box.widthRadius && this.globalCenter.x + this.widthRadius > box.globalCenter.x - box.widthRadius && this.globalCenter.y - this.heightRadius < box.globalCenter.y + box.heightRadius && this.globalCenter.y + this.heightRadius > box.globalCenter.y - box.heightRadius && this.globalCenter.z - this.depthRadius < box.globalCenter.z + box.depthRadius && this.globalCenter.z + this.depthRadius > box.globalCenter.z - box.depthRadius;
    }

    public boolean intersectsWithYZ(Point3d point) {
        return point.y >= this.globalCenter.y - this.heightRadius && point.y <= this.globalCenter.y + this.heightRadius && point.z >= this.globalCenter.z - this.depthRadius && point.z <= this.globalCenter.z + this.depthRadius;
    }

    public boolean intersectsWithXZ(Point3d point) {
        return point.x >= this.globalCenter.x - this.widthRadius && point.x <= this.globalCenter.x + this.widthRadius && point.z >= this.globalCenter.z - this.depthRadius && point.z <= this.globalCenter.z + this.depthRadius;
    }

    public boolean intersectsWithXY(Point3d point) {
        return point.x >= this.globalCenter.x - this.widthRadius && point.x <= this.globalCenter.x + this.widthRadius && point.y >= this.globalCenter.y - this.heightRadius && point.y <= this.globalCenter.y + this.heightRadius;
    }

    public Point3d getXPlaneCollision(Point3d start, Point3d end, double xPoint) {
        Point3d collisionPoint = start.getIntermediateWithXValue(end, xPoint);
        return collisionPoint != null && this.intersectsWithYZ(collisionPoint) ? collisionPoint : null;
    }

    public Point3d getYPlaneCollision(Point3d start, Point3d end, double yPoint) {
        Point3d collisionPoint = start.getIntermediateWithYValue(end, yPoint);
        return collisionPoint != null && this.intersectsWithXZ(collisionPoint) ? collisionPoint : null;
    }

    public Point3d getZPlaneCollision(Point3d start, Point3d end, double zPoint) {
        Point3d collisionPoint = start.getIntermediateWithZValue(end, zPoint);
        return collisionPoint != null && this.intersectsWithXY(collisionPoint) ? collisionPoint : null;
    }

    public Point3d getIntersectionPoint(Point3d start, Point3d end) {
        Point3d intersection = this.getXPlaneCollision(start, end, this.globalCenter.x - this.widthRadius);
        Point3d secondIntersection = this.getXPlaneCollision(start, end, this.globalCenter.x + this.widthRadius);
        if (secondIntersection != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        if ((secondIntersection = this.getYPlaneCollision(start, end, this.globalCenter.y - this.heightRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        if ((secondIntersection = this.getYPlaneCollision(start, end, this.globalCenter.y + this.heightRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        if ((secondIntersection = this.getZPlaneCollision(start, end, this.globalCenter.z - this.depthRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        if ((secondIntersection = this.getZPlaneCollision(start, end, this.globalCenter.z + this.depthRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        return intersection;
    }

    public AxisAlignedBB convert() {
        return new AxisAlignedBB(this.globalCenter.x - this.widthRadius, this.globalCenter.y - this.heightRadius, this.globalCenter.z - this.depthRadius, this.globalCenter.x + this.widthRadius, this.globalCenter.y + this.heightRadius, this.globalCenter.z + this.depthRadius);
    }

    public AxisAlignedBB convertWithOffset(double x, double y, double z) {
        return new AxisAlignedBB(x + this.globalCenter.x - this.widthRadius, y + this.globalCenter.y - this.heightRadius, z + this.globalCenter.z - this.depthRadius, x + this.globalCenter.x + this.widthRadius, y + this.globalCenter.y + this.heightRadius, z + this.globalCenter.z + this.depthRadius);
    }
}

