/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

public class ColorRGB {
    public static final ColorRGB WHITE = new ColorRGB(255, 255, 255);
    public static final ColorRGB BLACK = new ColorRGB(0, 0, 0);
    public static final ColorRGB LIGHT_GRAY = new ColorRGB(192, 192, 192);
    public static final ColorRGB GRAY = new ColorRGB(128, 128, 128);
    public static final ColorRGB DARK_GRAY = new ColorRGB(64, 64, 64);
    public static final ColorRGB RED = new ColorRGB(255, 0, 0);
    public static final ColorRGB GREEN = new ColorRGB(0, 255, 0);
    public static final ColorRGB BLUE = new ColorRGB(0, 0, 255);
    public static final ColorRGB CYAN = new ColorRGB(0, 255, 255);
    public static final ColorRGB MAGENTA = new ColorRGB(255, 0, 255);
    public static final ColorRGB YELLOW = new ColorRGB(255, 255, 0);
    public static final ColorRGB PINK = new ColorRGB(255, 175, 175);
    public static final ColorRGB ORANGE = new ColorRGB(255, 200, 0);
    public float red;
    public float green;
    public float blue;
    public int rgbInt;
    public int[] hsv;

    public ColorRGB() {
        this(1.0f, 1.0f, 1.0f, false);
    }

    public ColorRGB(String hexRGB) {
        this(Integer.decode("#" + hexRGB.substring(hexRGB.length() - 6)));
    }

    public ColorRGB(int packedRGB) {
        this(packedRGB >> 16 & 0xFF, packedRGB >> 8 & 0xFF, packedRGB & 0xFF);
    }

    public ColorRGB(int red, int green, int blue) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, false);
    }

    public ColorRGB(float red, float green, float blue, boolean isHSV) {
        float finalBlue;
        float finalGreen;
        float finalRed;
        if (isHSV) {
            this.hsv = new int[]{(int)red, (int)green, (int)blue};
            float[] RGB = ColorRGB.HSVtoRGB(red % 360.0f, green / 100.0f, blue / 100.0f);
            finalRed = RGB[0];
            finalGreen = RGB[1];
            finalBlue = RGB[2];
        } else {
            finalRed = red;
            finalGreen = green;
            finalBlue = blue;
            this.hsv = ColorRGB.RGBtoHSV(red, green, blue);
        }
        this.red = finalRed;
        this.green = finalGreen;
        this.blue = finalBlue;
        this.rgbInt = (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static float[] HSVtoRGB(float hue, float saturation, float value) {
        float c = value * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = value - c;
        if (hue < 60.0f) {
            return new float[]{c + m, x + m, m};
        }
        if (hue < 120.0f) {
            return new float[]{x + m, c + m, m};
        }
        if (hue < 180.0f) {
            return new float[]{m, c + m, x + m};
        }
        if (hue < 240.0f) {
            return new float[]{m, x + m, c + m};
        }
        if (hue < 300.0f) {
            return new float[]{x + m, m, c + m};
        }
        return new float[]{c + m, m, x + m};
    }

    public static int[] RGBtoHSV(float red, float green, float blue) {
        float cMax = Math.max(red /= 255.0f, Math.max(green /= 255.0f, blue /= 255.0f));
        float cMin = Math.min(red, Math.min(green, blue));
        float diff = cMax - cMin;
        int hue = 0;
        int saturation = 0;
        hue = cMax == cMin ? 0 : (cMax == red ? (int)(60.0f * ((green - blue) / diff) + 360.0f) % 360 : (cMax == green ? (int)(60.0f * ((blue - red) / diff) + 120.0f) % 360 : (int)(60.0f * ((red - green) / diff) + 240.0f) % 360));
        saturation = cMax == 0.0f ? 0 : (int)(diff / cMax) * 100;
        int value = (int)cMax * 100;
        return new int[]{hue, saturation, value};
    }

    public boolean equals(Object object) {
        if (object instanceof ColorRGB) {
            ColorRGB otherColor = (ColorRGB)object;
            return this.red == otherColor.red && this.blue == otherColor.blue && this.green == otherColor.green;
        }
        return false;
    }

    public String toString() {
        return "[" + this.red + ", " + this.green + ", " + this.blue + "]";
    }

    public void setTo(ColorRGB color) {
        this.red = color.red;
        this.green = color.green;
        this.blue = color.blue;
        this.rgbInt = color.rgbInt;
        this.hsv = color.hsv;
    }
}

