/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.WrapperEntity;

public class Damage {
    public final String name;
    public final double amount;
    public final BoundingBox box;
    public final AEntityB_Existing damgeSource;
    public final WrapperEntity entityResponsible;
    public boolean isFire;
    public boolean isWater;
    public boolean isExplosion;
    public boolean ignoreArmor;
    public boolean ignoreCooldown;
    public List<JSONPotionEffect> effects;

    public Damage(String name, double amount, BoundingBox box, AEntityB_Existing damgeSource, WrapperEntity entityResponsible) {
        this.name = name;
        this.amount = amount;
        this.box = box;
        this.damgeSource = damgeSource;
        this.entityResponsible = entityResponsible;
    }

    public void setBullet(ItemBullet bulletItem) {
        this.ignoreCooldown = true;
        if (((JSONBullet)bulletItem.definition).bullet.types.contains((Object)JSONBullet.BulletType.WATER)) {
            this.isWater = true;
        }
        if (((JSONBullet)bulletItem.definition).bullet.types.contains((Object)JSONBullet.BulletType.INCENDIARY)) {
            this.isFire = true;
        }
        if (((JSONBullet)bulletItem.definition).bullet.types.contains((Object)JSONBullet.BulletType.ARMOR_PIERCING)) {
            this.ignoreArmor = true;
        }
        this.effects = ((JSONBullet)bulletItem.definition).bullet.effects;
    }

    public Damage setFire() {
        this.isFire = true;
        return this;
    }

    public Damage setWater() {
        this.isWater = true;
        return this;
    }

    public Damage setExplosive() {
        this.isExplosion = true;
        return this;
    }

    public Damage setEffects(List<JSONPotionEffect> effects) {
        this.effects = effects;
        return this;
    }

    public Damage ignoreArmor() {
        this.ignoreArmor = true;
        return this;
    }

    public Damage ignoreCooldown() {
        this.ignoreCooldown = true;
        return this;
    }
}

