/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.Map;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.systems.ConfigSystem;

public interface IInventoryProvider {
    default public double getInventoryMass() {
        Map<String, Double> heavyItems = ConfigSystem.configObject.general.itemWeights.weights;
        double currentMass = 0.0;
        for (int i = 0; i < this.getSize(); ++i) {
            WrapperItemStack stack = this.getStack(i);
            double weightMultiplier = 1.0;
            for (String heavyItemName : heavyItems.keySet()) {
                if (!InterfaceCore.getStackItemName(stack).contains(heavyItemName)) continue;
                weightMultiplier = heavyItems.get(heavyItemName);
                break;
            }
            currentMass += (double)(5.0f * (float)stack.getSize() / (float)stack.getMaxSize()) * weightMultiplier;
        }
        return currentMass;
    }

    public int getSize();

    default public int getCount() {
        int count = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getStack(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    default public boolean isStackValid(WrapperItemStack stackToCheck, int index) {
        return true;
    }

    public WrapperItemStack getStack(int var1);

    public void setStack(WrapperItemStack var1, int var2);

    default public boolean addStack(WrapperItemStack stackToAdd, int qty, boolean doAdd) {
        for (int i = 0; i < this.getSize(); ++i) {
            int amountToAdd;
            if (!this.isStackValid(stackToAdd, i)) continue;
            WrapperItemStack stack = this.getStack(i);
            if (stack.isEmpty()) {
                if (doAdd) {
                    this.setStack(stackToAdd.split(qty), i);
                    qty = 0;
                }
                return true;
            }
            if (!stackToAdd.isCompleteMatch(stack) || (amountToAdd = Math.min(stack.getMaxSize() - stack.getSize(), qty)) <= 0) continue;
            if (doAdd) {
                stack.add(amountToAdd);
                this.setStack(stack, i);
                stackToAdd.add(-amountToAdd);
                qty -= amountToAdd;
                continue;
            }
            return true;
        }
        return qty == 0;
    }

    default public boolean addStack(WrapperItemStack stackToAdd) {
        return this.addStack(stackToAdd, stackToAdd.getSize(), true);
    }

    default public boolean removeStack(WrapperItemStack referenceStack, int qtyToRemove) {
        WrapperItemStack stack;
        int i;
        int qtyFound = qtyToRemove;
        for (i = 0; i < this.getSize(); ++i) {
            stack = this.getStack(i);
            if (!InterfaceCore.isOredictMatch(stack, referenceStack)) continue;
            qtyFound += stack.getSize();
        }
        if (qtyFound > qtyToRemove) {
            qtyToRemove = -qtyToRemove;
            for (i = 0; i < this.getSize(); ++i) {
                stack = this.getStack(i);
                if (!InterfaceCore.isOredictMatch(stack, referenceStack)) continue;
                qtyToRemove = stack.add(qtyToRemove);
                this.setStack(stack, i);
            }
        }
        return qtyToRemove == 0;
    }

    default public int getSlotForStack(WrapperItemStack stackToFind) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!InterfaceCore.isOredictMatch(this.getStack(i), stackToFind)) continue;
            return i;
        }
        return -1;
    }

    default public boolean addToSlot(int index, int qty) {
        WrapperItemStack stack = this.getStack(index);
        if (stack.getSize() + qty < stack.getMaxSize()) {
            stack.add(qty);
            this.setStack(stack, index);
            return true;
        }
        return false;
    }

    default public boolean removeFromSlot(int index, int qty) {
        WrapperItemStack stack = this.getStack(index);
        if (stack.getSize() - qty >= 0) {
            stack.add(-qty);
            this.setStack(stack, index);
            return true;
        }
        return false;
    }

    default public boolean hasMaterials(AItemPack<?> item, boolean includeMain, boolean includeSub, boolean forRepair) {
        for (PackMaterialComponent material : PackMaterialComponent.parseFromJSON(item, includeMain, includeSub, true, forRepair)) {
            int requiredMaterialCount = material.qty;
            for (WrapperItemStack materialStack : material.possibleItems) {
                for (int i = 0; i < this.getSize(); ++i) {
                    WrapperItemStack testStack = this.getStack(i);
                    if (!InterfaceCore.isOredictMatch(testStack, materialStack)) continue;
                    requiredMaterialCount -= testStack.getSize();
                }
            }
            if (requiredMaterialCount <= 0) continue;
            return false;
        }
        return true;
    }

    default public void removeMaterials(AItemPack<?> item, boolean includeMain, boolean includeSub, boolean forRepair) {
        for (PackMaterialComponent material : PackMaterialComponent.parseFromJSON(item, includeMain, includeSub, true, forRepair)) {
            for (WrapperItemStack stack : material.possibleItems) {
                this.removeStack(stack, material.qty);
            }
        }
    }

    default public double getExplosiveness() {
        double explosivePower = 0.0;
        for (int i = 0; i < this.getSize(); ++i) {
            WrapperItemStack stack = this.getStack(i);
            AItemBase item = stack.getItem();
            if (!(item instanceof ItemBullet)) continue;
            ItemBullet bullet = (ItemBullet)item;
            if (((JSONBullet)bullet.definition).bullet == null) continue;
            double blastSize = ((JSONBullet)bullet.definition).bullet.blastStrength == 0.0f ? (double)((JSONBullet)bullet.definition).bullet.diameter / 10.0 : (double)((JSONBullet)bullet.definition).bullet.blastStrength;
            explosivePower += (double)stack.getSize() * blastSize / 10.0;
        }
        return explosivePower;
    }
}

