/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperWorld;

public class NavBeacon {
    private static final String BEACON_LISTING_KEY = "beacons";
    private static final Map<WrapperWorld, Map<String, NavBeacon>> cachedBeaconMaps = new HashMap<WrapperWorld, Map<String, NavBeacon>>();
    public final String name;
    public final double glideSlope;
    public final double bearing;
    public final Point3d position;

    public static NavBeacon getByNameFromWorld(WrapperWorld world, String name) {
        if (!cachedBeaconMaps.containsKey(world)) {
            WrapperNBT beaconListing = world.getData(BEACON_LISTING_KEY);
            if (beaconListing != null) {
                HashMap<String, NavBeacon> beaconMap = new HashMap<String, NavBeacon>();
                for (String beaconName : beaconListing.getAllNames()) {
                    beaconMap.put(beaconName, new NavBeacon(beaconListing.getData(beaconName)));
                }
                cachedBeaconMaps.put(world, beaconMap);
            } else {
                return null;
            }
        }
        return cachedBeaconMaps.get(world).get(name);
    }

    public static void removeFromWorld(WrapperWorld world, String name) {
        if (name != null) {
            WrapperNBT beaconListing;
            if (cachedBeaconMaps.containsKey(world)) {
                cachedBeaconMaps.get(world).remove(name);
            }
            if ((beaconListing = world.getData(BEACON_LISTING_KEY)) != null) {
                beaconListing.deleteData(name);
                world.setData(BEACON_LISTING_KEY, beaconListing);
            }
        }
    }

    private NavBeacon(WrapperNBT data) {
        this.name = data.getString("name");
        this.glideSlope = data.getDouble("glideSlope");
        this.bearing = data.getDouble("bearing");
        this.position = data.getPoint3dCompact("location");
    }

    public NavBeacon(WrapperWorld world, String name, double glideSlope, double bearing, Point3d position) {
        this.name = name;
        this.glideSlope = glideSlope;
        this.bearing = bearing;
        this.position = position;
        WrapperNBT beaconListing = world.getData(BEACON_LISTING_KEY);
        if (beaconListing == null) {
            beaconListing = new WrapperNBT();
        }
        beaconListing.setData(name, this.save(new WrapperNBT()));
        world.setData(BEACON_LISTING_KEY, beaconListing);
    }

    public double getBearingDelta(AEntityB_Existing entity) {
        double delta;
        for (delta = Math.toDegrees(Math.atan2(entity.position.x - this.position.x, entity.position.z - this.position.z)) + this.bearing + 180.0; delta < -180.0; delta += 360.0) {
        }
        while (delta > 180.0) {
            delta -= 360.0;
        }
        return delta;
    }

    public WrapperNBT save(WrapperNBT data) {
        data.setString("name", this.name);
        data.setDouble("glideSlope", this.glideSlope);
        data.setDouble("bearing", this.bearing);
        data.setPoint3dCompact("location", this.position);
        return data;
    }
}

