/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.Point3d;
import org.lwjgl.BufferUtils;

public class Orientation3d {
    public final Point3d axis;
    public double rotation;
    public double rotationX;
    public double rotationY;
    public final FloatBuffer buffer;
    private double x;
    private double y;
    private double z;
    private double w;

    public Orientation3d() {
        this(new Point3d(0.0, 0.0, 1.0), 0.0, false);
    }

    public Orientation3d(Point3d axis, double rotation, boolean usedInRendering) {
        this.axis = axis;
        this.rotation = rotation;
        this.buffer = usedInRendering ? BufferUtils.createFloatBuffer((int)16) : null;
        this.updateQuaternion(false);
    }

    public void updateQuaternion(boolean useQuaternionValues) {
        if (useQuaternionValues) {
            double scale = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            this.axis.x = this.x / scale;
            this.axis.y = this.y / scale;
            this.axis.z = this.z / scale;
            this.rotation = Math.acos(this.w) * 2.0;
        } else {
            double rotationInRad = Math.toRadians(this.rotation);
            double sinRad = Math.sin(rotationInRad / 2.0);
            double cosRad = Math.cos(rotationInRad / 2.0);
            this.x = this.axis.x * sinRad;
            this.y = this.axis.y * sinRad;
            this.z = this.axis.z * sinRad;
            this.w = cosRad;
        }
        double theta = Math.asin(this.axis.y);
        double phi = Math.atan2(this.axis.x, this.axis.z);
        this.rotationX = -Math.toDegrees(theta);
        this.rotationY = Math.toDegrees(phi);
        if (this.buffer != null) {
            this.buffer.clear();
            float f = (float)(this.x * this.x);
            float f1 = (float)(this.x * this.y);
            float f2 = (float)(this.x * this.z);
            float f3 = (float)(this.x * this.w);
            float f4 = (float)(this.y * this.y);
            float f5 = (float)(this.y * this.z);
            float f6 = (float)(this.y * this.w);
            float f7 = (float)(this.z * this.z);
            float f8 = (float)(this.z * this.w);
            this.buffer.put(1.0f - 2.0f * (f4 + f7));
            this.buffer.put(2.0f * (f1 + f8));
            this.buffer.put(2.0f * (f2 - f6));
            this.buffer.put(0.0f);
            this.buffer.put(2.0f * (f1 - f8));
            this.buffer.put(1.0f - 2.0f * (f + f7));
            this.buffer.put(2.0f * (f5 + f3));
            this.buffer.put(0.0f);
            this.buffer.put(2.0f * (f2 + f6));
            this.buffer.put(2.0f * (f5 - f3));
            this.buffer.put(1.0f - 2.0f * (f + f4));
            this.buffer.put(0.0f);
            this.buffer.put(0.0f);
            this.buffer.put(0.0f);
            this.buffer.put(0.0f);
            this.buffer.put(1.0f);
            this.buffer.rewind();
        }
    }

    public Orientation3d setTo(Orientation3d other) {
        this.axis.setTo(other.axis);
        this.rotation = other.rotation;
        this.rotationX = other.rotationX;
        this.rotationY = other.rotationY;
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.w = other.w;
        if (this.buffer != null && other.buffer != null) {
            this.buffer.clear();
            this.buffer.put(other.buffer).rewind();
            other.buffer.rewind();
        }
        return this;
    }

    public Orientation3d rotateByOrientation(Orientation3d multiplyBy) {
        double mX = this.x * multiplyBy.w + this.w * multiplyBy.x + this.y * multiplyBy.z - this.z * multiplyBy.y;
        double mY = this.y * multiplyBy.w + this.w * multiplyBy.y + this.z * multiplyBy.x - this.x * multiplyBy.z;
        double mZ = this.z * multiplyBy.w + this.w * multiplyBy.z + this.x * multiplyBy.y - this.y * multiplyBy.x;
        double mW = this.w * multiplyBy.w - this.x * multiplyBy.x - this.y * multiplyBy.y - this.z * multiplyBy.z;
        this.x = mX;
        this.y = mY;
        this.z = mZ;
        this.w = mW;
        this.updateQuaternion(true);
        return this;
    }

    public Point3d rotatePoint(Point3d rotate, Point3d storeIn) {
        double mX = this.w * rotate.x + this.y * rotate.z - this.z * rotate.y;
        double mY = this.w * rotate.y + this.z * rotate.x - this.x * rotate.z;
        double mZ = this.w * rotate.z + this.x * rotate.y - this.y * rotate.x;
        double mW = this.x * rotate.x - this.y * rotate.y - this.z * rotate.z;
        storeIn.x = mX * this.w + mW * -this.x + mY * -this.z - mZ * -this.y;
        storeIn.y = mY * this.w + mW * -this.y + mZ * -this.x - mX * -this.z;
        storeIn.z = mZ * this.w + mW * -this.z + mX * -this.y - mY * -this.x;
        return storeIn;
    }

    public Point3d rotatePoint(Point3d rotate) {
        return this.rotatePoint(rotate, rotate);
    }

    public Orientation3d copy() {
        return new Orientation3d(this.axis.copy(), this.rotation, this.buffer != null);
    }
}

