/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

public class Point3d {
    private static final Point3d ZERO = new Point3d();
    public double x;
    public double y;
    public double z;
    private double lastCalcX;
    private double lastCalcY;
    private double lastCalcZ;
    private boolean calcedOnce;
    private final double[][] rotationMatrixFine = new double[3][3];

    public Point3d() {
        this(0.0, 0.0, 0.0);
    }

    public Point3d(Point3d other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public Point3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object object) {
        if (object instanceof Point3d) {
            Point3d otherPoint = (Point3d)object;
            return (float)this.x == (float)otherPoint.x && (float)this.y == (float)otherPoint.y && (float)this.z == (float)otherPoint.z;
        }
        return false;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public Point3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Point3d setTo(Point3d point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
        return this;
    }

    public Point3d add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Point3d add(Point3d point) {
        this.x += point.x;
        this.y += point.y;
        this.z += point.z;
        return this;
    }

    public Point3d addScaled(Point3d point, double scale) {
        this.x += point.x * scale;
        this.y += point.y * scale;
        this.z += point.z * scale;
        return this;
    }

    public Point3d subtract(Point3d point) {
        this.x -= point.x;
        this.y -= point.y;
        this.z -= point.z;
        return this;
    }

    public Point3d multiply(double scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public Point3d multiply(Point3d point) {
        this.x *= point.x;
        this.y *= point.y;
        this.z *= point.z;
        return this;
    }

    public Point3d invert() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public double distanceTo(Point3d point) {
        double deltaX = point.x - this.x;
        double deltaY = point.y - this.y;
        double deltaZ = point.z - this.z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public double dotProduct(Point3d point) {
        return this.x * point.x + this.y * point.y + this.z * point.z;
    }

    public Point3d crossProduct(Point3d point) {
        return new Point3d(this.y * point.z - this.z * point.y, this.z * point.x - this.x * point.z, this.x * point.y - this.y * point.x);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Point3d normalize() {
        double length = this.length();
        if (length > 1.0E-8) {
            this.x /= length;
            this.y /= length;
            this.z /= length;
        }
        return this;
    }

    public Point3d getInterpolatedPoint(Point3d endPoint, double factor) {
        return endPoint.copy().subtract(this).multiply(factor).add(this);
    }

    public double getClampedYDelta(double otherY) {
        double deltaYaw;
        for (deltaYaw = this.y - otherY; deltaYaw > 180.0; deltaYaw -= 360.0) {
        }
        while (deltaYaw < -180.0) {
            deltaYaw += 360.0;
        }
        return deltaYaw;
    }

    public Point3d getAngles(boolean normalize) {
        if (normalize) {
            this.normalize();
        }
        double theta = Math.asin(this.y);
        double phi = Math.atan2(this.x, this.z);
        this.set(-Math.toDegrees(theta), Math.toDegrees(phi), 0.0);
        return this;
    }

    public Point3d copy() {
        return new Point3d(this.x, this.y, this.z);
    }

    public boolean isZero() {
        return this.equals(ZERO);
    }

    public Point3d getIntermediateWithXValue(Point3d endPoint, double targetX) {
        Point3d delta = endPoint.copy().subtract(this);
        if (delta.x * delta.x < 1.0E-7) {
            return null;
        }
        double factor = (targetX - this.x) / delta.x;
        return factor >= 0.0 && factor <= 1.0 ? delta.multiply(factor).add(this) : null;
    }

    public Point3d getIntermediateWithYValue(Point3d endPoint, double targetY) {
        Point3d delta = endPoint.copy().subtract(this);
        if (delta.y * delta.y < 1.0E-7) {
            return null;
        }
        double factor = (targetY - this.y) / delta.y;
        return factor >= 0.0 && factor <= 1.0 ? delta.multiply(factor).add(this) : null;
    }

    public Point3d getIntermediateWithZValue(Point3d endPoint, double targetZ) {
        Point3d delta = endPoint.copy().subtract(this);
        if (delta.z * delta.z < 1.0E-7) {
            return null;
        }
        double factor = (targetZ - this.z) / delta.z;
        return factor >= 0.0 && factor <= 1.0 ? delta.multiply(factor).add(this) : null;
    }

    public Point3d rotateFine(Point3d angles) {
        if (!angles.isZero()) {
            if (angles.lastCalcX != angles.x || angles.lastCalcY != angles.y || angles.lastCalcZ != angles.z || !angles.calcedOnce) {
                double cosX = Math.cos(Math.toRadians(angles.x));
                double sinX = Math.sin(Math.toRadians(angles.x));
                double cosY = Math.cos(Math.toRadians(angles.y));
                double sinY = Math.sin(Math.toRadians(angles.y));
                double cosZ = Math.cos(Math.toRadians(angles.z));
                double sinZ = Math.sin(Math.toRadians(angles.z));
                angles.rotationMatrixFine[0][0] = cosY * cosZ - sinX * -sinY * sinZ;
                angles.rotationMatrixFine[0][1] = -sinX * -sinY * cosZ - cosY * sinZ;
                angles.rotationMatrixFine[0][2] = -cosX * -sinY;
                angles.rotationMatrixFine[1][0] = cosX * sinZ;
                angles.rotationMatrixFine[1][1] = cosX * cosZ;
                angles.rotationMatrixFine[1][2] = -sinX;
                angles.rotationMatrixFine[2][0] = -sinY * cosZ + sinX * cosY * sinZ;
                angles.rotationMatrixFine[2][1] = sinX * cosY * cosZ + sinY * sinZ;
                angles.rotationMatrixFine[2][2] = cosX * cosY;
                angles.lastCalcX = angles.x;
                angles.lastCalcY = angles.y;
                angles.lastCalcZ = angles.z;
                angles.calcedOnce = true;
            }
            this.set(this.x * angles.rotationMatrixFine[0][0] + this.y * angles.rotationMatrixFine[0][1] + this.z * angles.rotationMatrixFine[0][2], this.x * angles.rotationMatrixFine[1][0] + this.y * angles.rotationMatrixFine[1][1] + this.z * angles.rotationMatrixFine[1][2], this.x * angles.rotationMatrixFine[2][0] + this.y * angles.rotationMatrixFine[2][1] + this.z * angles.rotationMatrixFine[2][2]);
        }
        return this;
    }

    public Point3d rotateY(double angle) {
        if (angle != 0.0) {
            double cosY = Math.cos(Math.toRadians(angle));
            double sinY = Math.sin(Math.toRadians(angle));
            this.set(this.x * cosY + this.z * sinY, this.y, this.x * -sinY + this.z * cosY);
        }
        return this;
    }
}

