/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONConnection;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperWorld;

public class TrailerConnection {
    private final UUID hitchEntityUUID;
    private final UUID hookupEntityUUID;
    public final int hitchGroupIndex;
    public final int hitchConnectionIndex;
    public final int hookupGroupIndex;
    public final int hookupConnectionIndex;
    public AEntityE_Interactable<?> hitchEntity;
    public EntityVehicleF_Physics hitchVehicle;
    public AEntityE_Interactable<?> hookupEntity;
    public EntityVehicleF_Physics hookupVehicle;
    public JSONConnectionGroup hitchConnectionGroup;
    public JSONConnection hitchConnection;
    public JSONConnectionGroup hookupConnectionGroup;
    public JSONConnection hookupConnection;

    public TrailerConnection(AEntityE_Interactable<?> hitchEntity, int hitchGroupIndex, int hitchConnectionIndex, AEntityE_Interactable<?> hookupEntity, int hookupGroupIndex, int hookupConnectionIndex) {
        this.hitchEntityUUID = hitchEntity.uniqueUUID;
        this.hookupEntityUUID = hookupEntity.uniqueUUID;
        this.hitchGroupIndex = hitchGroupIndex;
        this.hitchConnectionIndex = hitchConnectionIndex;
        this.hookupGroupIndex = hookupGroupIndex;
        this.hookupConnectionIndex = hookupConnectionIndex;
        this.hitchEntity = hitchEntity;
        this.hookupEntity = hookupEntity;
        this.setConnection(hitchEntity.world);
    }

    public TrailerConnection(WrapperNBT data) {
        this.hitchEntityUUID = data.getUUID("hitchEntityUUID");
        this.hookupEntityUUID = data.getUUID("hookupEntityUUID");
        this.hitchGroupIndex = data.getInteger("hitchGroupIndex");
        this.hitchConnectionIndex = data.getInteger("hitchConnectionIndex");
        this.hookupGroupIndex = data.getInteger("hookupGroupIndex");
        this.hookupConnectionIndex = data.getInteger("hookupConnectionIndex");
    }

    public boolean setConnection(WrapperWorld world) {
        if (this.hitchEntity == null) {
            this.hitchEntity = (AEntityE_Interactable)world.getEntity(this.hitchEntityUUID);
        }
        if (this.hitchEntity != null) {
            this.hitchVehicle = this.hitchEntity instanceof APart ? ((APart)this.hitchEntity).vehicleOn : (EntityVehicleF_Physics)this.hitchEntity;
            this.hitchConnectionGroup = ((AJSONInteractableEntity)this.hitchEntity.definition).connectionGroups.get(this.hitchGroupIndex);
            this.hitchConnection = this.hitchConnectionGroup.connections.get(this.hitchConnectionIndex);
        }
        if (this.hookupEntity == null) {
            this.hookupEntity = (AEntityE_Interactable)world.getEntity(this.hookupEntityUUID);
        }
        if (this.hookupEntity != null) {
            this.hookupVehicle = this.hookupEntity instanceof APart ? ((APart)this.hookupEntity).vehicleOn : (EntityVehicleF_Physics)this.hookupEntity;
            this.hookupConnectionGroup = ((AJSONInteractableEntity)this.hookupEntity.definition).connectionGroups.get(this.hookupGroupIndex);
            this.hookupConnection = this.hookupConnectionGroup.connections.get(this.hookupConnectionIndex);
        }
        return this.hitchConnection != null && this.hookupConnection != null;
    }

    public Point3d getHitchCurrentPosition() {
        return this.hitchConnection.pos.copy().rotateFine(this.hitchEntity.angles).add(this.hitchEntity.position);
    }

    public Point3d getHitchPrevPosition() {
        return this.hitchConnection.pos.copy().rotateFine(this.hitchEntity.prevAngles).add(this.hitchEntity.prevPosition);
    }

    public Point3d getHookupCurrentPosition() {
        return this.hookupConnection.pos.copy().rotateFine(this.hookupEntity.angles).add(this.hookupEntity.position);
    }

    public Point3d getHookupPrevPosition() {
        return this.hookupConnection.pos.copy().rotateFine(this.hookupEntity.prevAngles).add(this.hookupEntity.prevPosition);
    }

    public WrapperNBT getData() {
        WrapperNBT data = new WrapperNBT();
        data.setUUID("hitchEntityUUID", this.hitchEntityUUID);
        data.setUUID("hookupEntityUUID", this.hookupEntityUUID);
        data.setInteger("hitchGroupIndex", this.hitchGroupIndex);
        data.setInteger("hitchConnectionIndex", this.hitchConnectionIndex);
        data.setInteger("hookupGroupIndex", this.hookupGroupIndex);
        data.setInteger("hookupGroupIndex", this.hookupGroupIndex);
        return data;
    }
}

