/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.jsondefs.JSONPart;

public class VehicleGroundDeviceBox {
    private final EntityVehicleF_Physics vehicle;
    private final boolean isFront;
    private final boolean isLeft;
    private final BoundingBox solidBox = new BoundingBox(new Point3d(), new Point3d(), 0.0, 0.0, 0.0, false);
    private final BoundingBox liquidBox = new BoundingBox(new Point3d(), new Point3d(), 0.0, 0.0, 0.0, true);
    private final List<BoundingBox> liquidCollisionBoxes = new ArrayList<BoundingBox>();
    private final List<PartGroundDevice> groundDevices = new ArrayList<PartGroundDevice>();
    private final List<PartGroundDevice> liquidDevices = new ArrayList<PartGroundDevice>();
    public boolean canRollOnGround;
    public boolean contactedEntity;
    public boolean isCollided;
    public boolean isCollidedLiquid;
    public boolean isGrounded;
    public boolean isGroundedLiquid;
    public boolean isAbleToDoGroundOperations;
    public boolean isAbleToDoGroundOperationsLiquid;
    public boolean isLiquidCollidedWithGround;
    public double collisionDepth;
    public final Point3d contactPoint = new Point3d();

    public VehicleGroundDeviceBox(EntityVehicleF_Physics vehicle, boolean isFront, boolean isLeft) {
        this.vehicle = vehicle;
        this.isFront = isFront;
        this.isLeft = isLeft;
    }

    public void updateMembers() {
        this.liquidCollisionBoxes.clear();
        for (BoundingBox box : this.vehicle.allBlockCollisionBoxes) {
            boolean boxRight;
            boolean boxLeft;
            boolean boxFront;
            APart partOn = this.vehicle.getPartWithBox(box);
            if (partOn != null) {
                boxFront = partOn.placementOffset.z > 0.0;
                boxLeft = partOn.placementOffset.x >= 0.0;
                boxRight = partOn.placementOffset.x <= 0.0;
            } else {
                boxFront = box.localCenter.z > 0.0;
                boxLeft = box.localCenter.x >= 0.0;
                boolean bl = boxRight = box.localCenter.x <= 0.0;
            }
            if (!box.collidesWithLiquids) continue;
            if (this.isFront && boxFront) {
                if (this.isLeft && boxLeft) {
                    this.liquidCollisionBoxes.add(box);
                    continue;
                }
                if (this.isLeft || !boxRight) continue;
                this.liquidCollisionBoxes.add(box);
                continue;
            }
            if (this.isFront || boxFront) continue;
            if (this.isLeft && boxLeft) {
                this.liquidCollisionBoxes.add(box);
                continue;
            }
            if (this.isLeft || !boxRight) continue;
            this.liquidCollisionBoxes.add(box);
        }
        this.groundDevices.clear();
        this.liquidDevices.clear();
        this.canRollOnGround = false;
        for (APart part : this.vehicle.parts) {
            if (!(part instanceof PartGroundDevice) || part.placementDefinition.isSpare) continue;
            if (this.isFront && part.placementOffset.z > 0.0) {
                if (this.isLeft && part.placementOffset.x >= 0.0) {
                    this.groundDevices.add((PartGroundDevice)part);
                    if (((JSONPart)part.definition).ground.isWheel || ((JSONPart)part.definition).ground.isTread) {
                        this.canRollOnGround = true;
                    }
                    if (!((JSONPart)part.definition).ground.canFloat) continue;
                    this.liquidDevices.add((PartGroundDevice)part);
                    continue;
                }
                if (this.isLeft || !(part.placementOffset.x <= 0.0)) continue;
                this.groundDevices.add((PartGroundDevice)part);
                if (((JSONPart)part.definition).ground.isWheel || ((JSONPart)part.definition).ground.isTread) {
                    this.canRollOnGround = true;
                }
                if (!((JSONPart)part.definition).ground.canFloat) continue;
                this.liquidDevices.add((PartGroundDevice)part);
                continue;
            }
            if (this.isFront || !(part.placementOffset.z <= 0.0)) continue;
            if (this.isLeft && part.placementOffset.x >= 0.0) {
                this.groundDevices.add((PartGroundDevice)part);
                if (((JSONPart)part.definition).ground.isWheel || ((JSONPart)part.definition).ground.isTread) {
                    this.canRollOnGround = true;
                }
                if (!((JSONPart)part.definition).ground.canFloat) continue;
                this.liquidDevices.add((PartGroundDevice)part);
                continue;
            }
            if (this.isLeft || !(part.placementOffset.x <= 0.0)) continue;
            this.groundDevices.add((PartGroundDevice)part);
            if (((JSONPart)part.definition).ground.isWheel || ((JSONPart)part.definition).ground.isTread) {
                this.canRollOnGround = true;
            }
            if (!((JSONPart)part.definition).ground.canFloat) continue;
            this.liquidDevices.add((PartGroundDevice)part);
        }
    }

    public void updateBounds() {
        this.solidBox.localCenter.set(0.0, Double.MAX_VALUE, 0.0);
        this.solidBox.widthRadius = 0.0;
        this.solidBox.heightRadius = 0.0;
        for (APart aPart : this.groundDevices) {
            this.solidBox.localCenter.x += aPart.localOffset.x;
            this.solidBox.localCenter.z += aPart.localOffset.z;
            if (!(aPart.localOffset.y - (double)aPart.getHeight() / 2.0 < this.solidBox.localCenter.y - this.solidBox.heightRadius)) continue;
            this.solidBox.localCenter.y = aPart.localOffset.y;
            this.solidBox.heightRadius = (double)aPart.getHeight() / 2.0;
            this.solidBox.widthRadius = (double)aPart.getWidth() / 2.0;
        }
        this.solidBox.depthRadius = this.solidBox.widthRadius;
        this.solidBox.localCenter.x *= 1.0 / (double)this.groundDevices.size();
        this.solidBox.localCenter.z *= 1.0 / (double)this.groundDevices.size();
        this.liquidBox.localCenter.set(0.0, Double.MAX_VALUE, 0.0);
        this.liquidBox.widthRadius = 0.0;
        this.liquidBox.heightRadius = 0.0;
        for (APart aPart : this.liquidDevices) {
            this.liquidBox.localCenter.x += aPart.localOffset.x;
            this.liquidBox.localCenter.z += aPart.localOffset.z;
            if (!(aPart.localOffset.y - (double)aPart.getHeight() / 2.0 < this.liquidBox.localCenter.y - this.liquidBox.heightRadius)) continue;
            this.liquidBox.localCenter.y = aPart.localOffset.y;
            this.liquidBox.heightRadius = (double)aPart.getHeight() / 2.0;
            this.liquidBox.widthRadius = (double)aPart.getWidth() / 2.0;
        }
        for (BoundingBox boundingBox : this.liquidCollisionBoxes) {
            this.liquidBox.localCenter.x += boundingBox.localCenter.x;
            this.liquidBox.localCenter.z += boundingBox.localCenter.z;
            if (!(boundingBox.localCenter.y - boundingBox.heightRadius < this.liquidBox.localCenter.y - this.liquidBox.heightRadius)) continue;
            this.liquidBox.localCenter.y = boundingBox.localCenter.y;
            this.liquidBox.heightRadius = boundingBox.heightRadius;
            this.liquidBox.widthRadius = boundingBox.widthRadius;
        }
        this.liquidBox.depthRadius = this.liquidBox.widthRadius;
        this.liquidBox.localCenter.x *= 1.0 / (double)(this.liquidDevices.size() + this.liquidCollisionBoxes.size());
        this.liquidBox.localCenter.z *= 1.0 / (double)(this.liquidDevices.size() + this.liquidCollisionBoxes.size());
    }

    public void updateCollisionStatuses(Set<PartGroundDevice> groundedGroundDevices) {
        this.isCollided = false;
        this.isGrounded = false;
        this.isAbleToDoGroundOperations = false;
        this.isCollidedLiquid = false;
        this.isGroundedLiquid = false;
        this.isAbleToDoGroundOperationsLiquid = false;
        this.isLiquidCollidedWithGround = false;
        this.collisionDepth = 0.0;
        Point3d vehicleMotionOffset = this.vehicle.motion.copy().multiply(EntityVehicleF_Physics.SPEED_FACTOR);
        Point3d groundCollisionOffset = vehicleMotionOffset.copy().add(PartGroundDevice.groundDetectionOffset);
        if (!this.groundDevices.isEmpty()) {
            this.contactPoint.setTo(this.solidBox.localCenter).add(0.0, -this.solidBox.heightRadius, 0.0);
            this.solidBox.globalCenter.setTo(this.solidBox.localCenter).rotateFine(this.vehicle.angles.copy().add(this.vehicle.rotation)).add(this.vehicle.position).add(vehicleMotionOffset);
            this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, vehicleMotionOffset, false);
            this.contactedEntity = this.checkEntityCollisions(vehicleMotionOffset);
            this.isCollided = this.contactedEntity || !this.solidBox.collidingBlockPositions.isEmpty();
            this.collisionDepth = this.solidBox.currentCollisionDepth.y;
            PartGroundDevice.groundOperationOffset.set(0.0, -0.5, 0.0);
            if (this.isCollided) {
                this.isGrounded = true;
            } else {
                this.solidBox.globalCenter.add(PartGroundDevice.groundDetectionOffset);
                this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, groundCollisionOffset, false);
                this.contactedEntity = this.checkEntityCollisions(groundCollisionOffset);
                this.solidBox.globalCenter.subtract(PartGroundDevice.groundDetectionOffset);
                boolean bl = this.isGrounded = this.contactedEntity || !this.solidBox.collidingBlockPositions.isEmpty();
            }
            if (this.isGrounded) {
                this.isAbleToDoGroundOperations = true;
            } else {
                groundCollisionOffset = vehicleMotionOffset.copy().add(PartGroundDevice.groundOperationOffset);
                this.solidBox.globalCenter.add(PartGroundDevice.groundOperationOffset);
                this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, groundCollisionOffset, false);
                this.contactedEntity = this.checkEntityCollisions(groundCollisionOffset);
                this.solidBox.globalCenter.subtract(PartGroundDevice.groundOperationOffset);
                boolean bl = this.isAbleToDoGroundOperations = this.contactedEntity || !this.solidBox.collidingBlockPositions.isEmpty();
            }
        }
        if (!this.canRollOnGround || !this.isAbleToDoGroundOperations) {
            if (!this.liquidDevices.isEmpty() || !this.liquidCollisionBoxes.isEmpty()) {
                this.liquidBox.globalCenter.setTo(this.liquidBox.localCenter).rotateFine(this.vehicle.angles.copy().add(this.vehicle.rotation)).add(this.vehicle.position).add(vehicleMotionOffset);
                this.vehicle.world.updateBoundingBoxCollisions(this.liquidBox, vehicleMotionOffset, false);
                this.isCollidedLiquid = !this.liquidBox.collidingBlockPositions.isEmpty();
                double liquidCollisionDepth = this.liquidBox.currentCollisionDepth.y;
                if (this.isCollidedLiquid) {
                    this.isGroundedLiquid = true;
                } else {
                    this.liquidBox.globalCenter.add(PartGroundDevice.groundDetectionOffset);
                    this.vehicle.world.updateBoundingBoxCollisions(this.liquidBox, groundCollisionOffset, false);
                    this.liquidBox.globalCenter.subtract(PartGroundDevice.groundDetectionOffset);
                    boolean bl = this.isGroundedLiquid = !this.liquidBox.collidingBlockPositions.isEmpty();
                }
                if (this.isGroundedLiquid) {
                    this.isAbleToDoGroundOperationsLiquid = true;
                } else {
                    groundCollisionOffset = vehicleMotionOffset.copy().add(PartGroundDevice.groundOperationOffset);
                    this.liquidBox.globalCenter.add(PartGroundDevice.groundOperationOffset);
                    this.vehicle.world.updateBoundingBoxCollisions(this.liquidBox, groundCollisionOffset, false);
                    this.liquidBox.globalCenter.subtract(PartGroundDevice.groundOperationOffset);
                    this.isAbleToDoGroundOperationsLiquid = !this.liquidBox.collidingBlockPositions.isEmpty();
                }
                this.isLiquidCollidedWithGround = false;
                for (Point3d blockPosition : this.liquidBox.collidingBlockPositions) {
                    if (this.vehicle.world.isBlockLiquid(blockPosition)) continue;
                    this.isLiquidCollidedWithGround = true;
                    break;
                }
                if (this.isGroundedLiquid && liquidCollisionDepth >= this.collisionDepth || this.groundDevices.isEmpty()) {
                    this.isCollided = this.isCollidedLiquid;
                    this.isGrounded = this.isGroundedLiquid;
                    this.isAbleToDoGroundOperations = this.isAbleToDoGroundOperationsLiquid;
                    this.collisionDepth = liquidCollisionDepth;
                    this.contactPoint.setTo(this.liquidBox.localCenter).add(0.0, -this.liquidBox.heightRadius, 0.0);
                }
            }
        } else {
            this.isCollidedLiquid = false;
            this.isGroundedLiquid = false;
            this.isAbleToDoGroundOperationsLiquid = false;
        }
        if (groundedGroundDevices != null && this.isAbleToDoGroundOperations) {
            groundedGroundDevices.addAll(this.groundDevices);
        }
    }

    private boolean checkEntityCollisions(Point3d collisionMotion) {
        boolean didCollision = false;
        for (EntityVehicleF_Physics otherVehicle : this.vehicle.world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
            if (otherVehicle.equals(this.vehicle) || !this.vehicle.canCollideWith(otherVehicle) || otherVehicle.collidedEntities.contains(this.vehicle) || !otherVehicle.encompassingBox.intersects(this.solidBox)) continue;
            BoundingBox collidingBox = null;
            double boxCollisionDepth = 0.0;
            for (BoundingBox box : otherVehicle.getCollisionBoxes()) {
                if (!box.intersects(this.solidBox)) continue;
                if (collisionMotion.y > 0.0) {
                    boxCollisionDepth = this.solidBox.globalCenter.y + this.solidBox.heightRadius - (box.globalCenter.y - box.heightRadius);
                    if (!(boxCollisionDepth > this.solidBox.currentCollisionDepth.y)) continue;
                    this.solidBox.currentCollisionDepth.y = boxCollisionDepth;
                    collidingBox = box;
                    continue;
                }
                boxCollisionDepth = box.globalCenter.y + box.heightRadius - (this.solidBox.globalCenter.y - this.solidBox.heightRadius);
                if (!(boxCollisionDepth > this.solidBox.currentCollisionDepth.y)) continue;
                this.solidBox.currentCollisionDepth.y = boxCollisionDepth;
                collidingBox = box;
            }
            if (collidingBox == null) continue;
            this.vehicle.collidedEntities.add(otherVehicle);
            didCollision = true;
        }
        return didCollision;
    }

    public boolean isReady() {
        return !this.groundDevices.isEmpty() || !this.liquidCollisionBoxes.isEmpty() || !this.liquidDevices.isEmpty();
    }

    public BoundingBox getBoundingBox() {
        return this.isAbleToDoGroundOperationsLiquid || this.groundDevices.isEmpty() ? this.liquidBox : this.solidBox;
    }

    public boolean isPartofBox(PartGroundDevice groundDevice) {
        return this.groundDevices.contains(groundDevice) || this.liquidDevices.contains(groundDevice);
    }

    public List<PartGroundDevice> getGroundDevices() {
        return this.groundDevices;
    }
}

