/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.VehicleGroundDeviceBox;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;

public class VehicleGroundDeviceCollection {
    private static final double MAX_LINEAR_MOVEMENT_PER_TICK = 0.2;
    private final EntityVehicleF_Physics vehicle;
    private final VehicleGroundDeviceBox frontLeftGDB;
    private final VehicleGroundDeviceBox frontRightGDB;
    private final VehicleGroundDeviceBox rearLeftGDB;
    private final VehicleGroundDeviceBox rearRightGDB;
    public final Set<PartGroundDevice> groundedGroundDevices = new HashSet<PartGroundDevice>();
    public final Set<PartGroundDevice> drivenWheels = new HashSet<PartGroundDevice>();

    public VehicleGroundDeviceCollection(EntityVehicleF_Physics vehicle) {
        this.vehicle = vehicle;
        this.frontLeftGDB = new VehicleGroundDeviceBox(vehicle, true, true);
        this.frontRightGDB = new VehicleGroundDeviceBox(vehicle, true, false);
        this.rearLeftGDB = new VehicleGroundDeviceBox(vehicle, false, true);
        this.rearRightGDB = new VehicleGroundDeviceBox(vehicle, false, false);
    }

    public void updateMembers() {
        this.frontLeftGDB.updateMembers();
        this.frontRightGDB.updateMembers();
        this.rearLeftGDB.updateMembers();
        this.rearRightGDB.updateMembers();
        this.drivenWheels.clear();
        for (PartGroundDevice ground : this.frontLeftGDB.getGroundDevices()) {
            if (ground.placementDefinition.isSpare || !ground.isActive || !((JSONPart)ground.definition).ground.isWheel && !((JSONPart)ground.definition).ground.isTread || !((JSONVehicle)this.vehicle.definition).motorized.isFrontWheelDrive) continue;
            this.drivenWheels.add(ground);
        }
        for (PartGroundDevice ground : this.frontRightGDB.getGroundDevices()) {
            if (ground.placementDefinition.isSpare || !ground.isActive || !((JSONPart)ground.definition).ground.isWheel && !((JSONPart)ground.definition).ground.isTread || !((JSONVehicle)this.vehicle.definition).motorized.isFrontWheelDrive) continue;
            this.drivenWheels.add(ground);
        }
        for (PartGroundDevice ground : this.rearLeftGDB.getGroundDevices()) {
            if (ground.placementDefinition.isSpare || !ground.isActive || !((JSONPart)ground.definition).ground.isWheel && !((JSONPart)ground.definition).ground.isTread || !((JSONVehicle)this.vehicle.definition).motorized.isRearWheelDrive) continue;
            this.drivenWheels.add(ground);
        }
        for (PartGroundDevice ground : this.rearRightGDB.getGroundDevices()) {
            if (ground.placementDefinition.isSpare || !ground.isActive || !((JSONPart)ground.definition).ground.isWheel && !((JSONPart)ground.definition).ground.isTread || !((JSONVehicle)this.vehicle.definition).motorized.isRearWheelDrive) continue;
            this.drivenWheels.add(ground);
        }
    }

    public void updateBounds() {
        this.frontLeftGDB.updateBounds();
        this.frontRightGDB.updateBounds();
        this.rearLeftGDB.updateBounds();
        this.rearRightGDB.updateBounds();
    }

    public void updateCollisions() {
        this.groundedGroundDevices.clear();
        this.frontLeftGDB.updateCollisionStatuses(this.groundedGroundDevices);
        this.frontRightGDB.updateCollisionStatuses(this.groundedGroundDevices);
        this.rearLeftGDB.updateCollisionStatuses(this.groundedGroundDevices);
        this.rearRightGDB.updateCollisionStatuses(this.groundedGroundDevices);
    }

    public double getMaxCollisionDepth() {
        return Math.max(Math.max(Math.max(this.frontLeftGDB.collisionDepth, this.frontRightGDB.collisionDepth), this.rearLeftGDB.collisionDepth), this.rearRightGDB.collisionDepth);
    }

    public int getNumberCollidedLiquidBoxes() {
        int count = 0;
        if (this.frontLeftGDB.isGroundedLiquid && this.frontLeftGDB.isLiquidCollidedWithGround) {
            ++count;
        }
        if (this.frontRightGDB.isGroundedLiquid && this.frontRightGDB.isLiquidCollidedWithGround) {
            ++count;
        }
        if (this.rearLeftGDB.isGroundedLiquid && this.rearLeftGDB.isLiquidCollidedWithGround) {
            ++count;
        }
        if (this.rearRightGDB.isGroundedLiquid && this.rearRightGDB.isLiquidCollidedWithGround) {
            ++count;
        }
        return count;
    }

    public int getNumberBoxesInLiquid() {
        int count = 0;
        if (this.frontLeftGDB.isCollidedLiquid || this.frontLeftGDB.isGroundedLiquid) {
            ++count;
        }
        if (this.frontRightGDB.isCollidedLiquid || this.frontRightGDB.isGroundedLiquid) {
            ++count;
        }
        if (this.rearLeftGDB.isCollidedLiquid || this.rearLeftGDB.isGroundedLiquid) {
            ++count;
        }
        if (this.rearRightGDB.isCollidedLiquid || this.rearRightGDB.isGroundedLiquid) {
            ++count;
        }
        return count;
    }

    public List<BoundingBox> getGroundBounds() {
        ArrayList<BoundingBox> groundBoxes = new ArrayList<BoundingBox>();
        groundBoxes.add(this.frontLeftGDB.getBoundingBox());
        groundBoxes.add(this.frontRightGDB.getBoundingBox());
        groundBoxes.add(this.rearLeftGDB.getBoundingBox());
        groundBoxes.add(this.rearRightGDB.getBoundingBox());
        return groundBoxes;
    }

    public Point3d getContactPoint(boolean front) {
        if (front) {
            if (this.frontLeftGDB.contactPoint.isZero()) {
                if (this.frontRightGDB.contactPoint.isZero()) {
                    return null;
                }
                return this.frontRightGDB.contactPoint.copy().add(PartGroundDevice.groundDetectionOffset);
            }
            if (this.frontRightGDB.contactPoint.isZero()) {
                return this.frontRightGDB.contactPoint.copy().add(PartGroundDevice.groundDetectionOffset);
            }
            return this.frontRightGDB.contactPoint.copy().subtract(this.frontLeftGDB.contactPoint).multiply(0.5).add(this.frontLeftGDB.contactPoint).add(PartGroundDevice.groundDetectionOffset);
        }
        if (this.rearLeftGDB.contactPoint.isZero()) {
            if (this.rearRightGDB.contactPoint.isZero()) {
                return null;
            }
            return this.rearRightGDB.contactPoint.copy().add(PartGroundDevice.groundDetectionOffset);
        }
        if (this.rearRightGDB.contactPoint.isZero()) {
            return this.rearRightGDB.contactPoint.copy().add(PartGroundDevice.groundDetectionOffset);
        }
        return this.rearRightGDB.contactPoint.copy().subtract(this.rearLeftGDB.contactPoint).multiply(0.5).add(this.rearLeftGDB.contactPoint).add(PartGroundDevice.groundDetectionOffset);
    }

    public boolean isReady() {
        boolean haveFrontPoint = false;
        boolean haveRearPoint = false;
        boolean haveCenterPoint = false;
        if (this.frontLeftGDB.isReady()) {
            haveFrontPoint = true;
            boolean bl = haveCenterPoint = this.frontLeftGDB.contactPoint.x == 0.0;
        }
        if (this.frontRightGDB.isReady()) {
            if (haveFrontPoint) {
                haveCenterPoint = true;
            } else {
                haveFrontPoint = true;
            }
            if (!haveCenterPoint) {
                boolean bl = haveCenterPoint = this.frontRightGDB.contactPoint.x == 0.0;
            }
        }
        if (haveFrontPoint) {
            if (this.rearLeftGDB.isReady()) {
                haveRearPoint = true;
                boolean bl = haveCenterPoint = this.rearLeftGDB.contactPoint.x == 0.0;
            }
            if (this.rearRightGDB.isReady()) {
                if (haveRearPoint) {
                    haveCenterPoint = true;
                } else {
                    haveRearPoint = true;
                }
                if (!haveCenterPoint) {
                    haveCenterPoint = this.rearRightGDB.contactPoint.x == 0.0;
                }
            }
        }
        return haveFrontPoint && haveRearPoint && haveCenterPoint;
    }

    public boolean isAnythingOnGround() {
        return this.frontLeftGDB.isGrounded || this.frontRightGDB.isGrounded || this.rearLeftGDB.isGrounded || this.rearRightGDB.isGrounded;
    }

    public boolean isActuallyOnGround(PartGroundDevice groundDevice) {
        if (this.frontLeftGDB.isPartofBox(groundDevice)) {
            return this.frontLeftGDB.isGrounded;
        }
        if (this.frontRightGDB.isPartofBox(groundDevice)) {
            return this.frontRightGDB.isGrounded;
        }
        if (this.rearLeftGDB.isPartofBox(groundDevice)) {
            return this.rearLeftGDB.isGrounded;
        }
        if (this.rearRightGDB.isPartofBox(groundDevice)) {
            return this.rearRightGDB.isGrounded;
        }
        return false;
    }

    public boolean canDoRollChecks() {
        double xAxisPoint = 0.0;
        if (this.frontLeftGDB != null) {
            xAxisPoint = this.frontLeftGDB.contactPoint.x;
        }
        if (this.frontRightGDB != null && xAxisPoint == 0.0) {
            xAxisPoint = this.frontRightGDB.contactPoint.x;
        }
        if (this.rearLeftGDB != null && xAxisPoint == 0.0) {
            xAxisPoint = this.rearLeftGDB.contactPoint.x;
        }
        if (this.rearRightGDB != null && xAxisPoint == 0.0) {
            xAxisPoint = this.rearRightGDB.contactPoint.x;
        }
        return xAxisPoint != 0.0;
    }

    public double performPitchCorrection(double groundBoost) {
        double side1Delta = 0.0;
        double side2Delta = 0.0;
        double groundedSideOffset = 0.0;
        VehicleGroundDeviceBox testBox1 = null;
        VehicleGroundDeviceBox testBox2 = null;
        if (this.vehicle.towedByConnection == null) {
            if ((this.rearLeftGDB.isGrounded || this.rearRightGDB.isGrounded) && !this.frontLeftGDB.isGrounded && !this.frontRightGDB.isGrounded) {
                side1Delta = Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.z);
                side2Delta = Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.z);
                groundedSideOffset = this.rearLeftGDB.isGrounded && !this.rearRightGDB.isGrounded ? -Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z) : (!this.rearLeftGDB.isGrounded && this.rearRightGDB.isGrounded ? -Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z) : -Math.max(Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z), Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z)));
                testBox1 = this.frontLeftGDB;
                testBox2 = this.frontRightGDB;
            }
            if ((this.frontLeftGDB.isGrounded || this.frontRightGDB.isGrounded) && !this.rearLeftGDB.isGrounded && !this.rearRightGDB.isGrounded) {
                side1Delta = -Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z);
                side2Delta = -Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z);
                groundedSideOffset = this.frontLeftGDB.isGrounded && !this.rearRightGDB.isGrounded ? Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.z) : (!this.frontLeftGDB.isGrounded && this.frontRightGDB.isGrounded ? Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.z) : Math.max(Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.z), Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.z)));
                testBox1 = this.rearLeftGDB;
                testBox2 = this.rearRightGDB;
            }
        } else {
            Point3d hookupPoint = this.vehicle.towedByConnection.hookupConnection.pos.copy();
            if (this.vehicle.towedByConnection.hookupEntity instanceof APart) {
                APart hookupPart = (APart)this.vehicle.towedByConnection.hookupEntity;
                hookupPoint = hookupPoint.rotateFine(hookupPart.localAngles).add(hookupPart.localOffset);
            }
            if (hookupPoint.z > 0.0) {
                if (!this.rearLeftGDB.isGrounded && !this.rearRightGDB.isGrounded) {
                    side1Delta = -Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z);
                    side2Delta = -Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z);
                    groundedSideOffset = Math.hypot(hookupPoint.y, hookupPoint.z);
                    testBox1 = this.rearLeftGDB;
                    testBox2 = this.rearRightGDB;
                } else if (this.rearLeftGDB.isCollided || this.rearRightGDB.isCollided) {
                    side1Delta = Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z);
                    side2Delta = Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z);
                    groundedSideOffset = -Math.hypot(hookupPoint.y, hookupPoint.z);
                    testBox1 = this.rearLeftGDB;
                    testBox2 = this.rearRightGDB;
                    return this.adjustTrailerAngles(testBox1, testBox2, side1Delta -= groundedSideOffset, side2Delta -= groundedSideOffset, groundedSideOffset, groundBoost);
                }
            } else if (!this.frontLeftGDB.isGrounded && !this.frontRightGDB.isGrounded) {
                side1Delta = Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.z);
                side2Delta = Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.z);
                groundedSideOffset = -Math.hypot(hookupPoint.y, hookupPoint.z);
                testBox1 = this.frontLeftGDB;
                testBox2 = this.frontRightGDB;
            } else if (this.frontLeftGDB.isCollided || this.frontRightGDB.isCollided) {
                side1Delta = -Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.z);
                side2Delta = -Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.z);
                groundedSideOffset = Math.hypot(hookupPoint.y, hookupPoint.z);
                testBox1 = this.frontLeftGDB;
                testBox2 = this.frontRightGDB;
                return this.adjustTrailerAngles(testBox1, testBox2, side1Delta -= groundedSideOffset, side2Delta -= groundedSideOffset, groundedSideOffset, groundBoost);
            }
        }
        return this.adjustAngles(testBox1, testBox2, side1Delta -= groundedSideOffset, side2Delta -= groundedSideOffset, groundedSideOffset, groundBoost, true);
    }

    public double performRollCorrection(double groundBoost) {
        double side1Delta = 0.0;
        double side2Delta = 0.0;
        double groundedSideOffset = 0.0;
        VehicleGroundDeviceBox testBox1 = null;
        VehicleGroundDeviceBox testBox2 = null;
        if (!(!this.rearLeftGDB.isGrounded && !this.frontLeftGDB.isGrounded || this.rearRightGDB.isGrounded && this.rearRightGDB.contactPoint.x != 0.0 || this.frontRightGDB.isGrounded && this.frontRightGDB.contactPoint.x != 0.0)) {
            side1Delta = Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.x);
            side2Delta = Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.x);
            groundedSideOffset = this.rearLeftGDB.isGrounded && !this.frontLeftGDB.isGrounded ? -Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.x) : (!this.rearLeftGDB.isGrounded && this.frontLeftGDB.isGrounded ? -Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.x) : -Math.max(Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.x), Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.x)));
            testBox1 = this.rearRightGDB;
            testBox2 = this.frontRightGDB;
        }
        if (!(!this.rearRightGDB.isGrounded && !this.frontRightGDB.isGrounded || this.rearLeftGDB.isGrounded && this.rearLeftGDB.contactPoint.x != 0.0 || this.frontLeftGDB.isGrounded && this.frontLeftGDB.contactPoint.x != 0.0)) {
            side1Delta = -Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.x);
            side2Delta = -Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.x);
            groundedSideOffset = this.rearRightGDB.isGrounded && !this.frontRightGDB.isGrounded ? Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.x) : (!this.rearRightGDB.isGrounded && this.frontRightGDB.isGrounded ? Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.x) : Math.max(Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.x), Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.x)));
            testBox1 = this.rearLeftGDB;
            testBox2 = this.frontLeftGDB;
        }
        return this.adjustAngles(testBox1, testBox2, side1Delta -= groundedSideOffset, side2Delta -= groundedSideOffset, groundedSideOffset, groundBoost, false);
    }

    private double adjustAngles(VehicleGroundDeviceBox testBox1, VehicleGroundDeviceBox testBox2, double side1Delta, double side2Delta, double groundedSideOffset, double groundBoost, boolean pitch) {
        if ((side1Delta != 0.0 || side2Delta != 0.0) && testBox1.isReady() && testBox2.isReady()) {
            double testSin = 0.2 / Math.max(side1Delta, side2Delta);
            if (testSin > 1.0) {
                testSin = 1.0;
            } else if (testSin < -1.0) {
                testSin = -1.0;
            }
            double testRotation = Math.toDegrees(Math.asin(testSin));
            if (this.vehicle.motion.y - groundBoost <= 0.01 && (!pitch || Math.abs(this.vehicle.angles.x + testRotation) < 85.0)) {
                double intialLinearMovement = Math.sin(Math.toRadians(testRotation)) * groundedSideOffset;
                if (pitch) {
                    if (this.vehicle.rotation.x * testRotation < 0.0 && this.vehicle.velocity > 0.5) {
                        return 0.0;
                    }
                    this.vehicle.rotation.x += testRotation;
                } else {
                    this.vehicle.rotation.z += testRotation;
                }
                this.vehicle.motion.y += intialLinearMovement;
                testBox1.updateCollisionStatuses(null);
                testBox2.updateCollisionStatuses(null);
                double angularCorrection = 0.0;
                double linearCorrection = 0.0;
                if (testBox1.collisionDepth > 0.0 && (pitch ? testBox1.contactPoint.z != 0.0 : testBox1.contactPoint.x != 0.0)) {
                    angularCorrection = Math.toDegrees(Math.asin(testBox1.collisionDepth / side1Delta));
                }
                if (testBox2.collisionDepth > 0.0 && (pitch ? testBox2.contactPoint.z != 0.0 : testBox2.contactPoint.x != 0.0)) {
                    double angularCorrection2 = Math.toDegrees(Math.asin(testBox2.collisionDepth / side2Delta));
                    if (angularCorrection == 0.0 || (angularCorrection > 0.0 ? angularCorrection2 > angularCorrection : angularCorrection2 < angularCorrection)) {
                        angularCorrection = angularCorrection2;
                    }
                }
                if (angularCorrection != 0.0 && (Math.abs(angularCorrection) > Math.abs(testRotation) || Double.isNaN(angularCorrection))) {
                    if (pitch) {
                        this.vehicle.rotation.x -= testRotation;
                    } else {
                        this.vehicle.rotation.z -= testRotation;
                    }
                    this.vehicle.motion.y -= intialLinearMovement;
                    return 0.0;
                }
                linearCorrection = intialLinearMovement * (angularCorrection / testRotation);
                if (pitch) {
                    this.vehicle.rotation.x -= angularCorrection;
                } else {
                    this.vehicle.rotation.z -= angularCorrection;
                }
                this.vehicle.motion.y -= linearCorrection;
                this.updateCollisions();
                if (testBox1.isCollided || testBox2.isCollided) {
                    double finalAngularMovement = (testRotation - angularCorrection) * 0.05;
                    double finalLinearMovement = (intialLinearMovement - linearCorrection) * 0.05;
                    if (pitch) {
                        this.vehicle.rotation.x -= testRotation - angularCorrection - finalAngularMovement;
                    } else {
                        this.vehicle.rotation.z -= testRotation - angularCorrection - finalAngularMovement;
                    }
                    this.vehicle.motion.y -= intialLinearMovement - linearCorrection - finalLinearMovement;
                    this.updateCollisions();
                    return finalLinearMovement;
                }
                return intialLinearMovement - linearCorrection;
            }
        }
        return 0.0;
    }

    private double adjustTrailerAngles(VehicleGroundDeviceBox testBox1, VehicleGroundDeviceBox testBox2, double side1Delta, double side2Delta, double groundedSideOffset, double groundBoost) {
        double linearCorrection;
        double angularCorrection = 0.0;
        if (testBox1.collisionDepth > 0.0) {
            angularCorrection = Math.toDegrees(Math.asin(testBox1.collisionDepth / side1Delta));
        }
        if (testBox2.collisionDepth > 0.0) {
            double angularCorrection2 = Math.toDegrees(Math.asin(testBox2.collisionDepth / side2Delta));
            if (angularCorrection == 0.0 || (angularCorrection > 0.0 ? angularCorrection2 > angularCorrection : angularCorrection2 < angularCorrection)) {
                angularCorrection = angularCorrection2;
            }
        }
        if (Math.abs(linearCorrection = Math.sin(Math.toRadians(angularCorrection)) * groundedSideOffset) > 0.2) {
            linearCorrection = Math.signum(linearCorrection) * 0.2;
            angularCorrection = Math.toDegrees(Math.asin(linearCorrection / groundedSideOffset));
        }
        if (Double.isNaN(angularCorrection)) {
            return 0.0;
        }
        this.vehicle.rotation.x += angularCorrection;
        this.vehicle.motion.y += linearCorrection;
        this.updateCollisions();
        return linearCorrection;
    }
}

