/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.mcinterface.WrapperWorld;

public class BlockCollision
extends ABlockBase {
    public static List<BlockCollision> blockInstances = BlockCollision.createCollisionBlocks();
    public final BoundingBox blockBounds;

    public BlockCollision(int collisionHeightInPixels) {
        super(10.0f, 5.0f);
        if (collisionHeightInPixels == 0) {
            collisionHeightInPixels = 1;
        }
        float heightRadiusRequired = (float)collisionHeightInPixels / 16.0f / 2.0f;
        float centerPositionOffset = -(0.5f - heightRadiusRequired);
        this.blockBounds = new BoundingBox(new Point3d(0.0, centerPositionOffset, 0.0), 0.5, heightRadiusRequired, 0.5);
    }

    @Override
    public void onBroken(WrapperWorld world, Point3d position) {
        TileEntityRoad masterBlock = this.getMasterRoad(world, position);
        if (masterBlock != null && masterBlock.isActive()) {
            world.destroyBlock(masterBlock.position, true);
            return;
        }
    }

    public TileEntityRoad getMasterRoad(WrapperWorld world, Point3d position) {
        Point3d blockOffset = new Point3d();
        Point3d testPoint = new Point3d();
        for (int i = -32; i < 64; ++i) {
            for (int j = -32; j < 64; ++j) {
                for (int k = -32; k < 64; ++k) {
                    blockOffset.set(i, j, k);
                    testPoint.setTo(position).subtract(blockOffset);
                    Object testTile = world.getTileEntity(testPoint);
                    if (!(testTile instanceof TileEntityRoad) || !((TileEntityRoad)testTile).collisionBlockOffsets.contains(blockOffset)) continue;
                    return (TileEntityRoad)testTile;
                }
            }
        }
        return null;
    }

    private static final List<BlockCollision> createCollisionBlocks() {
        ArrayList<BlockCollision> blocks = new ArrayList<BlockCollision>();
        for (int i = 0; i < 16; ++i) {
            blocks.add(new BlockCollision(i));
        }
        return blocks;
    }
}

