/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.systems.ConfigSystem;

public abstract class ATileEntityBase<JSONDefinition extends AJSONMultiModelProvider>
extends AEntityD_Definable<JSONDefinition> {
    private float lastLightLevel;

    public ATileEntityBase(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
        this.position.setTo(position);
        if (placingPlayer != null) {
            int clampAngle = this.getRotationIncrement();
            this.angles.y = Math.round((placingPlayer.getYaw() + 180.0f) / (float)clampAngle) * clampAngle % 360;
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (this.lastLightLevel != this.getLightProvided()) {
                this.lastLightLevel = this.getLightProvided();
                this.world.updateLightBrightness(this.position);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.configObject.clientRendering.blockBeams.value;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "redstone_active": {
                return this.world.getRedstonePower(this.position) > 0 ? 1.0 : 0.0;
            }
            case "redstone_level": {
                return this.world.getRedstonePower(this.position);
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    public int getRotationIncrement() {
        return 15;
    }

    public BoundingBox getCollisionBox() {
        return this.boundingBox;
    }
}

