/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketTileEntityLoaderConnection;

public abstract class ATileEntityLoader
extends TileEntityDecor {
    public PartInteractable connectedPart;

    public ATileEntityLoader(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, position, placingPlayer, data);
    }

    @Override
    public boolean update() {
        if (super.update()) {
            if (!this.world.isClient()) {
                if (this.connectedPart == null) {
                    if (this.ticksExisted % 20L == 0L) {
                        this.updateNearestPart();
                    }
                } else if (!this.connectedPart.isValid || this.connectedPart.position.distanceTo(this.position) > 10.0) {
                    this.updateNearestPart();
                }
                if (this.connectedPart != null) {
                    if (this.isUnloader()) {
                        this.doUnloading();
                    } else {
                        this.doLoading();
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected void updateNearestPart() {
        PartInteractable nearestPart = null;
        double nearestDistance = 999.0;
        if (this.canOperate()) {
            for (PartInteractable interactablePart : this.world.getEntitiesOfType(PartInteractable.class)) {
                if (!this.canLoadPart(interactablePart) || !(interactablePart.position.distanceTo(this.position) < nearestDistance)) continue;
                nearestPart = interactablePart;
            }
        }
        if (nearestPart != null) {
            this.connectToPart(nearestPart);
            InterfacePacket.sendToAllClients(new PacketTileEntityLoaderConnection(this, true));
        } else if (this.connectedPart != null) {
            InterfacePacket.sendToAllClients(new PacketTileEntityLoaderConnection(this, false));
            this.connectToPart(null);
        }
    }

    public void connectToPart(PartInteractable part) {
        this.connectedPart = part;
    }

    public abstract boolean isUnloader();

    protected abstract boolean canOperate();

    protected abstract boolean canLoadPart(PartInteractable var1);

    protected abstract void doLoading();

    protected abstract void doUnloading();
}

