/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.rendering.instances.RenderPoleComponent;
import minecrafttransportsimulator.systems.ConfigSystem;

public abstract class ATileEntityPole_Component
extends AEntityD_Definable<JSONPoleComponent> {
    public final TileEntityPole core;
    public final ABlockBase.Axis axis;
    private static RenderPoleComponent renderer;

    public ATileEntityPole_Component(TileEntityPole core, WrapperPlayer placingPlayer, ABlockBase.Axis axis, WrapperNBT data) {
        super(core.world, placingPlayer, data);
        this.core = core;
        this.axis = axis;
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.configObject.clientRendering.blockBeams.value;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        double value = super.getRawVariableValue(variable, partialTicks);
        if (!Double.isNaN(value)) {
            return value;
        }
        if (variable.startsWith("neighbor_present_")) {
            ABlockBase.Axis connectionAxis = ABlockBase.Axis.valueOf(variable.substring("neighbor_present_".length()).toUpperCase());
            Object otherTile = this.world.getTileEntity(connectionAxis.getOffsetPoint(this.position));
            return otherTile != null && otherTile instanceof TileEntityPole ? 1.0 : 0.0;
        }
        if (variable.startsWith("matching_present_")) {
            ABlockBase.Axis connectionAxis = ABlockBase.Axis.valueOf(variable.substring("matching_present_".length()).toUpperCase());
            Object otherTile = this.world.getTileEntity(connectionAxis.getOffsetPoint(this.position));
            return otherTile != null && ((JSONPoleComponent)this.core.definition).systemName.equals(((ATileEntityBase)otherTile).definition.systemName) ? 1.0 : 0.0;
        }
        if (variable.startsWith("solid_present_")) {
            ABlockBase.Axis connectionAxis = ABlockBase.Axis.valueOf(variable.substring("solid_present_".length()).toUpperCase());
            return this.world.isBlockSolid(connectionAxis.getOffsetPoint(this.position), connectionAxis.getOpposite()) ? 1.0 : 0.0;
        }
        switch (variable) {
            case "slab_present_up": {
                return this.world.isBlockTopSlab(ABlockBase.Axis.UP.getOffsetPoint(this.position)) ? 1.0 : 0.0;
            }
            case "slab_present_down": {
                return this.world.isBlockBottomSlab(ABlockBase.Axis.DOWN.getOffsetPoint(this.position)) ? 1.0 : 0.0;
            }
        }
        return Double.NaN;
    }

    public RenderPoleComponent getRenderer() {
        if (renderer == null) {
            renderer = new RenderPoleComponent();
        }
        return renderer;
    }
}

