/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLaneConnection;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;

public class RoadClickData {
    public final TileEntityRoad roadClicked;
    public final JSONRoadComponent.JSONLaneSector sectorClicked;
    public final boolean lanesOccupied;
    public final boolean clickedStart;
    public final Point3d genPosition;
    public final float genRotation;

    public RoadClickData(TileEntityRoad roadClicked, JSONRoadComponent.JSONLaneSector sectorClicked, boolean clickedStart, boolean curveStart) {
        this.roadClicked = roadClicked;
        this.sectorClicked = sectorClicked;
        this.clickedStart = clickedStart;
        if (((JSONRoadComponent)roadClicked.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC)) {
            if (clickedStart) {
                this.genRotation = roadClicked.dynamicCurve.startAngle + 180.0f;
                this.genPosition = curveStart ? new Point3d(-((JSONRoadComponent)roadClicked.definition).road.borderOffset, 0.0, 0.0).rotateY(this.genRotation).add(roadClicked.position).add(roadClicked.dynamicCurve.startPos) : roadClicked.position.copy().add(roadClicked.dynamicCurve.startPos);
            } else {
                this.genRotation = roadClicked.dynamicCurve.endAngle + 180.0f;
                this.genPosition = curveStart ? roadClicked.position.copy().add(roadClicked.dynamicCurve.endPos) : new Point3d(((JSONRoadComponent)roadClicked.definition).road.borderOffset, 0.0, 0.0).rotateY(this.genRotation).add(roadClicked.position).add(roadClicked.dynamicCurve.endPos);
            }
            this.lanesOccupied = this.areDynamicLanesOccupied();
        } else {
            this.genRotation = (float)((double)sectorClicked.sectorStartAngle + roadClicked.angles.y + 180.0);
            this.genPosition = sectorClicked.sectorStartPos.copy().add(-0.5, 0.0, -0.5).rotateFine(roadClicked.angles).add(roadClicked.position);
            if (curveStart) {
                this.genPosition.add(new Point3d(-sectorClicked.borderOffset, 0.0, 0.0).rotateY(this.genRotation));
            }
            this.lanesOccupied = this.areStaticLanesOccupied();
        }
    }

    private boolean areDynamicLanesOccupied() {
        for (RoadLane lane : this.roadClicked.lanes) {
            for (List<RoadLaneConnection> curveConnections : this.clickedStart ? lane.priorConnections : lane.nextConnections) {
                if (curveConnections.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areStaticLanesOccupied() {
        for (RoadLane lane : this.roadClicked.lanes) {
            if (lane.sectorNumber != ((JSONRoadComponent)this.roadClicked.definition).road.sectors.indexOf(this.sectorClicked)) continue;
            for (List<RoadLaneConnection> curveConnections : lane.priorConnections) {
                if (curveConnections.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

