/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLaneConnection;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;

public class RoadFollowingState {
    public final RoadLane lane;
    public final BezierCurve curve;
    public final boolean goingForwards;
    public float currentSegment;

    public RoadFollowingState(RoadLane lane, BezierCurve curve, boolean goingForwards, float currentSegment) {
        this.lane = lane;
        this.curve = curve;
        this.goingForwards = goingForwards;
        this.currentSegment = currentSegment;
    }

    public RoadFollowingState(RoadFollowingState state) {
        this.lane = state.lane;
        this.curve = state.curve;
        this.goingForwards = state.goingForwards;
        this.currentSegment = state.currentSegment;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RoadFollowingState) {
            RoadFollowingState other = (RoadFollowingState)obj;
            return this.lane.equals(other.lane) && this.curve.equals(other.curve);
        }
        return false;
    }

    public RoadFollowingState updateCurvePoints(float segmentDelta, RoadLane.LaneSelectionRequest requestedNextCurve) {
        if (this.lane.road.isActive()) {
            this.currentSegment += this.goingForwards ? segmentDelta : -segmentDelta;
            if (this.currentSegment < 0.0f) {
                TileEntityRoad priorRoad;
                RoadLaneConnection priorConnection = this.lane.getConnection(this.curve, requestedNextCurve, false);
                if (priorConnection != null && (priorRoad = (TileEntityRoad)this.lane.road.world.getTileEntity(priorConnection.tileLocation)) != null) {
                    float segmentRemainder;
                    RoadLane priorLane = priorRoad.lanes.get(priorConnection.laneNumber);
                    BezierCurve priorCurve = priorLane.curves.get(priorConnection.curveNumber);
                    boolean newForwardsState = priorConnection.connectedToStart ? !this.goingForwards : this.goingForwards;
                    float f = segmentRemainder = priorConnection.connectedToStart ? -this.currentSegment : this.currentSegment;
                    if (!newForwardsState) {
                        segmentRemainder = -segmentRemainder;
                    }
                    return new RoadFollowingState(priorLane, priorCurve, newForwardsState, priorConnection.connectedToStart ? 0.0f : priorCurve.pathLength).updateCurvePoints(segmentRemainder, requestedNextCurve);
                }
                return null;
            }
            if (this.currentSegment > this.curve.pathLength) {
                TileEntityRoad nextRoad;
                RoadLaneConnection nextConnection = this.lane.getConnection(this.curve, requestedNextCurve, true);
                if (nextConnection != null && (nextRoad = (TileEntityRoad)this.lane.road.world.getTileEntity(nextConnection.tileLocation)) != null) {
                    float segmentRemainder;
                    RoadLane nextLane = nextRoad.lanes.get(nextConnection.laneNumber);
                    BezierCurve nextCurve = nextLane.curves.get(nextConnection.curveNumber);
                    boolean newForwardsState = nextConnection.connectedToStart ? this.goingForwards : !this.goingForwards;
                    float f = segmentRemainder = nextConnection.connectedToStart ? this.currentSegment - this.curve.pathLength : -(this.currentSegment - this.curve.pathLength);
                    if (!newForwardsState) {
                        segmentRemainder = -segmentRemainder;
                    }
                    return new RoadFollowingState(nextLane, nextCurve, newForwardsState, nextConnection.connectedToStart ? 0.0f : nextCurve.pathLength).updateCurvePoints(segmentRemainder, requestedNextCurve);
                }
                return null;
            }
            return this;
        }
        return null;
    }

    public Point3d getCurrentPoint() {
        Point3d currentPoint = this.lane.road.position.copy().add(0.5, (float)((JSONRoadComponent)this.lane.road.definition).road.collisionHeight / 16.0f, 0.5);
        this.curve.offsetPointByPositionAt(currentPoint, this.currentSegment);
        return currentPoint;
    }
}

