/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLaneConnection;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadConnectionUpdate;

public class RoadLane {
    public final TileEntityRoad road;
    public final int sectorNumber;
    public final int laneNumber;
    public final List<BezierCurve> curves;
    public final List<List<RoadLaneConnection>> priorConnections;
    public final List<List<RoadLaneConnection>> nextConnections;
    private static final double CURVE_CONNECTION_MAX_DISTANCE = 0.2;

    public RoadLane(TileEntityRoad road, int sectorNumber, int laneNumber, WrapperNBT data) {
        int i;
        this.road = road;
        this.sectorNumber = sectorNumber;
        this.laneNumber = laneNumber;
        this.curves = new ArrayList<BezierCurve>();
        this.generateCurves();
        this.priorConnections = new ArrayList<List<RoadLaneConnection>>();
        this.nextConnections = new ArrayList<List<RoadLaneConnection>>();
        for (i = 0; i < this.curves.size(); ++i) {
            this.priorConnections.add(new ArrayList());
            this.nextConnections.add(new ArrayList());
        }
        if (data != null) {
            for (i = 0; i < this.curves.size(); ++i) {
                WrapperNBT connectionData;
                int j;
                int numberPriorConnections = data.getInteger("numberPriorConnections" + i);
                int numberNextConnections = data.getInteger("numberNextConnections" + i);
                for (j = 0; j < numberPriorConnections; ++j) {
                    connectionData = data.getData("priorConnection" + i + "_" + j);
                    this.priorConnections.get(i).add(new RoadLaneConnection(connectionData));
                }
                for (j = 0; j < numberNextConnections; ++j) {
                    connectionData = data.getData("nextConnection" + i + "_" + j);
                    this.nextConnections.get(i).add(new RoadLaneConnection(connectionData));
                }
            }
        }
    }

    private Point3d generateCurves() {
        if (this.road.dynamicCurve != null) {
            BezierCurve dynamicCurve = this.road.dynamicCurve.generateOffsetCurve(((JSONRoadComponent)this.road.definition).road.laneOffsets[this.laneNumber]);
            this.curves.add(dynamicCurve);
            return dynamicCurve.startPos;
        }
        int offsetSectorLaneNumber = this.laneNumber;
        for (JSONRoadComponent.JSONLaneSector sector : ((JSONRoadComponent)this.road.definition).road.sectors) {
            if (offsetSectorLaneNumber < sector.lanes.size()) break;
            offsetSectorLaneNumber -= sector.lanes.size();
        }
        JSONRoadComponent.JSONLaneSector sector = ((JSONRoadComponent)this.road.definition).road.sectors.get(this.sectorNumber);
        JSONRoadComponent.JSONLaneSectorPointSet points = sector.lanes.get(offsetSectorLaneNumber);
        for (JSONRoadComponent.JSONLaneSectorEndPoint endPoint : points.endPoints) {
            this.curves.add(new BezierCurve(points.startPoint.copy().add(-0.5, 0.0, -0.5).rotateFine(this.road.angles), endPoint.pos.copy().add(-0.5, 0.0, -0.5).rotateFine(this.road.angles), sector.sectorStartAngle + (float)this.road.angles.y, endPoint.angle + (float)this.road.angles.y));
        }
        return points.startPoint;
    }

    public void generateConnections() {
        for (BezierCurve curve : this.curves) {
            this.checkAndAddConnections(curve, true);
            this.checkAndAddConnections(curve, false);
        }
    }

    private void checkAndAddConnections(BezierCurve curve, boolean checkingStart) {
        int curveNumber = this.curves.indexOf(curve);
        for (int j = -1; j >= -2; --j) {
            TileEntityRoad otherRoad;
            Point3d ownCurvePoint;
            Point3d offsetPoint;
            boolean foundRoadsThisCheck = false;
            if (checkingStart) {
                offsetPoint = new Point3d(0.0, 0.0, j).rotateY(curve.startAngle).add(curve.startPos).add(this.road.position);
                ownCurvePoint = curve.startPos.copy().add(this.road.position);
            } else {
                offsetPoint = new Point3d(0.0, 0.0, j).rotateY(curve.endAngle).add(curve.endPos).add(this.road.position);
                ownCurvePoint = curve.endPos.copy().add(this.road.position);
            }
            ABlockBase block = this.road.world.getBlock(offsetPoint);
            if (block instanceof BlockCollision && !(otherRoad = ((BlockCollision)block).getMasterRoad(this.road.world, offsetPoint)).equals(this.road)) {
                foundRoadsThisCheck = true;
                for (RoadLane otherRoadLane : otherRoad.lanes) {
                    for (BezierCurve otherRoadCurve : otherRoadLane.curves) {
                        RoadLaneConnection ourConnection;
                        Point3d otherCurveStart = otherRoadCurve.startPos.copy().add(otherRoad.position);
                        Point3d otherCurveEnd = otherRoadCurve.endPos.copy().add(otherRoad.position);
                        int otherCurveNumber = otherRoadLane.curves.indexOf(otherRoadCurve);
                        if (checkingStart) {
                            if (ownCurvePoint.distanceTo(otherCurveStart) < 0.2) {
                                this.priorConnections.get(curveNumber).add(new RoadLaneConnection(otherRoadLane, otherRoadCurve, true));
                                ourConnection = new RoadLaneConnection(this, curve, true);
                                otherRoadLane.priorConnections.get(otherCurveNumber).add(ourConnection);
                                InterfacePacket.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherRoadLane, otherCurveNumber, true, ourConnection));
                                continue;
                            }
                            if (!(ownCurvePoint.distanceTo(otherCurveEnd) < 0.2)) continue;
                            this.priorConnections.get(curveNumber).add(new RoadLaneConnection(otherRoadLane, otherRoadCurve, false));
                            ourConnection = new RoadLaneConnection(this, curve, true);
                            otherRoadLane.nextConnections.get(otherCurveNumber).add(ourConnection);
                            InterfacePacket.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherRoadLane, otherCurveNumber, false, ourConnection));
                            continue;
                        }
                        if (ownCurvePoint.distanceTo(otherCurveStart) < 0.2) {
                            this.nextConnections.get(curveNumber).add(new RoadLaneConnection(otherRoadLane, otherRoadCurve, true));
                            ourConnection = new RoadLaneConnection(this, curve, false);
                            otherRoadLane.priorConnections.get(otherCurveNumber).add(ourConnection);
                            InterfacePacket.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherRoadLane, otherCurveNumber, true, ourConnection));
                            continue;
                        }
                        if (!(ownCurvePoint.distanceTo(otherCurveEnd) < 0.2)) continue;
                        this.nextConnections.get(curveNumber).add(new RoadLaneConnection(otherRoadLane, otherRoadCurve, false));
                        ourConnection = new RoadLaneConnection(this, curve, false);
                        otherRoadLane.nextConnections.get(otherCurveNumber).add(ourConnection);
                        InterfacePacket.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherRoadLane, otherCurveNumber, false, ourConnection));
                    }
                }
            }
            if (foundRoadsThisCheck) break;
        }
    }

    public void removeConnections() {
        RoadLane otherLane;
        TileEntityRoad otherRoad;
        for (List<RoadLaneConnection> curvePriorConnections : this.priorConnections) {
            for (RoadLaneConnection curvePriorConnection : curvePriorConnections) {
                try {
                    otherRoad = (TileEntityRoad)this.road.world.getTileEntity(curvePriorConnection.tileLocation);
                    otherLane = otherRoad.lanes.get(curvePriorConnection.laneNumber);
                    if (curvePriorConnection.connectedToStart) {
                        otherLane.priorConnections.get(curvePriorConnection.curveNumber).clear();
                        InterfacePacket.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherLane, curvePriorConnection.curveNumber, true));
                        continue;
                    }
                    otherLane.nextConnections.get(curvePriorConnection.curveNumber).clear();
                    InterfacePacket.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherLane, curvePriorConnection.curveNumber, false));
                }
                catch (Exception e) {
                    InterfaceCore.logError("Couldn't get TE at position " + curvePriorConnection.tileLocation + " to break prior road connection.  Was it changed?");
                }
            }
        }
        for (List<RoadLaneConnection> curveNextConnections : this.nextConnections) {
            for (RoadLaneConnection curveNextConnection : curveNextConnections) {
                try {
                    otherRoad = (TileEntityRoad)this.road.world.getTileEntity(curveNextConnection.tileLocation);
                    otherLane = otherRoad.lanes.get(curveNextConnection.laneNumber);
                    if (curveNextConnection.connectedToStart) {
                        otherLane.priorConnections.get(curveNextConnection.curveNumber).clear();
                        InterfacePacket.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherLane, curveNextConnection.curveNumber, true));
                        continue;
                    }
                    otherLane.nextConnections.get(curveNextConnection.curveNumber).clear();
                    InterfacePacket.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherLane, curveNextConnection.curveNumber, false));
                }
                catch (Exception e) {
                    InterfaceCore.logError("Couldn't get TE at position " + curveNextConnection.tileLocation + " to break next road connection.  Was it changed?");
                }
            }
        }
    }

    public RoadLaneConnection getConnection(BezierCurve curve, LaneSelectionRequest requestedNextCurve, boolean nextCurve) {
        List<RoadLaneConnection> connections;
        List<RoadLaneConnection> list = connections = nextCurve ? this.nextConnections.get(this.curves.indexOf(curve)) : this.priorConnections.get(this.curves.indexOf(curve));
        if (!connections.isEmpty()) {
            connections.sort(new Comparator<RoadLaneConnection>(){

                @Override
                public int compare(RoadLaneConnection arg0, RoadLaneConnection arg1) {
                    return arg0.curveNetAngle < arg1.curveNetAngle ? -1 : (arg0.curveNetAngle > arg1.curveNetAngle ? 1 : 0);
                }
            });
            switch (requestedNextCurve) {
                case LEFT: {
                    return connections.get(connections.size() - 1);
                }
                case RIGHT: {
                    return connections.get(0);
                }
                case NONE: {
                    return connections.get(connections.size() / 2);
                }
            }
        }
        return null;
    }

    public WrapperNBT getData() {
        WrapperNBT data = new WrapperNBT();
        data.setInteger("sectorNumber", this.sectorNumber);
        data.setInteger("laneNumber", this.laneNumber);
        for (int i = 0; i < this.curves.size(); ++i) {
            WrapperNBT connectionData;
            int j;
            List<RoadLaneConnection> priorCurveConnections = this.priorConnections.get(i);
            List<RoadLaneConnection> nextCurveConnections = this.nextConnections.get(i);
            for (j = 0; j < priorCurveConnections.size(); ++j) {
                connectionData = new WrapperNBT();
                priorCurveConnections.get(j).save(connectionData);
                data.setData("priorConnection" + i + "_" + j, connectionData);
            }
            data.setInteger("numberPriorConnections" + i, priorCurveConnections.size());
            for (j = 0; j < nextCurveConnections.size(); ++j) {
                connectionData = new WrapperNBT();
                nextCurveConnections.get(j).save(connectionData);
                data.setData("nextConnection" + i + "_" + j, connectionData);
            }
            data.setInteger("numberNextConnections" + i, nextCurveConnections.size());
        }
        return data;
    }

    public static enum LaneSelectionRequest {
        LEFT,
        RIGHT,
        NONE;

    }
}

