/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.mcinterface.WrapperNBT;

public class RoadLaneConnection {
    public final Point3d tileLocation;
    public final int laneNumber;
    public final int curveNumber;
    public final float curveNetAngle;
    public final boolean connectedToStart;

    public RoadLaneConnection(RoadLane lane, BezierCurve curve, boolean connectedToStart) {
        float angle;
        this.tileLocation = lane.road.position;
        this.laneNumber = lane.laneNumber;
        this.curveNumber = lane.curves.indexOf(curve);
        float f = angle = connectedToStart ? curve.endAngle + 180.0f - curve.startAngle : curve.startAngle + 180.0f - curve.endAngle;
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        this.curveNetAngle = angle;
        this.connectedToStart = connectedToStart;
    }

    public RoadLaneConnection(Point3d tileLocation, int laneNumber, int curveNumber, float curveNetAngle, boolean connectedToStart) {
        this.tileLocation = tileLocation;
        this.laneNumber = laneNumber;
        this.curveNumber = curveNumber;
        this.curveNetAngle = curveNetAngle;
        this.connectedToStart = connectedToStart;
    }

    public RoadLaneConnection(WrapperNBT data) {
        this.tileLocation = data.getPoint3dCompact("tileLocation");
        this.laneNumber = data.getInteger("laneNumber");
        this.curveNumber = data.getInteger("curveNumber");
        this.curveNetAngle = (float)data.getDouble("curveNetAngle");
        this.connectedToStart = data.getBoolean("connectedToStart");
    }

    public void save(WrapperNBT data) {
        data.setPoint3dCompact("tileLocation", this.tileLocation);
        data.setInteger("laneNumber", this.laneNumber);
        data.setInteger("curveNumber", this.curveNumber);
        data.setDouble("curveNetAngle", this.curveNetAngle);
        data.setBoolean("connectedToStart", this.connectedToStart);
    }
}

