/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.NavBeacon;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;

public class TileEntityBeacon
extends TileEntityDecor {
    public NavBeacon currentBeacon;

    public TileEntityBeacon(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, position, placingPlayer, data);
    }

    @Override
    protected void initializeDefinition() {
        super.initializeDefinition();
        Iterator iterator = this.text.keySet().iterator();
        if (iterator.hasNext()) {
            JSONText textDef = (JSONText)iterator.next();
            this.currentBeacon = NavBeacon.getByNameFromWorld(this.world, (String)this.text.get(textDef));
            return;
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        super.destroy(box);
        if (this.currentBeacon != null) {
            NavBeacon.removeFromWorld(this.world, this.currentBeacon.name);
        }
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
        return true;
    }

    @Override
    public void updateText(List<String> textLines) {
        if (this.currentBeacon != null) {
            NavBeacon.removeFromWorld(this.world, this.currentBeacon.name);
            this.currentBeacon = null;
        }
        try {
            NavBeacon newBeacon = new NavBeacon(this.world, textLines.get(0), Double.valueOf(textLines.get(1)), Double.valueOf(textLines.get(2)), this.position);
            super.updateText(textLines);
            this.currentBeacon = newBeacon;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

