/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;

public class TileEntityChest
extends TileEntityDecor {
    public final EntityInventoryContainer inventory;

    public TileEntityChest(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, position, placingPlayer, data);
        this.inventory = new EntityInventoryContainer(world, data.getDataOrNew("inventory"), (int)(((JSONDecor)this.definition).decor.inventoryUnits * 9.0f));
        world.addEntity(this.inventory);
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.INVENTORY_CHEST));
        return true;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "inventory_count": {
                if (this.inventory != null) {
                    return this.inventory.getCount();
                }
                return 0.0;
            }
            case "inventory_percent": {
                if (this.inventory != null) {
                    return (double)this.inventory.getCount() / (double)this.inventory.getSize();
                }
                return 0.0;
            }
            case "inventory_capacity": {
                if (this.inventory != null) {
                    return this.inventory.getSize();
                }
                return 0.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        if (this.inventory != null) {
            data.setData("inventory", this.inventory.save(new WrapperNBT()));
        }
        return data;
    }
}

