/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.rendering.instances.RenderDecor;

public class TileEntityDecor
extends ATileEntityBase<JSONDecor> {
    public static final String CLICKED_VARIABLE = "clicked";
    public static final String ACTIVATED_VARIABLE = "activated";
    private static RenderDecor renderer;

    public TileEntityDecor(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, position, placingPlayer, data);
        if ((double)((JSONDecor)this.definition).decor.height != 1.0) {
            this.boundingBox = new BoundingBox(position.copy().add(0.0, (double)((JSONDecor)this.definition).decor.height / 2.0 - 0.5, 0.0), 0.0, 0.0, 0.0);
        }
        this.boundingBox.heightRadius = (double)((JSONDecor)this.definition).decor.height / 2.0;
        if (Math.abs(this.angles.y % 180.0) == 0.0) {
            this.boundingBox.widthRadius = (double)((JSONDecor)this.definition).decor.width / 2.0;
            this.boundingBox.depthRadius = (double)((JSONDecor)this.definition).decor.depth / 2.0;
        } else {
            this.boundingBox.widthRadius = (double)((JSONDecor)this.definition).decor.depth / 2.0;
            this.boundingBox.depthRadius = (double)((JSONDecor)this.definition).decor.width / 2.0;
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.setVariable(CLICKED_VARIABLE, 0.0);
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        if (player.isHoldingItemType(JSONItem.ItemComponentType.PAINT_GUN)) {
            return false;
        }
        if (((JSONDecor)this.definition).decor.crafting != null) {
            if (!this.world.isClient()) {
                player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.PART_BENCH));
            }
        } else if (!this.text.isEmpty() && !this.world.isClient()) {
            player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
        }
        if (!this.world.isClient()) {
            this.setVariable(CLICKED_VARIABLE, 1.0);
            this.toggleVariable(ACTIVATED_VARIABLE);
            InterfacePacket.sendToAllClients(new PacketEntityVariableSet(this, CLICKED_VARIABLE, 1.0));
            InterfacePacket.sendToAllClients(new PacketEntityVariableToggle(this, ACTIVATED_VARIABLE));
        }
        return true;
    }

    @Override
    public int getRotationIncrement() {
        return 90;
    }

    @Override
    public float getLightProvided() {
        return ((JSONDecor)this.definition).decor.lightLevel;
    }

    public RenderDecor getRenderer() {
        if (renderer == null) {
            renderer = new RenderDecor();
        }
        return renderer;
    }
}

