/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityLoader;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;

public class TileEntityFluidLoader
extends ATileEntityLoader
implements ITileEntityFluidTankProvider {
    private EntityFluidTank tank;

    public TileEntityFluidLoader(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, position, placingPlayer, data);
        this.tank = new EntityFluidTank(world, data.getDataOrNew("tank"), ((JSONDecor)this.definition).decor.fuelCapacity);
        world.addEntity(this.tank);
    }

    @Override
    public void connectToPart(PartInteractable part) {
        super.connectToPart(part);
        if (part != null) {
            this.tank.resetAmountDispensed();
        }
    }

    @Override
    public boolean isUnloader() {
        return ((JSONDecor)this.definition).decor.type.equals((Object)JSONDecor.DecorComponentType.FLUID_UNLOADER);
    }

    @Override
    protected boolean canOperate() {
        return this.isUnloader() ? this.tank.getFluidLevel() < (double)this.tank.getMaxLevel() : this.tank.getFluidLevel() > 0.0;
    }

    @Override
    protected boolean canLoadPart(PartInteractable part) {
        if (part.tank != null) {
            return this.isUnloader() ? part.tank.drain(this.tank.getFluid(), 1.0, false) > 0.0 : part.tank.fill(this.tank.getFluid(), 1.0, false) > 0.0;
        }
        return false;
    }

    @Override
    protected void doLoading() {
        String fluidToLoad = this.tank.getFluid();
        double amountToLoad = this.connectedPart.tank.fill(fluidToLoad, ((JSONDecor)this.definition).decor.pumpRate, false);
        if (amountToLoad > 0.0) {
            amountToLoad = this.tank.drain(fluidToLoad, amountToLoad, true);
            this.connectedPart.tank.fill(fluidToLoad, amountToLoad, true);
        } else {
            this.updateNearestPart();
        }
    }

    @Override
    protected void doUnloading() {
        String fluidToUnload = this.connectedPart.tank.getFluid();
        double amountToUnload = this.connectedPart.tank.drain(fluidToUnload, ((JSONDecor)this.definition).decor.pumpRate, false);
        if (amountToUnload > 0.0) {
            amountToUnload = this.tank.fill(fluidToUnload, amountToUnload, true);
            this.connectedPart.tank.drain(fluidToUnload, amountToUnload, true);
        } else {
            this.updateNearestPart();
        }
    }

    @Override
    public EntityFluidTank getTank() {
        return this.tank;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setData("tank", this.tank.save(new WrapperNBT()));
        return data;
    }
}

