/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemPartInteractable;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpConnection;
import minecrafttransportsimulator.systems.ConfigSystem;

public class TileEntityFuelPump
extends TileEntityDecor
implements ITileEntityFluidTankProvider {
    public EntityVehicleF_Physics connectedVehicle;
    private final EntityFluidTank tank;
    public final EntityInventoryContainer fuelItems;
    public final List<Integer> fuelAmounts = new ArrayList<Integer>();
    public int fuelPurchasedRemaining;
    public boolean isCreative;
    public UUID placingPlayerID;

    public TileEntityFuelPump(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, position, placingPlayer, data);
        this.tank = new EntityFluidTank(world, data.getDataOrNew("tank"), ((JSONDecor)this.definition).decor.fuelCapacity){

            @Override
            public double fill(String fluid, double maxAmount, boolean doFill) {
                if (!TileEntityFuelPump.this.isCreative) {
                    if (TileEntityFuelPump.this.fuelPurchasedRemaining == 0 && TileEntityFuelPump.this.connectedVehicle == null && this.getFluidLevel() == 0.0) {
                        maxAmount = 1.0;
                    } else if (maxAmount > (double)TileEntityFuelPump.this.fuelPurchasedRemaining) {
                        maxAmount = TileEntityFuelPump.this.fuelPurchasedRemaining;
                    }
                    double amountFilled = super.fill(fluid, maxAmount, doFill);
                    if (doFill && TileEntityFuelPump.this.fuelPurchasedRemaining > 0) {
                        TileEntityFuelPump.this.fuelPurchasedRemaining = (int)((double)TileEntityFuelPump.this.fuelPurchasedRemaining - amountFilled);
                    }
                    return amountFilled;
                }
                return super.fill(fluid, maxAmount, doFill);
            }
        };
        world.addEntity(this.tank);
        this.fuelItems = new EntityInventoryContainer(world, data.getDataOrNew("inventory"), 10);
        world.addEntity(this.fuelItems);
        for (int i = 0; i < this.fuelItems.getSize(); ++i) {
            this.fuelAmounts.add(data.getInteger("fuelAmount" + i));
        }
        this.fuelPurchasedRemaining = data.getInteger("fuelPurchasedRemaining");
        this.placingPlayerID = placingPlayer != null ? placingPlayer.getID() : data.getUUID("placingPlayerID");
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.isCreative = true;
            for (int i = 0; i < this.fuelItems.getSize(); ++i) {
                if (this.fuelItems.getStack(i).isEmpty()) continue;
                this.isCreative = false;
            }
            if (this.connectedVehicle != null && !this.world.isClient()) {
                if (!this.connectedVehicle.isValid) {
                    this.connectedVehicle.beingFueled = false;
                    this.connectedVehicle = null;
                    return false;
                }
                if (this.connectedVehicle.position.distanceTo(this.position) > 16.0) {
                    InterfacePacket.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, false));
                    for (WrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(this.position, 25.0, 25.0, 25.0))) {
                        if (!(entity instanceof WrapperPlayer)) continue;
                        ((WrapperPlayer)entity).sendPacket(new PacketPlayerChatMessage((WrapperPlayer)entity, "interact.fuelpump.toofar"));
                    }
                    this.connectedVehicle.beingFueled = false;
                    this.connectedVehicle = null;
                    return false;
                }
                if (this.tank.getFluidLevel() > 0.0) {
                    double amountToFill = this.connectedVehicle.fuelTank.fill(this.tank.getFluid(), ((JSONDecor)this.definition).decor.pumpRate, false);
                    if (amountToFill > 0.0) {
                        double amountToDrain = this.tank.drain(this.tank.getFluid(), amountToFill, false);
                        this.connectedVehicle.fuelTank.fill(this.tank.getFluid(), amountToDrain, true);
                        this.tank.drain(this.tank.getFluid(), amountToDrain, true);
                    } else {
                        InterfacePacket.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, false));
                        this.connectedVehicle.beingFueled = false;
                        this.connectedVehicle = null;
                        for (WrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                            if (!(entity instanceof WrapperPlayer)) continue;
                            ((WrapperPlayer)entity).sendPacket(new PacketPlayerChatMessage((WrapperPlayer)entity, "interact.fuelpump.complete"));
                        }
                    }
                } else {
                    InterfacePacket.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, false));
                    this.connectedVehicle.beingFueled = false;
                    this.connectedVehicle = null;
                    for (WrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                        if (!(entity instanceof WrapperPlayer)) continue;
                        ((WrapperPlayer)entity).sendPacket(new PacketPlayerChatMessage((WrapperPlayer)entity, "interact.fuelpump.empty"));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        if (player.getHeldStack().interactWith(this.tank, player)) {
            return true;
        }
        WrapperItemStack stack = player.getHeldStack();
        AItemBase item = stack.getItem();
        if (item instanceof ItemPartInteractable) {
            ItemPartInteractable interactable = (ItemPartInteractable)item;
            if (((JSONPart)interactable.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
                WrapperNBT data = stack.getData();
                if (data.getString("jerrycanFluid").isEmpty() && this.tank.getFluidLevel() >= 1000.0) {
                    data.setString("jerrycanFluid", this.tank.getFluid());
                    stack.setData(data);
                    this.tank.drain(this.tank.getFluid(), 1000.0, true);
                }
                return true;
            }
        }
        if (player.isHoldingItemType(JSONItem.ItemComponentType.WRENCH) && (player.getID().equals(this.placingPlayerID) || player.isOP())) {
            player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.FUEL_PUMP_CONFIG));
            return true;
        }
        if (!this.isCreative && this.fuelPurchasedRemaining == 0 && this.tank.getFluidLevel() <= 1.0) {
            player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.FUEL_PUMP));
            return true;
        }
        if (this.connectedVehicle == null) {
            EntityVehicleF_Physics nearestVehicle = null;
            double lowestDistance = 16.0;
            for (EntityVehicleF_Physics testVehicle : this.world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                double vehicleDistance = testVehicle.position.distanceTo(this.position);
                if (!(vehicleDistance < lowestDistance)) continue;
                lowestDistance = vehicleDistance;
                nearestVehicle = testVehicle;
            }
            if (nearestVehicle != null) {
                if (this.tank.getFluidLevel() == 0.0) {
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelpump.nofuel"));
                } else {
                    if (!nearestVehicle.fuelTank.getFluid().isEmpty() && !this.tank.getFluid().equals(nearestVehicle.fuelTank.getFluid())) {
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelpump.wrongtype"));
                        return true;
                    }
                    for (APart part : nearestVehicle.parts) {
                        if (!(part instanceof PartEngine) || !ConfigSystem.configObject.fuel.fuels.get(((JSONPart)part.definition).engine.fuelType).containsKey(this.tank.getFluid())) continue;
                        this.connectedVehicle = nearestVehicle;
                        this.connectedVehicle.beingFueled = true;
                        this.tank.resetAmountDispensed();
                        InterfacePacket.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, true));
                        player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelpump.connect"));
                        return true;
                    }
                    player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelpump.wrongengines"));
                }
            } else {
                player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelpump.toofar"));
            }
        } else {
            InterfacePacket.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, false));
            this.connectedVehicle.beingFueled = false;
            this.connectedVehicle = null;
            player.sendPacket(new PacketPlayerChatMessage(player, "interact.fuelpump.disconnect"));
        }
        return true;
    }

    @Override
    public EntityFluidTank getTank() {
        return this.tank;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "fuelpump_active": {
                return this.connectedVehicle != null ? 1.0 : 0.0;
            }
            case "fuelpump_stored": {
                return this.tank.getFluidLevel();
            }
            case "fuelpump_dispensed": {
                return this.tank.getAmountDispensed();
            }
            case "fuelpump_free": {
                return this.isCreative ? 1.0 : 0.0;
            }
            case "fuelpump_purchased": {
                return this.fuelPurchasedRemaining;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public String getRawTextVariableValue(JSONText textDef, float partialTicks) {
        if (textDef.variableName.equals("fuelpump_fluid")) {
            return this.tank.getFluidLevel() > 0.0 ? InterfaceCore.getFluidName(this.tank.getFluid()) : "";
        }
        return super.getRawTextVariableValue(textDef, partialTicks);
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setData("tank", this.tank.save(new WrapperNBT()));
        data.setData("inventory", this.fuelItems.save(new WrapperNBT()));
        for (int i = 0; i < this.fuelItems.getSize(); ++i) {
            data.setInteger("fuelAmount" + i, this.fuelAmounts.get(i));
        }
        data.setInteger("fuelPurchasedRemaining", this.fuelPurchasedRemaining);
        if (this.placingPlayerID != null) {
            data.setUUID("placingPlayerID", this.placingPlayerID);
        }
        return data;
    }
}

