/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockPole;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleChange;
import minecrafttransportsimulator.rendering.instances.RenderPole;
import minecrafttransportsimulator.systems.ConfigSystem;

public class TileEntityPole
extends ATileEntityBase<JSONPoleComponent> {
    public final Map<ABlockBase.Axis, ATileEntityPole_Component> components = new HashMap<ABlockBase.Axis, ATileEntityPole_Component>();
    private float maxTotalLightLevel;
    private static RenderPole renderer;

    public TileEntityPole(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, position, placingPlayer, data);
        this.boundingBox = new BoundingBox(new Point3d(), 0.0, 0.0, 0.0);
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            WrapperNBT componentData = data.getData(axis.name());
            if (componentData != null) {
                ATileEntityPole_Component newComponent = ItemPoleComponent.PoleComponentType.createComponent(this, placingPlayer, axis, componentData);
                this.changeComponent(axis, newComponent);
                continue;
            }
            if (!axis.equals((Object)ABlockBase.Axis.NONE)) continue;
            this.changeComponent(axis, ItemPoleComponent.PoleComponentType.createComponent(this, placingPlayer, axis, data));
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            for (ATileEntityPole_Component component : this.components.values()) {
                component.update();
            }
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        super.remove();
        for (ATileEntityPole_Component component : this.components.values()) {
            component.remove();
        }
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        TileEntityPole pole = (TileEntityPole)this.world.getTileEntity(this.position);
        if (pole != null) {
            ABlockBase.Axis axis = ABlockBase.Axis.getFromRotation(player.getYaw(), ((JSONPoleComponent)pole.definition).pole.allowsDiagonals).getOpposite();
            WrapperItemStack heldStack = player.getHeldStack();
            AItemBase heldItem = heldStack.getItem();
            ATileEntityPole_Component clickedComponent = pole.components.get((Object)axis);
            if (!((Boolean)ConfigSystem.configObject.general.opSignEditingOnly.value).booleanValue() || player.isOP()) {
                if (player.isHoldingItemType(JSONItem.ItemComponentType.WRENCH)) {
                    if (pole.components.containsKey((Object)axis)) {
                        ATileEntityPole_Component component = pole.components.get((Object)axis);
                        if (player.isCreative() || player.getInventory().addStack(((AItemBase)component.getItem()).getNewStack(component.save(new WrapperNBT())))) {
                            this.changeComponent(axis, null);
                            InterfacePacket.sendToAllClients(new PacketTileEntityPoleChange(this, player, axis, null));
                        }
                        return true;
                    }
                } else {
                    if (clickedComponent instanceof TileEntityPole_Sign && ((JSONPoleComponent)clickedComponent.definition).rendering != null && ((JSONPoleComponent)clickedComponent.definition).rendering.textObjects != null) {
                        player.sendPacket(new PacketEntityGUIRequest(clickedComponent, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
                        return true;
                    }
                    if (heldItem instanceof ItemPoleComponent && !((JSONPoleComponent)((ItemPoleComponent)heldItem).definition).pole.type.equals((Object)ItemPoleComponent.PoleComponentType.CORE) && !pole.components.containsKey((Object)axis)) {
                        ItemPoleComponent componentItem = (ItemPoleComponent)heldItem;
                        WrapperNBT stackData = heldStack.getData();
                        componentItem.populateDefaultData(stackData);
                        ATileEntityPole_Component newComponent = ItemPoleComponent.PoleComponentType.createComponent(pole, player, axis, stackData);
                        this.changeComponent(axis, newComponent);
                        if (!player.isCreative()) {
                            player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
                        }
                        InterfacePacket.sendToAllClients(new PacketTileEntityPoleChange(this, player, axis, newComponent.save(new WrapperNBT())));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public int getRotationIncrement() {
        return 360;
    }

    @Override
    public BoundingBox getCollisionBox() {
        this.boundingBox.widthRadius = ((JSONPoleComponent)this.definition).pole.radius;
        this.boundingBox.heightRadius = ((JSONPoleComponent)this.definition).pole.radius;
        this.boundingBox.depthRadius = ((JSONPoleComponent)this.definition).pole.radius;
        this.boundingBox.globalCenter.setTo(this.position);
        block8: for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            if (!axis.blockBased || !(this.world.getBlock(axis.getOffsetPoint(this.position)) instanceof BlockPole) && !this.world.isBlockSolid(axis.getOffsetPoint(this.position), axis.getOpposite()) && !this.components.containsKey((Object)axis)) continue;
            switch (axis) {
                case NORTH: {
                    if (this.boundingBox.depthRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.depthRadius = (double)((JSONPoleComponent)this.definition).pole.radius + 0.25;
                        this.boundingBox.globalCenter.z = this.position.z - (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.depthRadius = 0.5;
                    this.boundingBox.globalCenter.z = this.position.z;
                    continue block8;
                }
                case SOUTH: {
                    if (this.boundingBox.depthRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.depthRadius = (double)((JSONPoleComponent)this.definition).pole.radius + 0.25;
                        this.boundingBox.globalCenter.z = this.position.z + (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.depthRadius = 0.5;
                    this.boundingBox.globalCenter.z = this.position.z;
                    continue block8;
                }
                case EAST: {
                    if (this.boundingBox.widthRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.widthRadius = (double)((JSONPoleComponent)this.definition).pole.radius + 0.25;
                        this.boundingBox.globalCenter.x = this.position.x + (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.widthRadius = 0.5;
                    this.boundingBox.globalCenter.x = this.position.x;
                    continue block8;
                }
                case WEST: {
                    if (this.boundingBox.widthRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.widthRadius = (double)((JSONPoleComponent)this.definition).pole.radius + 0.25;
                        this.boundingBox.globalCenter.x = this.position.x - (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.widthRadius = 0.5;
                    this.boundingBox.globalCenter.x = this.position.x;
                    continue block8;
                }
                case UP: {
                    if (this.boundingBox.heightRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.heightRadius = (double)((JSONPoleComponent)this.definition).pole.radius + 0.25;
                        this.boundingBox.globalCenter.y = this.position.y + (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.heightRadius = 0.5;
                    this.boundingBox.globalCenter.y = this.position.y;
                    continue block8;
                }
                case DOWN: {
                    if (this.boundingBox.heightRadius == (double)((JSONPoleComponent)this.definition).pole.radius) {
                        this.boundingBox.heightRadius = (double)((JSONPoleComponent)this.definition).pole.radius + 0.25;
                        this.boundingBox.globalCenter.y = this.position.y - (0.5 - (double)((JSONPoleComponent)this.definition).pole.radius) / 2.0;
                        continue block8;
                    }
                    this.boundingBox.heightRadius = 0.5;
                    this.boundingBox.globalCenter.y = this.position.y;
                    continue block8;
                }
            }
        }
        return super.getCollisionBox();
    }

    @Override
    public float getLightProvided() {
        return this.maxTotalLightLevel;
    }

    @Override
    public void addDropsToList(List<WrapperItemStack> drops) {
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            ATileEntityPole_Component component = this.components.get((Object)axis);
            if (component == null) continue;
            drops.add(((AItemBase)component.getItem()).getNewStack(component.save(new WrapperNBT())));
        }
    }

    public void changeComponent(ABlockBase.Axis newAxis, ATileEntityPole_Component newComponent) {
        if (newComponent != null) {
            this.components.put(newAxis, newComponent);
            if (newAxis.equals((Object)ABlockBase.Axis.NONE)) {
                newComponent.position.setTo(this.position);
                newComponent.angles.setTo(this.angles);
            } else {
                newComponent.position.set(0.0, 0.0, (double)((JSONPoleComponent)this.definition).pole.radius + 0.001).rotateY(newAxis.yRotation).add(this.position);
                newComponent.angles.set(0.0, newAxis.yRotation, 0.0).add(this.angles);
            }
            newComponent.prevPosition.setTo(newComponent.position);
            newComponent.prevAngles.setTo(newComponent.angles);
            this.world.addEntity(newComponent);
        } else if (this.components.containsKey((Object)newAxis)) {
            this.components.remove((Object)newAxis).remove();
        }
        this.maxTotalLightLevel = 0.0f;
        for (ATileEntityPole_Component component : this.components.values()) {
            this.maxTotalLightLevel = Math.max(this.maxTotalLightLevel, component.getLightProvided());
        }
    }

    public RenderPole getRenderer() {
        if (renderer == null) {
            renderer = new RenderPole();
        }
        return renderer;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        for (Map.Entry<ABlockBase.Axis, ATileEntityPole_Component> connectedObjectEntry : this.components.entrySet()) {
            data.setData(connectedObjectEntry.getKey().name(), connectedObjectEntry.getValue().save(new WrapperNBT()));
        }
        return data;
    }
}

