/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.RoadClickData;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.items.instances.ItemRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadCollisionUpdate;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.rendering.instances.RenderRoad;
import minecrafttransportsimulator.systems.PackParserSystem;

public class TileEntityRoad
extends ATileEntityBase<JSONRoadComponent> {
    public BezierCurve dynamicCurve;
    public final List<RoadLane> lanes;
    private boolean isActive;
    public final Map<RoadComponent, ItemRoadComponent> components = new HashMap<RoadComponent, ItemRoadComponent>();
    public final Map<RoadComponent, RenderableObject> componentRenderables = new HashMap<RoadComponent, RenderableObject>();
    public final List<RenderableObject> devRenderables = new ArrayList<RenderableObject>();
    public final Map<Point3d, RenderableObject> blockingRenderables = new HashMap<Point3d, RenderableObject>();
    public final List<Point3d> collisionBlockOffsets;
    public final List<Point3d> collidingBlockOffsets;
    public static final int MAX_COLLISION_DISTANCE = 32;
    private static RenderRoad renderer;

    public TileEntityRoad(WrapperWorld world, Point3d position, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, position, placingPlayer, data);
        if (placingPlayer != null) {
            int clampAngle = this.getRotationIncrement();
            this.angles.y = Math.round(placingPlayer.getYaw() / (float)clampAngle) * clampAngle % 360;
        }
        this.boundingBox = new BoundingBox(position.copy().add(0.0, (double)(((JSONRoadComponent)this.definition).road.collisionHeight - 16) / 16.0 / 2.0, 0.0), 0.5, (double)((JSONRoadComponent)this.definition).road.collisionHeight / 16.0 / 2.0, 0.5);
        this.isActive = data.getBoolean("isActive");
        for (RoadComponent componentType : RoadComponent.values()) {
            String packID = data.getString("packID" + componentType.name());
            if (packID.isEmpty()) continue;
            String systemName = data.getString("systemName" + componentType.name());
            ItemRoadComponent newComponent = (ItemRoadComponent)PackParserSystem.getItem(packID, systemName);
            this.components.put(componentType, newComponent);
        }
        this.components.put(((JSONRoadComponent)this.definition).road.type, (ItemRoadComponent)this.getItem());
        this.lanes = new ArrayList<RoadLane>();
        Point3d startingOffset = data.getPoint3d("startingOffset");
        Point3d endingOffset = data.getPoint3d("endingOffset");
        if (!endingOffset.isZero()) {
            this.dynamicCurve = new BezierCurve(startingOffset, endingOffset, (float)data.getDouble("startingRotation"), (float)data.getDouble("endingRotation"));
        }
        if (this.isActive()) {
            this.generateLanes(data);
        }
        this.collisionBlockOffsets = data.getPoint3dsCompact("collisionBlockOffsets");
        this.collidingBlockOffsets = data.getPoint3dsCompact("collidingBlockOffsets");
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (active) {
            this.generateLanes(null);
        }
    }

    @Override
    public void addDropsToList(List<WrapperItemStack> drops) {
        for (RoadComponent componentType : RoadComponent.values()) {
            if (!this.components.containsKey((Object)componentType)) continue;
            drops.add(this.components.get((Object)componentType).getNewStack(null));
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (RenderableObject object : this.componentRenderables.values()) {
            object.destroy();
        }
        for (RenderableObject object : this.devRenderables) {
            object.destroy();
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        super.destroy(box);
        if (this.isActive) {
            this.setActive(false);
            for (RoadLane lane : this.lanes) {
                lane.removeConnections();
            }
            for (Point3d blockOffset : this.collisionBlockOffsets) {
                Point3d blockLocation = this.position.copy().add(blockOffset);
                if (!(this.world.getBlock(blockLocation) instanceof BlockCollision)) continue;
                this.world.destroyBlock(blockLocation, true);
            }
        }
    }

    @Override
    public boolean interact(WrapperPlayer player) {
        if (!this.isActive) {
            this.spawnCollisionBlocks(player);
        }
        return true;
    }

    public RoadClickData getClickData(Point3d blockOffsetClicked, boolean curveStart) {
        boolean clickedStart = blockOffsetClicked.isZero() || this.collisionBlockOffsets.indexOf(blockOffsetClicked) < this.collisionBlockOffsets.size() / 2;
        JSONRoadComponent.JSONLaneSector closestSector = null;
        if (!((JSONRoadComponent)this.definition).road.type.equals((Object)RoadComponent.CORE_DYNAMIC)) {
            double closestSectorDistance = Double.MAX_VALUE;
            for (RoadLane lane : this.lanes) {
                double distanceToSectorStart = lane.curves.get((int)0).startPos.distanceTo(blockOffsetClicked);
                if (!(distanceToSectorStart < closestSectorDistance)) continue;
                closestSectorDistance = distanceToSectorStart;
                closestSector = ((JSONRoadComponent)this.definition).road.sectors.get(lane.sectorNumber);
            }
        }
        return new RoadClickData(this, closestSector, clickedStart, curveStart);
    }

    public void generateLanes(WrapperNBT data) {
        if (((JSONRoadComponent)this.definition).road.type.equals((Object)RoadComponent.CORE_DYNAMIC)) {
            for (int i = 0; i < ((JSONRoadComponent)this.definition).road.laneOffsets.length; ++i) {
                this.lanes.add(new RoadLane(this, 0, this.lanes.size(), data != null ? data.getData("lane" + this.lanes.size()) : null));
            }
        } else {
            for (int i = 0; i < ((JSONRoadComponent)this.definition).road.sectors.size(); ++i) {
                for (int j = 0; j < ((JSONRoadComponent)this.definition).road.sectors.get((int)i).lanes.size(); ++j) {
                    this.lanes.add(new RoadLane(this, i, this.lanes.size(), data != null ? data.getData("lane" + this.lanes.size()) : null));
                }
            }
        }
    }

    protected Map<Point3d, Integer> generateCollisionPoints() {
        this.collisionBlockOffsets.clear();
        this.collidingBlockOffsets.clear();
        HashMap<Point3d, Integer> collisionHeightMap = new HashMap<Point3d, Integer>();
        if (((JSONRoadComponent)this.definition).road.type.equals((Object)RoadComponent.CORE_DYNAMIC)) {
            Point3d testOffset = new Point3d();
            Point3d testRotation = new Point3d();
            float segmentDelta = (float)((double)((JSONRoadComponent)this.definition).road.borderOffset / (Math.floor(((JSONRoadComponent)this.definition).road.borderOffset) + 1.0));
            float f = 0.0f;
            while (f < this.dynamicCurve.pathLength) {
                for (float offset = 0.0f; offset <= ((JSONRoadComponent)this.definition).road.borderOffset; offset += segmentDelta) {
                    this.dynamicCurve.setPointToRotationAt(testRotation, f);
                    testRotation.x = 0.0;
                    testRotation.z = 0.0;
                    testOffset.set(offset, 0.0, 0.0).rotateFine(testRotation).add(0.0, (float)((JSONRoadComponent)this.definition).road.collisionHeight / 16.0f, 0.0);
                    this.dynamicCurve.offsetPointByPositionAt(testOffset, f);
                    Point3d testPoint = new Point3d((int)testOffset.x, (int)Math.floor(testOffset.y), (int)testOffset.z);
                    if (testPoint.isZero() || this.collisionBlockOffsets.contains(testPoint) || this.collidingBlockOffsets.contains(testPoint)) continue;
                    testPoint.add(this.position);
                    if (this.world.isAir(testPoint)) {
                        testPoint.subtract(this.position);
                        int collisionBoxIndex = (int)((testOffset.y - testPoint.y) * 16.0);
                        this.collisionBlockOffsets.add(testPoint);
                        collisionHeightMap.put(testPoint, collisionBoxIndex);
                        continue;
                    }
                    if (this.world.getBlock(testPoint) instanceof BlockCollision) continue;
                    testPoint.subtract(this.position);
                    this.collidingBlockOffsets.add(testPoint);
                }
                f = (float)((double)f + 0.1);
            }
        } else {
            for (JSONRoadComponent.JSONRoadCollisionArea collisionArea : ((JSONRoadComponent)this.definition).road.collisionAreas) {
                System.out.println(collisionArea.firstCorner);
                for (double x = collisionArea.firstCorner.x; x <= collisionArea.secondCorner.x - 0.5; x += 0.5) {
                    for (double z = collisionArea.firstCorner.z; z <= collisionArea.secondCorner.z - 0.5; z += 0.5) {
                        Point3d testPoint = new Point3d(x, 0.0, z).rotateFine(this.angles);
                        testPoint.x = (int)testPoint.x;
                        testPoint.z = (int)testPoint.z;
                        if (testPoint.isZero() || this.collisionBlockOffsets.contains(testPoint) || this.collidingBlockOffsets.contains(testPoint)) continue;
                        testPoint.add(this.position);
                        if (this.world.isAir(testPoint)) {
                            testPoint.subtract(this.position);
                            this.collisionBlockOffsets.add(testPoint);
                            collisionHeightMap.put(testPoint, collisionArea.collisionHeight);
                            continue;
                        }
                        if (this.world.getBlock(testPoint) instanceof BlockCollision) continue;
                        testPoint.subtract(this.position);
                        this.collidingBlockOffsets.add(testPoint);
                    }
                }
            }
        }
        return collisionHeightMap;
    }

    public boolean spawnCollisionBlocks(WrapperPlayer player) {
        Map<Point3d, Integer> collisionHeightMap = this.generateCollisionPoints();
        if (this.collidingBlockOffsets.isEmpty() || player.isCreative() && player.isOP()) {
            for (Point3d offset : this.collisionBlockOffsets) {
                this.world.setBlock(BlockCollision.blockInstances.get(collisionHeightMap.get(offset)), offset.copy().add(this.position), null, ABlockBase.Axis.UP);
            }
            this.collidingBlockOffsets.clear();
            this.setActive(true);
            InterfacePacket.sendToAllClients(new PacketTileEntityRoadCollisionUpdate(this));
            return true;
        }
        this.collisionBlockOffsets.clear();
        player.sendPacket(new PacketPlayerChatMessage(player, "interact.roadcomponent.blockingblocks"));
        InterfacePacket.sendToAllClients(new PacketTileEntityRoadCollisionUpdate(this));
        return false;
    }

    public RenderRoad getRenderer() {
        if (renderer == null) {
            renderer = new RenderRoad();
        }
        return renderer;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setBoolean("isActive", this.isActive);
        for (Map.Entry<RoadComponent, ItemRoadComponent> connectedObjectEntry : this.components.entrySet()) {
            data.setString("packID" + connectedObjectEntry.getKey().name(), ((JSONRoadComponent)connectedObjectEntry.getValue().definition).packID);
            data.setString("systemName" + connectedObjectEntry.getKey().name(), ((JSONRoadComponent)connectedObjectEntry.getValue().definition).systemName);
        }
        if (this.dynamicCurve != null) {
            data.setPoint3d("startingOffset", this.dynamicCurve.startPos);
            data.setPoint3d("endingOffset", this.dynamicCurve.endPos);
            data.setDouble("startingRotation", this.dynamicCurve.startAngle);
            data.setDouble("endingRotation", this.dynamicCurve.endAngle);
        }
        for (int laneNumber = 0; laneNumber < this.lanes.size(); ++laneNumber) {
            data.setData("lane" + laneNumber, this.lanes.get(laneNumber).getData());
        }
        data.setPoint3dsCompact("collisionBlockOffsets", this.collisionBlockOffsets);
        data.setPoint3dsCompact("collidingBlockOffsets", this.collidingBlockOffsets);
        return data;
    }

    public static enum RoadComponent {
        CORE_STATIC,
        CORE_DYNAMIC;

    }
}

