/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.util.UUID;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperWorld;

public abstract class AEntityA_Base {
    public final WrapperWorld world;
    public final UUID uniqueUUID;
    public boolean isValid = true;
    public final boolean newlyCreated;
    public long ticksExisted;

    public AEntityA_Base(WrapperWorld world, WrapperNBT data) {
        this.world = world;
        boolean bl = this.newlyCreated = data == null || data.getUUID("uniqueUUID") == null;
        if (this.shouldSync() && !this.newlyCreated) {
            UUID savedUUID = data.getUUID("uniqueUUID");
            this.uniqueUUID = !world.isClient() && world.getEntity(savedUUID) != null ? UUID.randomUUID() : savedUUID;
        } else {
            this.uniqueUUID = UUID.randomUUID();
        }
    }

    public boolean update() {
        ++this.ticksExisted;
        return true;
    }

    public boolean shouldSync() {
        return true;
    }

    public void remove() {
        if (this.isValid) {
            this.isValid = false;
            this.world.removeEntity(this);
        }
    }

    public double getMass() {
        return 0.0;
    }

    public WrapperNBT save(WrapperNBT data) {
        data.setUUID("uniqueUUID", this.uniqueUUID);
        return data;
    }
}

