/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Orientation3d;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.sound.SoundInstance;

public abstract class AEntityB_Existing
extends AEntityA_Base {
    protected static final Point3d ZERO_FOR_CONSTRUCTOR = new Point3d();
    public final Point3d position;
    public final Point3d prevPosition;
    public final Point3d motion;
    public final Point3d prevMotion;
    public final Point3d angles;
    public final Point3d prevAngles;
    public final Point3d rotation;
    public final Point3d prevRotation;
    public final Orientation3d orientation;
    public final Orientation3d prevOrientation;
    public BoundingBox boundingBox;
    public double airDensity;
    public double velocity;
    public final WrapperPlayer placingPlayer;
    public final EntityRadio radio;
    public List<SoundInstance> sounds = new ArrayList<SoundInstance>();

    public AEntityB_Existing(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, data);
        this.position = data.getPoint3d("position");
        this.prevPosition = this.position.copy();
        this.motion = data.getPoint3d("motion");
        this.prevMotion = this.motion.copy();
        this.angles = data.getPoint3d("angles");
        this.prevAngles = this.angles.copy();
        this.rotation = data.getPoint3d("rotation");
        this.prevRotation = this.rotation.copy();
        this.orientation = data.getOrientation3d("orientation");
        this.prevOrientation = this.orientation.copy();
        this.placingPlayer = placingPlayer;
        this.boundingBox = new BoundingBox(new Point3d(), this.position, 0.5, 0.5, 0.5, false);
        if (this.hasRadio()) {
            this.radio = new EntityRadio(this, data.getDataOrNew("radio"));
            world.addEntity(this.radio);
        } else {
            this.radio = null;
        }
    }

    public AEntityB_Existing(WrapperWorld world, Point3d position, Point3d motion, Point3d angles) {
        super(world, null);
        this.position = position.copy();
        this.prevPosition = position.copy();
        this.motion = motion.copy();
        this.prevMotion = motion.copy();
        this.angles = angles.copy();
        this.prevAngles = angles.copy();
        this.rotation = new Point3d();
        this.prevRotation = this.rotation.copy();
        this.orientation = new Orientation3d();
        this.prevOrientation = this.orientation.copy();
        this.placingPlayer = null;
        this.boundingBox = new BoundingBox(new Point3d(), position, 0.5, 0.5, 0.5, false);
        this.radio = null;
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.world.beginProfiling("EntityB_Level", true);
            if (this.world.isClient()) {
                this.updateSounds(0.0f);
            }
            this.prevPosition.setTo(this.position);
            this.prevMotion.setTo(this.motion);
            this.prevAngles.setTo(this.angles);
            this.prevRotation.setTo(this.rotation);
            this.prevOrientation.setTo(this.orientation);
            this.airDensity = 1.225 * Math.pow(2.0, -this.position.y / (500.0 * (double)this.world.getMaxHeight() / 256.0));
            this.velocity = this.motion.length();
            this.world.endProfiling();
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        super.remove();
        if (this.world.isClient()) {
            if (this.radio != null) {
                this.radio.stop();
            }
            for (SoundInstance sound : this.sounds) {
                sound.stopSound = true;
            }
        }
    }

    public void destroy(BoundingBox box) {
        this.remove();
    }

    public boolean needsChunkloading() {
        return false;
    }

    public boolean shouldSavePosition() {
        return true;
    }

    public boolean canCollideWith(AEntityB_Existing entityToCollide) {
        return false;
    }

    public boolean interact(WrapperPlayer player) {
        return false;
    }

    public float getLightProvided() {
        return 0.0f;
    }

    public boolean shouldRenderBeams() {
        return false;
    }

    public boolean hasRadio() {
        return false;
    }

    public void updateSounds(float partialTicks) {
        if (this.radio != null && partialTicks == 0.0f) {
            this.radio.update();
        }
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        if (this.shouldSavePosition()) {
            data.setPoint3d("position", this.position);
            data.setPoint3d("motion", this.motion);
            data.setPoint3d("angles", this.angles);
            data.setPoint3d("rotation", this.rotation);
        }
        if (this.radio != null) {
            data.setData("radio", this.radio.save(new WrapperNBT()));
        }
        return data;
    }
}

