/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityParticle;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimatedObject;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONCameraObject;
import minecrafttransportsimulator.jsondefs.JSONLight;
import minecrafttransportsimulator.jsondefs.JSONParticle;
import minecrafttransportsimulator.jsondefs.JSONSound;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceSound;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.rendering.components.DurationDelayClock;
import minecrafttransportsimulator.sound.SoundInstance;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;

public abstract class AEntityD_Definable<JSONDefinition extends AJSONMultiModelProvider>
extends AEntityC_Renderable {
    public final JSONDefinition definition;
    public String subName;
    public boolean animationsInitialized;
    public final LinkedHashMap<JSONText, String> text = new LinkedHashMap();
    protected final Map<String, Double> variables = new HashMap<String, Double>();
    private final List<JSONSound> allSoundDefs = new ArrayList<JSONSound>();
    private final Map<JSONSound, List<DurationDelayClock>> soundActiveClocks = new HashMap<JSONSound, List<DurationDelayClock>>();
    private final Map<JSONSound, List<DurationDelayClock>> soundVolumeClocks = new HashMap<JSONSound, List<DurationDelayClock>>();
    private final Map<JSONSound, List<DurationDelayClock>> soundPitchClocks = new HashMap<JSONSound, List<DurationDelayClock>>();
    private final Map<JSONLight, List<DurationDelayClock>> lightBrightnessClocks = new HashMap<JSONLight, List<DurationDelayClock>>();
    private final Map<JSONParticle, List<DurationDelayClock>> particleActiveClocks = new HashMap<JSONParticle, List<DurationDelayClock>>();
    private final Map<JSONParticle, Long> lastTickParticleSpawned = new HashMap<JSONParticle, Long>();
    public final Map<JSONAnimationDefinition, DurationDelayClock> animationClocks = new HashMap<JSONAnimationDefinition, DurationDelayClock>();
    public final Map<String, JSONAnimatedObject> animatedObjectDefinitions = new HashMap<String, JSONAnimatedObject>();
    public final Map<JSONLight, Float> lightBrightnessValues = new HashMap<JSONLight, Float>();
    public final Map<JSONLight, ColorRGB> lightColorValues = new HashMap<JSONLight, ColorRGB>();
    public final Map<String, JSONLight> lightObjectDefinitions = new HashMap<String, JSONLight>();

    public AEntityD_Definable(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
        this.subName = data.getString("subName");
        AItemSubTyped item = (AItemSubTyped)PackParserSystem.getItem(data.getString("packID"), data.getString("systemName"), this.subName);
        Object object = this.definition = item != null ? (AJSONMultiModelProvider)item.definition : this.generateDefaultDefinition();
        if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.textObjects != null) {
            for (int i = 0; i < ((AJSONMultiModelProvider)this.definition).rendering.textObjects.size(); ++i) {
                JSONText textDef = ((AJSONMultiModelProvider)this.definition).rendering.textObjects.get(i);
                this.text.put(textDef, this.newlyCreated ? textDef.defaultText : data.getString("textLine" + i));
            }
        }
        for (String variableName : data.getStrings("variables")) {
            this.variables.put(variableName, data.getDouble(variableName));
        }
        if (this.newlyCreated && ((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.initialVariables != null) {
            for (String variable : ((AJSONMultiModelProvider)this.definition).rendering.initialVariables) {
                this.variables.put(variable, 1.0);
            }
        }
        if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.constants != null) {
            for (String variable : ((AJSONMultiModelProvider)this.definition).rendering.constants) {
                this.variables.put(variable, 1.0);
            }
        }
    }

    public AEntityD_Definable(WrapperWorld world, Point3d position, Point3d motion, Point3d angles, AItemSubTyped<JSONDefinition> creatingItem) {
        super(world, position, motion, angles);
        this.subName = creatingItem.subName;
        this.definition = (AJSONMultiModelProvider)creatingItem.definition;
        if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.constants != null) {
            for (String variable : ((AJSONMultiModelProvider)this.definition).rendering.constants) {
                this.variables.put(variable, 1.0);
            }
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.world.beginProfiling("EntityD_Level", true);
            if (!this.animationsInitialized) {
                this.initializeDefinition();
                this.animationsInitialized = true;
            }
            if (this.world.isClient() && !this.text.isEmpty()) {
                for (Map.Entry<JSONText, String> textEntry : this.text.entrySet()) {
                    JSONText textDef = textEntry.getKey();
                    if (textDef.variableName == null) continue;
                    textEntry.setValue(this.getAnimatedTextVariableValue(textDef, 0.0f));
                }
            }
            this.world.endProfiling();
            return true;
        }
        return false;
    }

    protected void initializeDefinition() {
        ArrayList<DurationDelayClock> activeClocks;
        this.allSoundDefs.clear();
        this.soundActiveClocks.clear();
        this.soundVolumeClocks.clear();
        this.soundPitchClocks.clear();
        if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.sounds != null) {
            for (JSONSound soundDef : ((AJSONMultiModelProvider)this.definition).rendering.sounds) {
                this.allSoundDefs.add(soundDef);
                activeClocks = new ArrayList<DurationDelayClock>();
                if (soundDef.activeAnimations != null) {
                    for (JSONAnimationDefinition jSONAnimationDefinition : soundDef.activeAnimations) {
                        activeClocks.add(new DurationDelayClock(jSONAnimationDefinition));
                    }
                }
                this.soundActiveClocks.put(soundDef, activeClocks);
                Iterator<JSONAnimationDefinition> volumeClocks = new ArrayList();
                if (soundDef.volumeAnimations != null) {
                    for (JSONAnimationDefinition animation2 : soundDef.volumeAnimations) {
                        volumeClocks.add((JSONAnimationDefinition)((Object)new DurationDelayClock(animation2)));
                    }
                }
                this.soundVolumeClocks.put(soundDef, (List<DurationDelayClock>)((Object)volumeClocks));
                ArrayList<DurationDelayClock> arrayList = new ArrayList<DurationDelayClock>();
                if (soundDef.pitchAnimations != null) {
                    for (JSONAnimationDefinition animation : soundDef.pitchAnimations) {
                        arrayList.add(new DurationDelayClock(animation));
                    }
                }
                this.soundPitchClocks.put(soundDef, arrayList);
            }
        }
        this.lightBrightnessClocks.clear();
        this.lightBrightnessValues.clear();
        this.lightColorValues.clear();
        this.lightObjectDefinitions.clear();
        if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.lightObjects != null) {
            for (JSONLight lightDef : ((AJSONMultiModelProvider)this.definition).rendering.lightObjects) {
                this.lightObjectDefinitions.put(lightDef.objectName, lightDef);
                ArrayList<DurationDelayClock> lightClocks = new ArrayList<DurationDelayClock>();
                if (lightDef.brightnessAnimations != null) {
                    for (JSONAnimationDefinition jSONAnimationDefinition : lightDef.brightnessAnimations) {
                        lightClocks.add(new DurationDelayClock(jSONAnimationDefinition));
                    }
                }
                this.lightBrightnessClocks.put(lightDef, lightClocks);
                this.lightBrightnessValues.put(lightDef, Float.valueOf(0.0f));
                this.lightColorValues.put(lightDef, new ColorRGB());
            }
        }
        this.particleActiveClocks.clear();
        if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.particles != null) {
            for (JSONParticle particleDef : ((AJSONMultiModelProvider)this.definition).rendering.particles) {
                activeClocks = new ArrayList();
                if (particleDef.activeAnimations != null) {
                    for (JSONAnimationDefinition jSONAnimationDefinition : particleDef.activeAnimations) {
                        activeClocks.add(new DurationDelayClock(jSONAnimationDefinition));
                    }
                }
                this.particleActiveClocks.put(particleDef, activeClocks);
                this.lastTickParticleSpawned.put(particleDef, this.ticksExisted);
            }
        }
        this.animationClocks.clear();
        this.animatedObjectDefinitions.clear();
        if (((AJSONMultiModelProvider)this.definition).rendering != null) {
            if (((AJSONMultiModelProvider)this.definition).rendering.animatedObjects != null) {
                for (JSONAnimatedObject animatedDef : ((AJSONMultiModelProvider)this.definition).rendering.animatedObjects) {
                    this.animatedObjectDefinitions.put(animatedDef.objectName, animatedDef);
                    if (animatedDef.animations == null) continue;
                    for (JSONAnimationDefinition animation : animatedDef.animations) {
                        this.animationClocks.put(animation, new DurationDelayClock(animation));
                    }
                }
            }
            if (((AJSONMultiModelProvider)this.definition).rendering.cameraObjects != null) {
                for (JSONCameraObject cameraDef : ((AJSONMultiModelProvider)this.definition).rendering.cameraObjects) {
                    if (cameraDef.animations == null) continue;
                    for (JSONAnimationDefinition animation : cameraDef.animations) {
                        this.animationClocks.put(animation, new DurationDelayClock(animation));
                    }
                }
            }
        }
        ArrayList<String> oldTextValues = new ArrayList<String>();
        oldTextValues.addAll(this.text.values());
        this.text.clear();
        if (((AJSONMultiModelProvider)this.definition).rendering != null && ((AJSONMultiModelProvider)this.definition).rendering.textObjects != null) {
            for (int i = 0; i < ((AJSONMultiModelProvider)this.definition).rendering.textObjects.size(); ++i) {
                if (i < oldTextValues.size()) {
                    this.text.put(((AJSONMultiModelProvider)this.definition).rendering.textObjects.get(i), (String)oldTextValues.get(i));
                    continue;
                }
                this.text.put(((AJSONMultiModelProvider)this.definition).rendering.textObjects.get(i), ((AJSONMultiModelProvider)this.definition).rendering.textObjects.get((int)i).defaultText);
            }
        }
    }

    public <ItemInstance extends AItemPack<JSONDefinition>> ItemInstance getItem() {
        return (ItemInstance)PackParserSystem.getItem(((AJSONMultiModelProvider)this.definition).packID, ((AJSONMultiModelProvider)this.definition).systemName, this.subName);
    }

    public void addDropsToList(List<WrapperItemStack> drops) {
        Object packItem = this.getItem();
        if (packItem != null) {
            drops.add(((AItemBase)packItem).getNewStack(this.save(new WrapperNBT())));
        }
    }

    public JSONDefinition generateDefaultDefinition() {
        throw new IllegalArgumentException("Was asked to auto-generate a definition on an entity with one not defined.  This is NOT allowed.  The entity must be missing its item.  Perhaps a pack was removed with this entity still in the world?");
    }

    public String getTexture() {
        return ((AJSONMultiModelProvider)this.definition).getTextureLocation(this.subName);
    }

    public boolean renderTextLit() {
        return (Boolean)ConfigSystem.configObject.clientRendering.brightLights.value;
    }

    public ColorRGB getTextColor(int index, ColorRGB defaultColor) {
        if (index != 0) {
            for (JSONSubDefinition subDefinition : ((AJSONMultiModelProvider)this.definition).definitions) {
                if (!subDefinition.subName.equals(this.subName)) continue;
                if (subDefinition.secondaryTextColors != null && subDefinition.secondaryTextColors.size() >= index) {
                    return subDefinition.secondaryTextColors.get(index - 1);
                }
                return defaultColor;
            }
            throw new IllegalArgumentException("Tried to get the definition for an object of subName:" + this.subName + ".  But that isn't a valid subName for the object:" + ((AJSONMultiModelProvider)this.definition).packID + ":" + ((AJSONMultiModelProvider)this.definition).systemName + ".  Report this to the pack author as this is a missing JSON component!");
        }
        return defaultColor;
    }

    public void updateText(List<String> textLines) {
        int linesChecked = 0;
        for (Map.Entry<JSONText, String> textEntry : this.text.entrySet()) {
            textEntry.setValue(textLines.get(linesChecked++));
        }
    }

    public void spawnParticles(float partialTicks) {
        for (Map.Entry<JSONParticle, List<DurationDelayClock>> particleEntry : this.particleActiveClocks.entrySet()) {
            JSONParticle particleDef = particleEntry.getKey();
            boolean shouldParticleSpawn = true;
            boolean anyClockMovedThisUpdate = false;
            if (particleDef.activeAnimations != null) {
                boolean inhibitAnimations = false;
                for (DurationDelayClock clock : particleEntry.getValue()) {
                    switch (clock.animation.animationType) {
                        case VISIBILITY: {
                            if (inhibitAnimations) break;
                            double variableValue = this.getAnimatedVariableValue(clock, partialTicks);
                            if (!anyClockMovedThisUpdate) {
                                anyClockMovedThisUpdate = clock.movedThisUpdate;
                            }
                            if (!(variableValue < (double)clock.animation.clampMin) && !(variableValue > (double)clock.animation.clampMax)) break;
                            shouldParticleSpawn = false;
                            break;
                        }
                        case INHIBITOR: {
                            double variableValue;
                            if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, partialTicks)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                            inhibitAnimations = true;
                            break;
                        }
                        case ACTIVATOR: {
                            double variableValue;
                            if (!inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, partialTicks)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                            inhibitAnimations = false;
                            break;
                        }
                        case TRANSLATION: {
                            break;
                        }
                        case ROTATION: {
                            break;
                        }
                    }
                    if (shouldParticleSpawn) continue;
                    break;
                }
            }
            if (!shouldParticleSpawn || !anyClockMovedThisUpdate && (!particleDef.spawnEveryTick || this.ticksExisted <= this.lastTickParticleSpawned.get(particleDef))) continue;
            this.lastTickParticleSpawned.put(particleDef, this.ticksExisted);
            if (particleDef.quantity > 0) {
                for (int i = 0; i < particleDef.quantity; ++i) {
                    this.world.addEntity(new EntityParticle(this, particleDef));
                }
                continue;
            }
            this.world.addEntity(new EntityParticle(this, particleDef));
        }
    }

    public void updateLightBrightness(float partialTicks) {
        for (JSONLight lightDef : this.lightBrightnessClocks.keySet()) {
            boolean definedBrightness = false;
            float lightLevel = 0.0f;
            boolean inhibitAnimations = false;
            boolean inhibitLight = false;
            ColorRGB customColor = null;
            for (DurationDelayClock clock : this.lightBrightnessClocks.get(lightDef)) {
                switch (clock.animation.animationType) {
                    case VISIBILITY: {
                        double variableValue;
                        if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, partialTicks)) < (double)clock.animation.clampMin) && !(variableValue > (double)clock.animation.clampMax)) break;
                        inhibitLight = true;
                        break;
                    }
                    case INHIBITOR: {
                        double variableValue;
                        if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, partialTicks)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                        inhibitAnimations = true;
                        break;
                    }
                    case ACTIVATOR: {
                        double variableValue;
                        if (!inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, partialTicks)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                        inhibitAnimations = false;
                        break;
                    }
                    case TRANSLATION: {
                        if (inhibitAnimations) break;
                        definedBrightness = true;
                        if (clock.animation.axis.x != 0.0) {
                            lightLevel = (float)((double)lightLevel * this.getAnimatedVariableValue(clock, clock.animation.axis.x, partialTicks));
                            break;
                        }
                        if (clock.animation.axis.y != 0.0) {
                            lightLevel = (float)((double)lightLevel + this.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks));
                            break;
                        }
                        lightLevel = (float)this.getAnimatedVariableValue(clock, clock.animation.axis.z, partialTicks);
                        break;
                    }
                    case ROTATION: {
                        if (inhibitAnimations) break;
                        double colorFactor = this.getAnimatedVariableValue(clock, 1.0, -clock.animation.offset, partialTicks);
                        if (customColor == null) {
                            customColor = new ColorRGB((float)Math.min(clock.animation.axis.x * colorFactor + (double)clock.animation.offset, 1.0), (float)Math.min(clock.animation.axis.y * colorFactor + (double)clock.animation.offset, 1.0), (float)Math.min(clock.animation.axis.z * colorFactor + (double)clock.animation.offset, 1.0), false);
                            break;
                        }
                        customColor = new ColorRGB((float)Math.min(clock.animation.axis.x * colorFactor + (double)clock.animation.offset + (double)customColor.red, 1.0), (float)Math.min(clock.animation.axis.y * colorFactor + (double)clock.animation.offset + (double)customColor.green, 1.0), (float)Math.min(clock.animation.axis.z * colorFactor + (double)clock.animation.offset + (double)customColor.blue, 1.0), false);
                        break;
                    }
                }
                if (!inhibitLight) continue;
                break;
            }
            if (inhibitLight || lightLevel < 0.0f) {
                lightLevel = 0.0f;
            } else if (!definedBrightness || lightLevel > 1.0f) {
                lightLevel = 1.0f;
            }
            this.lightBrightnessValues.put(lightDef, Float.valueOf(lightLevel));
            ColorRGB lightColor = this.lightColorValues.get(lightDef);
            if (customColor != null) {
                lightColor.setTo(customColor);
            } else if (lightDef.color != null) {
                lightColor.setTo(lightDef.color);
            } else {
                lightColor.setTo(ColorRGB.WHITE);
            }
            this.lightColorValues.put(lightDef, lightColor);
        }
    }

    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "tick": {
                return (float)this.ticksExisted + partialTicks;
            }
            case "tick_sin": {
                return Math.sin(Math.toRadians((float)this.ticksExisted + partialTicks));
            }
            case "tick_cos": {
                return Math.cos(Math.toRadians((float)this.ticksExisted + partialTicks));
            }
            case "time": {
                return this.world.getTime();
            }
            case "rain_strength": {
                return (int)this.world.getRainStrength(this.position);
            }
            case "rain_sin": {
                int rainStrength = (int)this.world.getRainStrength(this.position);
                return rainStrength > 0 ? Math.sin((double)rainStrength * Math.toRadians(360.0f * ((float)this.ticksExisted + partialTicks) / 20.0f)) / 2.0 + 0.5 : 0.0;
            }
            case "rain_cos": {
                int rainStrength = (int)this.world.getRainStrength(this.position);
                return rainStrength > 0 ? Math.cos((double)rainStrength * Math.toRadians(360.0f * ((float)this.ticksExisted + partialTicks) / 20.0f)) / 2.0 + 0.5 : 0.0;
            }
            case "light_sunlight": {
                return this.world.getLightBrightness(this.position, false);
            }
            case "light_total": {
                return this.world.getLightBrightness(this.position, true);
            }
            case "ground_distance": {
                return this.world.getHeight(this.position);
            }
        }
        if (variable.endsWith("_cycle")) {
            int onTime;
            String[] parsedVariable = variable.split("_");
            int offTime = Integer.valueOf(parsedVariable[0]);
            int totalTime = offTime + (onTime = Integer.valueOf(parsedVariable[1]).intValue()) + Integer.valueOf(parsedVariable[2]);
            long timeInCycle = this.ticksExisted % (long)totalTime;
            return timeInCycle > (long)offTime && timeInCycle - (long)offTime < (long)onTime ? 1.0 : 0.0;
        }
        Double variableValue = this.variables.get(variable);
        if (variableValue != null) {
            return variableValue;
        }
        return Double.NaN;
    }

    public String getRawTextVariableValue(JSONText textDef, float partialTicks) {
        return null;
    }

    public final double getAnimatedVariableValue(DurationDelayClock clock, double scaleFactor, double offset, float partialTicks) {
        double value;
        if (clock.animation.variable.startsWith("!")) {
            value = this.getRawVariableValue(clock.animation.variable.substring(1), partialTicks);
            value = value == 0.0 || Double.isNaN(value) ? 1.0 : 0.0;
        } else {
            value = this.getRawVariableValue(clock.animation.variable, partialTicks);
            if (Double.isNaN(value)) {
                value = 0.0;
            }
        }
        if (!clock.isUseful) {
            return AEntityD_Definable.clampAndScale(value, clock.animation, scaleFactor, offset);
        }
        return AEntityD_Definable.clampAndScale(clock.getFactoredState(this, value, partialTicks), clock.animation, scaleFactor, offset);
    }

    public final double getAnimatedVariableValue(DurationDelayClock clock, double scaleFactor, float partialTicks) {
        return this.getAnimatedVariableValue(clock, scaleFactor, 0.0, partialTicks);
    }

    public final double getAnimatedVariableValue(DurationDelayClock clock, float partialTicks) {
        return this.getAnimatedVariableValue(clock, 1.0, 0.0, partialTicks);
    }

    private static double clampAndScale(double value, JSONAnimationDefinition animation, double scaleFactor, double offset) {
        if (animation.axis != null) {
            value = (animation.absolute ? Math.abs(value) : value) * scaleFactor + (double)animation.offset + offset;
            if (animation.clampMin != 0.0f && value < (double)animation.clampMin) {
                value = animation.clampMin;
            } else if (animation.clampMax != 0.0f && value > (double)animation.clampMax) {
                value = animation.clampMax;
            }
            return value;
        }
        return (animation.absolute ? Math.abs(value) : value) * scaleFactor + (double)animation.offset;
    }

    public final String getAnimatedTextVariableValue(JSONText textDef, float partialTicks) {
        String value = this.getRawTextVariableValue(textDef, 0.0f);
        if (value == null) {
            double numberValue = this.getRawVariableValue(textDef.variableName, 0.0f);
            if (Double.isNaN(numberValue)) {
                numberValue = 0.0;
            }
            return String.format(textDef.variableFormat, numberValue * (double)textDef.variableFactor);
        }
        return String.format(textDef.variableFormat, value);
    }

    public static int getVariableNumber(String variable) {
        if (variable.matches("^.*_[0-9]+$")) {
            return Integer.parseInt(variable.substring(variable.lastIndexOf(95) + 1)) - 1;
        }
        return -1;
    }

    public void toggleVariable(String variable) {
        if (this.variables.remove(variable) == null) {
            this.variables.put(variable, 1.0);
        }
    }

    public void setVariable(String variable, double value) {
        if (value == 0.0) {
            this.variables.remove(variable);
        } else {
            this.variables.put(variable, value);
        }
    }

    public double getVariable(String variable) {
        Double value = this.variables.get(variable);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public boolean isVariableActive(String variable) {
        return this.variables.containsKey(variable);
    }

    @Override
    public void updateSounds(float partialTicks) {
        super.updateSounds(partialTicks);
        block21: for (JSONSound soundDef : this.allSoundDefs) {
            boolean playerRidingEntity;
            if (!(soundDef.canPlayOnPartialTicks ^ partialTicks == 0.0f)) continue;
            AEntityE_Interactable<?> entityRiding = InterfaceClient.getClientPlayer().getEntityRiding();
            boolean bl = playerRidingEntity = this.equals(entityRiding) || this instanceof APart && ((APart)this).entityOn.equals(entityRiding);
            boolean shouldSoundPlay = playerRidingEntity && InterfaceClient.inFirstPerson() && !CameraSystem.runningCustomCameras ? !soundDef.isExterior : !soundDef.isInterior;
            boolean anyClockMovedThisUpdate = false;
            boolean inhibitAnimations = false;
            if (shouldSoundPlay) {
                for (DurationDelayClock durationDelayClock : this.soundActiveClocks.get(soundDef)) {
                    switch (durationDelayClock.animation.animationType) {
                        case VISIBILITY: {
                            if (inhibitAnimations) break;
                            double variableValue = this.getAnimatedVariableValue(durationDelayClock, partialTicks);
                            if (!anyClockMovedThisUpdate) {
                                anyClockMovedThisUpdate = durationDelayClock.movedThisUpdate;
                            }
                            if (!(variableValue < (double)durationDelayClock.animation.clampMin) && !(variableValue > (double)durationDelayClock.animation.clampMax)) break;
                            shouldSoundPlay = false;
                            break;
                        }
                        case INHIBITOR: {
                            double variableValue;
                            if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(durationDelayClock, partialTicks)) >= (double)durationDelayClock.animation.clampMin) || !(variableValue <= (double)durationDelayClock.animation.clampMax)) break;
                            inhibitAnimations = true;
                            break;
                        }
                        case ACTIVATOR: {
                            double variableValue;
                            if (!inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(durationDelayClock, partialTicks)) >= (double)durationDelayClock.animation.clampMin) || !(variableValue <= (double)durationDelayClock.animation.clampMax)) break;
                            inhibitAnimations = false;
                            break;
                        }
                        case TRANSLATION: {
                            break;
                        }
                        case ROTATION: {
                            break;
                        }
                    }
                    if (shouldSoundPlay) continue;
                    break;
                }
            }
            if (!(soundDef.looping || soundDef.forceSound || anyClockMovedThisUpdate)) {
                shouldSoundPlay = false;
            }
            if (shouldSoundPlay) {
                boolean isSoundPlaying = false;
                if (!soundDef.forceSound) {
                    for (SoundInstance sound : this.sounds) {
                        if (!sound.soundName.equals(soundDef.name)) continue;
                        isSoundPlaying = true;
                        break;
                    }
                }
                if (!isSoundPlaying) {
                    InterfaceSound.playQuickSound(new SoundInstance((AEntityB_Existing)this, soundDef));
                }
            } else {
                if (!soundDef.looping) continue;
                for (SoundInstance soundInstance : this.sounds) {
                    if (!soundInstance.soundName.equals(soundDef.name)) continue;
                    soundInstance.stopSound = true;
                    continue block21;
                }
                continue;
            }
            for (SoundInstance soundInstance : this.sounds) {
                if (!soundInstance.soundName.equals(soundDef.name) || soundInstance == null) continue;
                boolean definedVolume = false;
                inhibitAnimations = false;
                soundInstance.volume = 0.0f;
                block26: for (DurationDelayClock clock : this.soundVolumeClocks.get(soundDef)) {
                    switch (clock.animation.animationType) {
                        case TRANSLATION: {
                            if (inhibitAnimations) break;
                            definedVolume = true;
                            soundInstance.volume = (float)((double)soundInstance.volume + this.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks));
                            break;
                        }
                        case ROTATION: {
                            if (inhibitAnimations) break;
                            definedVolume = true;
                            double parabolaValue = this.getAnimatedVariableValue(clock, clock.animation.axis.y, -clock.animation.offset, partialTicks);
                            soundInstance.volume = (float)((double)soundInstance.volume + (clock.animation.axis.x * Math.pow(parabolaValue - clock.animation.axis.z, 2.0) + (double)clock.animation.offset));
                            break;
                        }
                        case INHIBITOR: {
                            if (inhibitAnimations) break;
                            double variableValue = this.getAnimatedVariableValue(clock, partialTicks);
                            if (!(variableValue >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) continue block26;
                            inhibitAnimations = true;
                            break;
                        }
                        case ACTIVATOR: {
                            if (!inhibitAnimations) break;
                            double variableValue = this.getAnimatedVariableValue(clock, partialTicks);
                            if (!(variableValue >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) continue block26;
                            inhibitAnimations = false;
                            break;
                        }
                        case SCALING: {
                            break;
                        }
                    }
                }
                if (!definedVolume) {
                    soundInstance.volume = 1.0f;
                } else if (soundInstance.volume < 0.0f) {
                    soundInstance.volume = 0.0f;
                }
                if (!playerRidingEntity && soundInstance.radio == null && entityRiding instanceof EntityVehicleF_Physics && !((JSONVehicle)((EntityVehicleF_Physics)entityRiding).definition).motorized.hasOpenTop && InterfaceClient.inFirstPerson() && !CameraSystem.runningCustomCameras) {
                    soundInstance.volume *= 0.5f;
                }
                boolean definedPitch = false;
                inhibitAnimations = false;
                soundInstance.pitch = 0.0f;
                block27: for (DurationDelayClock clock : this.soundPitchClocks.get(soundDef)) {
                    switch (clock.animation.animationType) {
                        case TRANSLATION: {
                            if (inhibitAnimations) break;
                            definedPitch = true;
                            soundInstance.pitch = (float)((double)soundInstance.pitch + this.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks));
                            break;
                        }
                        case ROTATION: {
                            if (inhibitAnimations) break;
                            definedPitch = true;
                            double parabolaValue = this.getAnimatedVariableValue(clock, clock.animation.axis.y, -clock.animation.offset, partialTicks);
                            soundInstance.pitch = (float)((double)soundInstance.pitch + (clock.animation.axis.x * Math.pow(parabolaValue - clock.animation.axis.z, 2.0) + (double)clock.animation.offset));
                            break;
                        }
                        case INHIBITOR: {
                            if (inhibitAnimations) break;
                            double variableValue = this.getAnimatedVariableValue(clock, partialTicks);
                            if (!(variableValue >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) continue block27;
                            inhibitAnimations = true;
                            break;
                        }
                        case ACTIVATOR: {
                            if (!inhibitAnimations) break;
                            double variableValue = this.getAnimatedVariableValue(clock, partialTicks);
                            if (!(variableValue >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) continue block27;
                            inhibitAnimations = false;
                            break;
                        }
                        case SCALING: {
                            break;
                        }
                    }
                }
                if (!definedPitch) {
                    soundInstance.pitch = 1.0f;
                    continue;
                }
                if (!(soundInstance.pitch < 0.0f)) continue;
                soundInstance.pitch = 0.0f;
            }
        }
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setString("packID", ((AJSONMultiModelProvider)this.definition).packID);
        data.setString("systemName", ((AJSONMultiModelProvider)this.definition).systemName);
        data.setString("subName", this.subName);
        int lineNumber = 0;
        for (String textLine : this.text.values()) {
            data.setString("textLine" + lineNumber++, textLine);
        }
        data.setStrings("variables", this.variables.keySet());
        for (String variableName : this.variables.keySet()) {
            data.setDouble(variableName, this.variables.get(variableName));
        }
        return data;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD})
    public static @interface ModifiedValue {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD})
    public static @interface ModifiableValue {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD})
    public static @interface DerivedValue {
    }
}

