/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.TrailerConnection;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGeneric;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONConnection;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityRiderChange;
import minecrafttransportsimulator.packets.instances.PacketEntityTrailerChange;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.rendering.components.DurationDelayClock;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;

public abstract class AEntityE_Interactable<JSONDefinition extends AJSONInteractableEntity>
extends AEntityD_Definable<JSONDefinition> {
    public final Map<JSONCollisionGroup, Set<BoundingBox>> definitionCollisionBoxes;
    private final Map<JSONCollisionGroup, List<DurationDelayClock>> collisionClocks;
    public final Set<BoundingBox> blockCollisionBoxes;
    public final Set<BoundingBox> entityCollisionBoxes;
    public final Set<BoundingBox> interactionBoxes;
    public final BoundingBox encompassingBox;
    public final Set<AEntityE_Interactable<?>> collidedEntities;
    public final Set<Point3d> ridableLocations;
    public final List<Point3d> savedRiderLocations;
    public final BiMap<Point3d, WrapperEntity> locationRiderMap;
    public final Map<Integer, ItemInstrument> instruments;
    public boolean locked;
    public final UUID ownerUUID;
    public double damageAmount;
    public static final String DAMAGE_VARIABLE = "damage";
    protected boolean overrideTowingChecks;
    public TrailerConnection towedByConnection;
    protected final Set<TrailerConnection> towingConnections;
    private TrailerConnection savedTowedByConnection;
    private final Set<TrailerConnection> savedTowingConnections;
    public static final String TRAILER_CONNECTION_REQUEST_VARIABLE = "connection_requested";
    private final Point3d collisionGroupAnimationResult;
    private final Point3d collisionGroupWorkingAngles;
    private final Point3d collisionGroupWorkingAngleOffset;

    public AEntityE_Interactable(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        block10: {
            int i;
            super(world, placingPlayer, data);
            this.definitionCollisionBoxes = new HashMap<JSONCollisionGroup, Set<BoundingBox>>();
            this.collisionClocks = new HashMap<JSONCollisionGroup, List<DurationDelayClock>>();
            this.blockCollisionBoxes = new HashSet<BoundingBox>();
            this.entityCollisionBoxes = new HashSet<BoundingBox>();
            this.interactionBoxes = new HashSet<BoundingBox>();
            this.encompassingBox = new BoundingBox(new Point3d(), new Point3d(), 0.0, 0.0, 0.0, false);
            this.collidedEntities = new HashSet();
            this.ridableLocations = new HashSet<Point3d>();
            this.savedRiderLocations = new ArrayList<Point3d>();
            this.locationRiderMap = HashBiMap.create();
            this.instruments = new HashMap<Integer, ItemInstrument>();
            this.towingConnections = new HashSet<TrailerConnection>();
            this.savedTowingConnections = new HashSet<TrailerConnection>();
            this.collisionGroupAnimationResult = new Point3d();
            this.collisionGroupWorkingAngles = new Point3d();
            this.collisionGroupWorkingAngleOffset = new Point3d();
            this.savedRiderLocations.addAll(data.getPoint3ds("savedRiderLocations"));
            this.locked = data.getBoolean("locked");
            this.ownerUUID = placingPlayer != null ? placingPlayer.getID() : data.getUUID("ownerUUID");
            WrapperNBT towData = data.getData("towedByConnection");
            if (towData != null) {
                this.savedTowedByConnection = new TrailerConnection(towData);
            }
            int towingConnectionCount = data.getInteger("towingConnectionCount");
            for (i = 0; i < towingConnectionCount; ++i) {
                towData = data.getData("towingConnection" + i);
                if (towData == null) continue;
                this.savedTowingConnections.add(new TrailerConnection(towData));
            }
            if (((AJSONInteractableEntity)this.definition).instruments == null) break block10;
            if (this.newlyCreated) {
                for (JSONInstrumentDefinition packInstrument : ((AJSONInteractableEntity)this.definition).instruments) {
                    if (packInstrument.defaultInstrument == null) continue;
                    try {
                        String instrumentPackID = packInstrument.defaultInstrument.substring(0, packInstrument.defaultInstrument.indexOf(58));
                        String instrumentSystemName = packInstrument.defaultInstrument.substring(packInstrument.defaultInstrument.indexOf(58) + 1);
                        try {
                            ItemInstrument instrument = (ItemInstrument)PackParserSystem.getItem(instrumentPackID, instrumentSystemName);
                            if (instrument == null) continue;
                            this.instruments.put(((AJSONInteractableEntity)this.definition).instruments.indexOf(packInstrument), instrument);
                        }
                        catch (NullPointerException e) {
                            this.remove();
                            throw new IllegalArgumentException("Attempted to add defaultInstrument: " + instrumentPackID + ":" + instrumentSystemName + " to: " + ((AJSONInteractableEntity)this.definition).packID + ":" + ((AJSONInteractableEntity)this.definition).systemName + " but that instrument doesn't exist in the pack item registry.");
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.remove();
                        throw new IllegalArgumentException("Could not parse defaultInstrument definition: " + packInstrument.defaultInstrument + ".  Format should be \"packId:instrumentName\"");
                    }
                }
            } else {
                for (i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                    ItemInstrument instrument;
                    String instrumentPackID = data.getString("instrument" + i + "_packID");
                    String instrumentSystemName = data.getString("instrument" + i + "_systemName");
                    if (instrumentPackID.isEmpty() || (instrument = (ItemInstrument)PackParserSystem.getItem(instrumentPackID, instrumentSystemName)) == null) continue;
                    this.instruments.put(i, instrument);
                }
            }
        }
    }

    @Override
    protected void initializeDefinition() {
        super.initializeDefinition();
        this.definitionCollisionBoxes.clear();
        this.collisionClocks.clear();
        if (((AJSONInteractableEntity)this.definition).collisionGroups != null) {
            for (JSONCollisionGroup groupDef : ((AJSONInteractableEntity)this.definition).collisionGroups) {
                HashSet<BoundingBox> boxes = new HashSet<BoundingBox>();
                for (JSONCollisionBox boxDef : groupDef.collisions) {
                    boxes.add(new BoundingBox(boxDef, groupDef));
                }
                this.definitionCollisionBoxes.put(groupDef, boxes);
                if (groupDef.animations == null) continue;
                ArrayList<DurationDelayClock> animations = new ArrayList<DurationDelayClock>();
                for (JSONAnimationDefinition animation : groupDef.animations) {
                    animations.add(new DurationDelayClock(animation));
                }
                this.collisionClocks.put(groupDef, animations);
            }
        }
        this.updateCollisionBoxes();
        if (((AJSONInteractableEntity)this.definition).instruments != null) {
            for (int i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                JSONInstrumentDefinition packInstrument = ((AJSONInteractableEntity)this.definition).instruments.get(i);
                if (packInstrument.animations == null) continue;
                for (JSONAnimationDefinition animation : packInstrument.animations) {
                    this.animationClocks.put(animation, new DurationDelayClock(animation));
                }
            }
        }
        if (((AJSONInteractableEntity)this.definition).variableModifiers != null) {
            for (JSONVariableModifier modifier : ((AJSONInteractableEntity)this.definition).variableModifiers) {
                if (modifier.animations == null) continue;
                for (JSONAnimationDefinition animation : modifier.animations) {
                    this.animationClocks.put(animation, new DurationDelayClock(animation));
                }
            }
        }
    }

    @Override
    public boolean update() {
        this.updateVariableModifiers();
        if (this.towedByConnection != null && !this.towedByConnection.hitchEntity.isValid) {
            this.towedByConnection = null;
        }
        if (!this.towingConnections.isEmpty()) {
            this.towingConnections.removeIf(connection -> !connection.hookupEntity.isValid);
        }
        if ((this.towedByConnection == null || this.overrideTowingChecks) && super.update()) {
            int connectionRequestIndex;
            this.world.beginProfiling("EntityE_Level", true);
            this.damageAmount = this.getVariable(DAMAGE_VARIABLE);
            if (this.savedTowedByConnection != null && this.ticksExisted % 20L == 0L) {
                if (this.ticksExisted <= 100L) {
                    try {
                        if (this.savedTowedByConnection.setConnection(this.world)) {
                            this.towedByConnection = this.savedTowedByConnection;
                            this.savedTowedByConnection = null;
                        }
                    }
                    catch (Exception e) {
                        this.savedTowedByConnection = null;
                        InterfaceCore.logError("Could not hook-up trailer to entity towing it.  Did the JSON or pack change?");
                    }
                } else {
                    this.savedTowedByConnection = null;
                    InterfaceCore.logError("Could not hook-up trailer to entity towing it.  Did the JSON or pack change?");
                }
            }
            if (!this.savedTowingConnections.isEmpty() && this.ticksExisted % 20L == 0L) {
                if (this.ticksExisted <= 100L) {
                    Iterator<TrailerConnection> iterator = this.savedTowingConnections.iterator();
                    while (iterator.hasNext()) {
                        TrailerConnection savedTowingConnection = iterator.next();
                        try {
                            if (!savedTowingConnection.setConnection(this.world)) continue;
                            this.towingConnections.add(savedTowingConnection);
                            iterator.remove();
                        }
                        catch (Exception e) {
                            iterator.remove();
                            InterfaceCore.logError("Could not connect trailer(s) to the entity towing them.  Did the JSON or pack change?");
                        }
                    }
                } else {
                    this.savedTowingConnections.clear();
                    InterfaceCore.logError("Could not connect trailer(s) to the entity towing them.  Did the JSON or pack change?");
                }
            }
            if ((connectionRequestIndex = (int)this.getVariable(TRAILER_CONNECTION_REQUEST_VARIABLE)) != 0) {
                if (!this.world.isClient()) {
                    this.handleConnectionRequest(connectionRequestIndex - 1);
                }
                this.setVariable(TRAILER_CONNECTION_REQUEST_VARIABLE, 0.0);
            }
            this.world.endProfiling();
            return true;
        }
        return false;
    }

    @Override
    public double getMass() {
        return 100 * this.locationRiderMap.values().size();
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        if (variable.startsWith("connection")) {
            TrailerConnection foundConnection = null;
            String[] variableData = variable.split("_");
            if (variableData.length == 4) {
                boolean isHookup = false;
                int groupIndex = Integer.valueOf(variableData[1]) - 1;
                int connectionIndex = Integer.valueOf(variableData[2]) - 1;
                if (this.towedByConnection != null && this.towedByConnection.hookupGroupIndex == groupIndex && this.towedByConnection.hookupConnectionIndex == connectionIndex) {
                    isHookup = true;
                    foundConnection = this.towedByConnection;
                }
                if (foundConnection == null && !this.towingConnections.isEmpty()) {
                    for (TrailerConnection towingConnection : this.towingConnections) {
                        if (towingConnection.hookupGroupIndex != groupIndex || towingConnection.hookupConnectionIndex != connectionIndex) continue;
                        foundConnection = towingConnection;
                        break;
                    }
                }
                if (foundConnection != null) {
                    switch (variableData[3]) {
                        case "connected": {
                            return 1.0;
                        }
                        case "pitch": {
                            return isHookup ? foundConnection.hookupEntity.angles.x - this.angles.x : foundConnection.hitchEntity.angles.x - this.angles.x;
                        }
                        case "yaw": {
                            return isHookup ? foundConnection.hookupEntity.angles.y - this.angles.y : foundConnection.hitchEntity.angles.y - this.angles.y;
                        }
                        case "roll": {
                            return isHookup ? foundConnection.hookupEntity.angles.z - this.angles.z : foundConnection.hitchEntity.angles.z - this.angles.z;
                        }
                    }
                }
            }
        } else {
            switch (variable) {
                case "damage": {
                    return this.damageAmount;
                }
                case "damage_percent": {
                    return this.damageAmount / (double)((AJSONInteractableEntity)this.definition).general.health;
                }
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    protected void updateCollisionBoxes() {
        this.blockCollisionBoxes.clear();
        this.entityCollisionBoxes.clear();
        this.interactionBoxes.clear();
        if (((AJSONInteractableEntity)this.definition).collisionGroups != null) {
            for (JSONCollisionGroup groupDef : ((AJSONInteractableEntity)this.definition).collisionGroups) {
                Set<BoundingBox> collisionBoxes = this.definitionCollisionBoxes.get(groupDef);
                if (collisionBoxes == null) {
                    this.animationsInitialized = false;
                    return;
                }
                if (groupDef.health != 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(this.getVariable(stringBuilder.append("collision_").append(((AJSONInteractableEntity)this.definition).collisionGroups.indexOf(groupDef) + 1).append("_damage").toString()) < (double)groupDef.health)) continue;
                }
                if (groupDef.animations != null) {
                    boolean inhibitAnimations = false;
                    boolean inhibitCollision = false;
                    this.collisionGroupWorkingAngles.set(0.0, 0.0, 0.0);
                    for (BoundingBox box : collisionBoxes) {
                        box.globalCenter.setTo(box.localCenter);
                    }
                    for (DurationDelayClock clock : this.collisionClocks.get(groupDef)) {
                        switch (clock.animation.animationType) {
                            case VISIBILITY: {
                                double variableValue;
                                if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) < (double)clock.animation.clampMin) && !(variableValue > (double)clock.animation.clampMax)) break;
                                inhibitCollision = true;
                                break;
                            }
                            case INHIBITOR: {
                                double variableValue;
                                if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                                inhibitAnimations = true;
                                break;
                            }
                            case ACTIVATOR: {
                                double variableValue;
                                if (!inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                                inhibitAnimations = false;
                                break;
                            }
                            case TRANSLATION: {
                                if (inhibitAnimations) break;
                                double variableValue = this.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, 0.0f);
                                this.collisionGroupAnimationResult.setTo(clock.animationAxisNormalized).multiply(variableValue).rotateFine(this.collisionGroupWorkingAngles);
                                for (BoundingBox box : collisionBoxes) {
                                    box.globalCenter.add(this.collisionGroupAnimationResult);
                                }
                                break;
                            }
                            case ROTATION: {
                                if (inhibitAnimations) break;
                                double variableValue = this.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, 0.0f);
                                this.collisionGroupAnimationResult.setTo(clock.animationAxisNormalized).multiply(variableValue);
                                for (BoundingBox box : collisionBoxes) {
                                    this.collisionGroupWorkingAngleOffset.setTo(box.globalCenter).subtract(box.localCenter);
                                    box.globalCenter.subtract(clock.animation.centerPoint).subtract(this.collisionGroupWorkingAngleOffset).rotateFine(this.collisionGroupAnimationResult).add(clock.animation.centerPoint).add(this.collisionGroupWorkingAngleOffset);
                                }
                                this.collisionGroupWorkingAngles.add(this.collisionGroupAnimationResult);
                                break;
                            }
                        }
                        if (!inhibitCollision) continue;
                        break;
                    }
                    if (inhibitCollision) continue;
                    for (BoundingBox box : collisionBoxes) {
                        this.collisionGroupAnimationResult.setTo(box.globalCenter).subtract(box.localCenter);
                        box.updateToEntity(this, this.collisionGroupAnimationResult);
                    }
                } else {
                    for (BoundingBox box : collisionBoxes) {
                        box.updateToEntity(this, null);
                    }
                }
                this.entityCollisionBoxes.addAll(collisionBoxes);
                if (groupDef.isInterior || ((Boolean)ConfigSystem.configObject.general.noclipVehicles.value).booleanValue()) continue;
                this.blockCollisionBoxes.addAll(collisionBoxes);
            }
        }
        this.interactionBoxes.addAll(this.entityCollisionBoxes);
        this.encompassingBox.widthRadius = 0.0;
        this.encompassingBox.heightRadius = 0.0;
        this.encompassingBox.depthRadius = 0.0;
        for (BoundingBox box : this.interactionBoxes) {
            this.encompassingBox.widthRadius = (float)Math.max(this.encompassingBox.widthRadius, Math.abs(box.globalCenter.x - this.position.x + box.widthRadius));
            this.encompassingBox.heightRadius = (float)Math.max(this.encompassingBox.heightRadius, Math.abs(box.globalCenter.y - this.position.y + box.heightRadius));
            this.encompassingBox.depthRadius = (float)Math.max(this.encompassingBox.depthRadius, Math.abs(box.globalCenter.z - this.position.z + box.depthRadius));
        }
        this.encompassingBox.updateToEntity(this, null);
    }

    protected void updateVariableModifiers() {
        if (((AJSONInteractableEntity)this.definition).variableModifiers != null) {
            for (JSONVariableModifier modifier : ((AJSONInteractableEntity)this.definition).variableModifiers) {
                this.setVariable(modifier.variable, this.adjustVariable(modifier, (float)this.getVariable(modifier.variable)));
            }
        }
    }

    protected float adjustVariable(JSONVariableModifier modifier, float currentValue) {
        float modifiedValue = modifier.setValue != 0.0f ? modifier.setValue : currentValue + modifier.addValue;
        boolean doModification = true;
        if (modifier.animations != null) {
            boolean inhibitAnimations = false;
            for (JSONAnimationDefinition animation : modifier.animations) {
                DurationDelayClock clock = (DurationDelayClock)this.animationClocks.get(animation);
                if (clock == null) continue;
                switch (animation.animationType) {
                    case VISIBILITY: {
                        double variableValue;
                        if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) < (double)clock.animation.clampMin) && !(variableValue > (double)clock.animation.clampMax)) break;
                        doModification = false;
                        break;
                    }
                    case INHIBITOR: {
                        double variableValue;
                        if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                        inhibitAnimations = true;
                        break;
                    }
                    case ACTIVATOR: {
                        double variableValue;
                        if (!inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                        inhibitAnimations = false;
                        break;
                    }
                    case TRANSLATION: {
                        if (inhibitAnimations) break;
                        if (clock.animation.axis.x != 0.0) {
                            modifiedValue = (float)((double)modifiedValue * this.getAnimatedVariableValue(clock, clock.animation.axis.x, 0.0f));
                            break;
                        }
                        if (clock.animation.axis.y != 0.0) {
                            modifiedValue = (float)((double)modifiedValue + this.getAnimatedVariableValue(clock, clock.animation.axis.y, 0.0f));
                            break;
                        }
                        modifiedValue = (float)this.getAnimatedVariableValue(clock, clock.animation.axis.z, 0.0f);
                        break;
                    }
                    case ROTATION: {
                        break;
                    }
                }
                if (doModification) continue;
                break;
            }
        }
        return doModification ? modifiedValue : currentValue;
    }

    public void updatePostMovement() {
        this.world.beginProfiling("CollisionBoxUpdates", true);
        this.updateCollisionBoxes();
        this.world.endProfiling();
        if (!this.towingConnections.isEmpty()) {
            this.world.beginProfiling("TowedEntities", true);
            for (TrailerConnection connection : this.towingConnections) {
                connection.hookupVehicle.overrideTowingChecks = true;
                connection.hookupVehicle.update();
                connection.hookupVehicle.overrideTowingChecks = false;
            }
            this.world.endProfiling();
        }
        if (!this.entityCollisionBoxes.isEmpty()) {
            this.world.beginProfiling("MoveAlongEntities", true);
            this.encompassingBox.heightRadius += 1.0;
            List<WrapperEntity> nearbyEntities = this.world.getEntitiesWithin(this.encompassingBox);
            this.encompassingBox.heightRadius -= 1.0;
            block1: for (WrapperEntity entity : nearbyEntities) {
                if (entity.getEntityRiding() != null || entity instanceof WrapperPlayer && ((WrapperPlayer)entity).isSpectator()) continue;
                BoundingBox entityBounds = entity.getBounds();
                entityBounds.heightRadius += 0.25;
                for (BoundingBox box : this.entityCollisionBoxes) {
                    double entityBottomDelta;
                    if (!entityBounds.intersects(box) || !((entityBottomDelta = box.globalCenter.y + box.heightRadius - (entityBounds.globalCenter.y - entityBounds.heightRadius + 0.25)) >= -0.5) || !(entityBottomDelta <= 0.5)) continue;
                    Point3d entityVelocity = entity.getVelocity();
                    if (!(entityVelocity.y < 0.0) && !(entityVelocity.y < entityBottomDelta)) continue;
                    Point3d entityPosition = entity.getPosition();
                    Point3d linearMovement = this.position.copy().subtract(this.prevPosition);
                    Point3d angularMovement = this.angles.copy().subtract(this.prevAngles);
                    Point3d entityDeltaOffset = entityPosition.copy().subtract(this.prevPosition);
                    Point3d vehicleBoxMovement = entityDeltaOffset.copy().rotateFine(angularMovement).subtract(entityDeltaOffset).add(linearMovement);
                    entityPosition.add(vehicleBoxMovement).add(0.0, entityBottomDelta, 0.0);
                    entity.setPosition(entityPosition, true);
                    entity.setYaw((double)entity.getYaw() + angularMovement.y);
                    entity.setBodyYaw((double)entity.getBodyYaw() + angularMovement.y);
                    continue block1;
                }
            }
            this.world.endProfiling();
        }
    }

    public Collection<BoundingBox> getCollisionBoxes() {
        return this.entityCollisionBoxes;
    }

    public Collection<BoundingBox> getInteractionBoxes() {
        return this.interactionBoxes;
    }

    public void updateRider(WrapperEntity rider, Iterator<WrapperEntity> iterator) {
        if (rider.isValid()) {
            rider.setPosition((Point3d)this.locationRiderMap.inverse().get((Object)rider), false);
            rider.setVelocity(this.motion);
        } else {
            this.removeRider(rider, iterator);
        }
    }

    public boolean addRider(WrapperEntity rider, Point3d riderLocation) {
        if (riderLocation == null) {
            if (this.savedRiderLocations.isEmpty()) {
                return false;
            }
            riderLocation = this.savedRiderLocations.get(0);
        }
        for (Point3d location : this.ridableLocations) {
            if (!riderLocation.equals(location)) continue;
            riderLocation = location;
            break;
        }
        this.savedRiderLocations.remove(riderLocation);
        if (this.locationRiderMap.containsKey((Object)riderLocation)) {
            return false;
        }
        if (!this.locationRiderMap.containsValue((Object)rider)) {
            rider.setYaw(this.angles.y);
        } else {
            this.locationRiderMap.inverse().remove((Object)rider);
        }
        this.locationRiderMap.put((Object)riderLocation, (Object)rider);
        if (!this.world.isClient()) {
            rider.setRiding(this);
            InterfacePacket.sendToAllClients(new PacketEntityRiderChange(this, rider, riderLocation));
        }
        return true;
    }

    public void removeRider(WrapperEntity rider, Iterator<WrapperEntity> iterator) {
        if (this.locationRiderMap.containsValue((Object)rider)) {
            if (iterator != null) {
                iterator.remove();
            } else {
                this.locationRiderMap.inverse().remove((Object)rider);
            }
            if (!this.world.isClient()) {
                rider.setRiding(null);
                InterfacePacket.sendToAllClients(new PacketEntityRiderChange(this, rider, null));
            }
        }
    }

    public PlayerOwnerState getOwnerState(WrapperPlayer player) {
        boolean canPlayerEdit;
        boolean bl = canPlayerEdit = player.isOP() || this.ownerUUID == null || player.getID().equals(this.ownerUUID);
        return player.isOP() ? PlayerOwnerState.ADMIN : (canPlayerEdit ? PlayerOwnerState.OWNER : PlayerOwnerState.USER);
    }

    public void attack(Damage damage) {
        if (!damage.isWater) {
            if (((AJSONInteractableEntity)this.definition).collisionGroups != null) {
                for (JSONCollisionGroup groupDef : ((AJSONInteractableEntity)this.definition).collisionGroups) {
                    Set<BoundingBox> collisionBoxes = this.definitionCollisionBoxes.get(groupDef);
                    if (!collisionBoxes.contains(damage.box) || groupDef.health == 0) continue;
                    String variableName = "collision_" + (((AJSONInteractableEntity)this.definition).collisionGroups.indexOf(groupDef) + 1) + "_damage";
                    double currentDamage = this.getVariable(variableName) + damage.amount;
                    if (currentDamage > (double)groupDef.health) {
                        double amountActuallyNeeded = damage.amount - (currentDamage - (double)groupDef.health);
                        currentDamage = groupDef.health;
                        InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, variableName, amountActuallyNeeded));
                    } else {
                        InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, variableName, damage.amount));
                    }
                    this.setVariable(variableName, currentDamage);
                    return;
                }
            }
            this.damageAmount += damage.amount;
            if (((AJSONInteractableEntity)this.definition).general != null && this.damageAmount > (double)((AJSONInteractableEntity)this.definition).general.health) {
                double amountActuallyNeeded = damage.amount - (this.damageAmount - (double)((AJSONInteractableEntity)this.definition).general.health);
                this.damageAmount = ((AJSONInteractableEntity)this.definition).general.health;
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, DAMAGE_VARIABLE, amountActuallyNeeded));
            } else {
                InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(this, DAMAGE_VARIABLE, damage.amount));
            }
            this.setVariable(DAMAGE_VARIABLE, this.damageAmount);
        }
    }

    public EntityConnectionResult checkIfTrailerCanConnect(AEntityE_Interactable<?> hookupEntity, int hitchGroupIndex, int hookupGroupIndex) {
        boolean matchingConnection = false;
        boolean trailerInRange = false;
        double trailerDistance = this.position.distanceTo(hookupEntity.position);
        if (trailerDistance < 25.0 && ((AJSONInteractableEntity)this.definition).connectionGroups != null && !((AJSONInteractableEntity)this.definition).connectionGroups.isEmpty() && ((AJSONInteractableEntity)hookupEntity.definition).connectionGroups != null && !((AJSONInteractableEntity)hookupEntity.definition).connectionGroups.isEmpty()) {
            for (JSONConnectionGroup hitchConnectionGroup : ((AJSONInteractableEntity)this.definition).connectionGroups) {
                if (hitchConnectionGroup.hookup || hitchGroupIndex != -1 && ((AJSONInteractableEntity)this.definition).connectionGroups.indexOf(hitchConnectionGroup) != hitchGroupIndex) continue;
                for (JSONConnectionGroup hookupConnectionGroup : ((AJSONInteractableEntity)hookupEntity.definition).connectionGroups) {
                    if (!hookupConnectionGroup.hookup || hookupGroupIndex != -1 && ((AJSONInteractableEntity)hookupEntity.definition).connectionGroups.indexOf(hookupConnectionGroup) != hookupGroupIndex) continue;
                    for (JSONConnection hitchConnection : hitchConnectionGroup.connections) {
                        Point3d hitchPos = hitchConnection.pos.copy().rotateFine(this.angles).add(this.position);
                        double maxDistance = hitchConnection.distance > 0.0 ? hitchConnection.distance : 2.0;
                        for (JSONConnection hookupConnection : hookupConnectionGroup.connections) {
                            boolean validDistance;
                            Point3d hookupPos = hookupConnection.pos.copy().rotateFine(hookupEntity.angles).add(hookupEntity.position);
                            if (!(hitchPos.distanceTo(hookupPos) < maxDistance + 10.0)) continue;
                            boolean validType = hitchConnection.type.equals(hookupConnection.type);
                            boolean bl = validDistance = hitchPos.distanceTo(hookupPos) < maxDistance;
                            if (validType && validDistance) {
                                this.connectTrailer(new TrailerConnection(this, ((AJSONInteractableEntity)this.definition).connectionGroups.indexOf(hitchConnectionGroup), hitchConnectionGroup.connections.indexOf(hitchConnection), hookupEntity, ((AJSONInteractableEntity)hookupEntity.definition).connectionGroups.indexOf(hookupConnectionGroup), hookupConnectionGroup.connections.indexOf(hookupConnection)));
                                return EntityConnectionResult.TRAILER_CONNECTED;
                            }
                            if (validType) {
                                matchingConnection = true;
                                continue;
                            }
                            if (!validDistance) continue;
                            trailerInRange = true;
                        }
                    }
                }
            }
        }
        if (matchingConnection && !trailerInRange) {
            return EntityConnectionResult.TRAILER_TOO_FAR;
        }
        if (!matchingConnection && trailerInRange) {
            return EntityConnectionResult.TRAILER_WRONG_HITCH;
        }
        return EntityConnectionResult.NO_TRAILER_NEARBY;
    }

    private void handleConnectionRequest(int connectionGroupIndex) {
        String packetMessage;
        block26: {
            boolean requestIsToBecomeTrailer;
            block25: {
                boolean connect;
                JSONConnectionGroup requestedGroup = ((AJSONInteractableEntity)this.definition).connectionGroups.get(connectionGroupIndex);
                requestIsToBecomeTrailer = requestedGroup.hookup;
                packetMessage = null;
                if (requestIsToBecomeTrailer) {
                    connect = this.towedByConnection == null;
                } else {
                    boolean foundConnection = false;
                    for (TrailerConnection connection : this.getTowingConnections()) {
                        if (connection.hitchGroupIndex != connectionGroupIndex) continue;
                        foundConnection = true;
                    }
                    boolean bl = connect = !foundConnection;
                }
                if (!connect) break block25;
                boolean matchingConnection = false;
                boolean trailerInRange = false;
                ArrayList<AEntityE_Interactable> entitiesToCheck = new ArrayList<AEntityE_Interactable>();
                entitiesToCheck.addAll(this.world.getEntitiesOfType(EntityVehicleF_Physics.class));
                entitiesToCheck.addAll(this.world.getEntitiesOfType(PartGeneric.class));
                if (requestIsToBecomeTrailer) {
                    for (AEntityE_Interactable testEntity : entitiesToCheck) {
                        if (AEntityE_Interactable.shouldConnect(testEntity, this)) {
                            switch (testEntity.checkIfTrailerCanConnect(this, -1, connectionGroupIndex)) {
                                case TRAILER_CONNECTED: {
                                    packetMessage = "interact.trailer.connect";
                                    break;
                                }
                                case TRAILER_TOO_FAR: {
                                    matchingConnection = true;
                                    break;
                                }
                                case TRAILER_WRONG_HITCH: {
                                    trailerInRange = true;
                                    break;
                                }
                            }
                        }
                        if (packetMessage == null) continue;
                        break;
                    }
                } else {
                    for (AEntityE_Interactable testEntity : entitiesToCheck) {
                        if (AEntityE_Interactable.shouldConnect(this, testEntity)) {
                            switch (this.checkIfTrailerCanConnect(testEntity, connectionGroupIndex, -1)) {
                                case TRAILER_CONNECTED: {
                                    packetMessage = "interact.trailer.connect";
                                    break;
                                }
                                case TRAILER_TOO_FAR: {
                                    matchingConnection = true;
                                    break;
                                }
                                case TRAILER_WRONG_HITCH: {
                                    trailerInRange = true;
                                    break;
                                }
                            }
                        }
                        if (packetMessage == null) continue;
                        break;
                    }
                }
                if (packetMessage != null) break block26;
                packetMessage = !matchingConnection && !trailerInRange ? "interact.trailer.notfound" : (matchingConnection && !trailerInRange ? "interact.trailer.toofar" : (!matchingConnection && trailerInRange ? "interact.trailer.wronghitch" : "interact.trailer.wrongplacement"));
                break block26;
            }
            if (requestIsToBecomeTrailer) {
                this.towedByConnection.hitchEntity.disconnectTrailer(this.towedByConnection);
                packetMessage = "interact.trailer.disconnect";
            } else {
                for (TrailerConnection connection : this.getTowingConnections()) {
                    if (connection.hitchGroupIndex != connectionGroupIndex) continue;
                    this.disconnectTrailer(connection);
                    packetMessage = "interact.trailer.disconnect";
                    break;
                }
            }
        }
        if (packetMessage != null) {
            for (WrapperEntity entity : this.world.getEntitiesWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                if (!(entity instanceof WrapperPlayer)) continue;
                ((WrapperPlayer)entity).sendPacket(new PacketPlayerChatMessage((WrapperPlayer)entity, packetMessage));
            }
        }
    }

    private static boolean shouldConnect(AEntityE_Interactable<?> hitchEntity, AEntityE_Interactable<?> hookupEntity) {
        if (hookupEntity.towedByConnection != null) {
            return false;
        }
        if (hookupEntity.equals(hitchEntity)) {
            return false;
        }
        if (hookupEntity instanceof AEntityF_Multipart && ((AEntityF_Multipart)hookupEntity).parts.contains(hitchEntity)) {
            return false;
        }
        if (hitchEntity instanceof AEntityF_Multipart && ((AEntityF_Multipart)hitchEntity).parts.contains(hookupEntity)) {
            return false;
        }
        for (TrailerConnection connection : hookupEntity.getTowingConnections()) {
            if (!connection.hookupEntity.equals(hitchEntity) && !connection.hookupVehicle.equals(hitchEntity)) continue;
            return false;
        }
        return true;
    }

    public void connectTrailer(TrailerConnection connection) {
        this.towingConnections.add(connection);
        connection.hookupEntity.connectAsTrailer(connection);
        if (!this.world.isClient()) {
            InterfacePacket.sendToAllClients(new PacketEntityTrailerChange(connection, true));
        }
    }

    public void disconnectTrailer(TrailerConnection connection) {
        this.towingConnections.removeIf(otherConnection -> otherConnection.hookupEntity.equals(connection.hookupEntity));
        connection.hookupEntity.disconnectAsTrailer();
        if (!this.world.isClient()) {
            InterfacePacket.sendToAllClients(new PacketEntityTrailerChange(connection, false));
        }
    }

    public void connectAsTrailer(TrailerConnection connection) {
        this.towedByConnection = connection;
        this.updateAnglesToTowed();
    }

    public void disconnectAsTrailer() {
        this.towedByConnection = null;
    }

    public Set<TrailerConnection> getTowingConnections() {
        return this.towingConnections;
    }

    public void disconnectAllConnections() {
        this.towingConnections.clear();
        this.towedByConnection = null;
    }

    protected void updateAnglesToTowed() {
        if (this.towedByConnection.hitchConnection.mounted || this.towedByConnection.hitchConnection.restricted) {
            this.angles.y = this.towedByConnection.hitchEntity.angles.y;
            if (this.towedByConnection.hitchConnection.mounted) {
                this.angles.add(this.towedByConnection.hitchConnection.rot);
            }
            this.prevAngles.y = this.angles.y;
            for (TrailerConnection trailerConnection : this.towingConnections) {
                trailerConnection.hookupVehicle.updateAnglesToTowed();
            }
        }
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setPoint3ds("savedRiderLocations", this.locationRiderMap.keySet());
        data.setBoolean("locked", this.locked);
        if (this.ownerUUID != null) {
            data.setUUID("ownerUUID", this.ownerUUID);
        }
        if (this.towedByConnection != null) {
            data.setData("towedByConnection", this.towedByConnection.getData());
        }
        int towingConnectionIndex = 0;
        for (TrailerConnection towingEntry : this.towingConnections) {
            data.setData("towingConnection" + towingConnectionIndex++, towingEntry.getData());
        }
        data.setInteger("towingConnectionCount", towingConnectionIndex);
        if (((AJSONInteractableEntity)this.definition).instruments != null) {
            String[] instrumentsInSlots = new String[((AJSONInteractableEntity)this.definition).instruments.size()];
            for (int i = 0; i < instrumentsInSlots.length; ++i) {
                if (!this.instruments.containsKey(i)) continue;
                data.setString("instrument" + i + "_packID", ((JSONInstrument)this.instruments.get((Object)Integer.valueOf((int)i)).definition).packID);
                data.setString("instrument" + i + "_systemName", ((JSONInstrument)this.instruments.get((Object)Integer.valueOf((int)i)).definition).systemName);
            }
        }
        return data;
    }

    public static enum EntityConnectionResult {
        NO_TRAILER_NEARBY,
        TRAILER_TOO_FAR,
        TRAILER_WRONG_HITCH,
        TRAILER_CONNECTED;

    }

    public static enum PlayerOwnerState {
        USER,
        OWNER,
        ADMIN;

    }
}

