/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketPartChange;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.systems.PackParserSystem;

public abstract class AEntityF_Multipart<JSONDefinition extends AJSONPartProvider>
extends AEntityE_Interactable<JSONDefinition> {
    public final List<APart> parts = new ArrayList<APart>();
    public final HashMap<AItemPart, List<APart>> partsByItem = new LinkedHashMap<AItemPart, List<APart>>();
    public final HashMap<AItemPart, APart> lastPrimaryPart = new LinkedHashMap<AItemPart, APart>();
    public final List<APart> partsFromNBT = new ArrayList<APart>();
    public final List<BoundingBox> allBlockCollisionBoxes = new ArrayList<BoundingBox>();
    public final List<BoundingBox> allEntityCollisionBoxes = new ArrayList<BoundingBox>();
    public final List<BoundingBox> allInteractionBoxes = new ArrayList<BoundingBox>();
    public final Map<BoundingBox, JSONPartDefinition> allPartSlotBoxes = new HashMap<BoundingBox, JSONPartDefinition>();
    public final Map<BoundingBox, JSONPartDefinition> activePartSlotBoxes = new HashMap<BoundingBox, JSONPartDefinition>();
    public final Map<BoundingBox, RenderableObject> allPartSlotRenderables = new HashMap<BoundingBox, RenderableObject>();
    private final float PART_SLOT_HITBOX_WIDTH = 0.75f;
    private final float PART_SLOT_HITBOX_HEIGHT = 2.25f;

    public AEntityF_Multipart(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
        for (int i = 0; i < data.getInteger("totalParts"); ++i) {
            try {
                WrapperNBT partData = data.getData("part_" + i);
                AItemPart partItem = (AItemPart)PackParserSystem.getItem(partData.getString("packID"), partData.getString("systemName"), partData.getString("subName"));
                Point3d partOffset = partData.getPoint3d("offset");
                this.addPartFromItem(partItem, placingPlayer, partData, partOffset, true);
                continue;
            }
            catch (Exception e) {
                InterfaceCore.logError("Could not load part from NBT.  Did you un-install a pack?");
            }
        }
        this.recalculatePartSlots();
    }

    @Override
    protected void initializeDefinition() {
        super.initializeDefinition();
        block0: for (APart part : this.parts) {
            if (part.placementDefinition.isSubPart) continue;
            for (JSONPartDefinition packDef : ((AJSONPartProvider)this.definition).parts) {
                if (!packDef.pos.equals(part.placementDefinition.pos)) continue;
                part.placementDefinition.animations = packDef.animations;
                part.animationsInitialized = false;
                continue block0;
            }
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.world.beginProfiling("EntityF_Level", true);
            if (!this.partsFromNBT.isEmpty()) {
                for (APart part : this.partsFromNBT) {
                    this.addPart(part, false);
                }
                this.partsFromNBT.clear();
            }
            this.world.beginProfiling("PartSlotPositions", true);
            for (BoundingBox box : this.allPartSlotBoxes.keySet()) {
                JSONPartDefinition packVehicleDef = this.allPartSlotBoxes.get(box);
                boolean updatedToSubPart = false;
                block2: for (APart part : this.parts) {
                    if (((JSONPart)part.definition).parts == null) continue;
                    for (JSONPartDefinition subPartDef : ((JSONPart)part.definition).parts) {
                        if (!packVehicleDef.equals(part.getPackForSubPart(subPartDef))) continue;
                        Point3d delta = subPartDef.pos.copy().rotateFine(part.localAngles).subtract(subPartDef.pos);
                        box.updateToEntity(this, delta);
                        updatedToSubPart = true;
                        continue block2;
                    }
                }
                if (updatedToSubPart) continue;
                box.updateToEntity(this, null);
            }
            if (this.world.isClient()) {
                this.world.beginProfiling("PartSlotActives", false);
                this.activePartSlotBoxes.clear();
                WrapperPlayer player = InterfaceClient.getClientPlayer();
                AItemBase heldItem = player.getHeldItem();
                if (heldItem instanceof AItemPart) {
                    Iterator<Map.Entry<BoundingBox, JSONPartDefinition>> iterator = this.allPartSlotBoxes.entrySet().iterator();
                    while (iterator.hasNext()) {
                        AItemPart heldPart = (AItemPart)heldItem;
                        Map.Entry<BoundingBox, JSONPartDefinition> partSlotBoxEntry = iterator.next();
                        if (!heldPart.isPartValidForPackDef(partSlotBoxEntry.getValue(), this.subName, false) || this.areVariablesBlocking(partSlotBoxEntry.getValue(), player)) continue;
                        BoundingBox box = partSlotBoxEntry.getKey();
                        box.widthRadius = ((JSONPart)heldPart.definition).generic.width != 0.0f ? (double)((JSONPart)heldPart.definition).generic.width / 2.0 : 0.375;
                        box.heightRadius = ((JSONPart)heldPart.definition).generic.height != 0.0f ? (double)((JSONPart)heldPart.definition).generic.height / 2.0 : 1.125;
                        box.depthRadius = ((JSONPart)heldPart.definition).generic.width != 0.0f ? (double)((JSONPart)heldPart.definition).generic.width / 2.0 : 0.375;
                        this.activePartSlotBoxes.put(partSlotBoxEntry.getKey(), partSlotBoxEntry.getValue());
                    }
                }
            }
            this.world.endProfiling();
            this.world.endProfiling();
            return true;
        }
        return false;
    }

    @Override
    public double getMass() {
        double currentMass = super.getMass();
        for (APart part : this.parts) {
            currentMass += part.getMass();
        }
        return currentMass;
    }

    @Override
    public boolean addRider(WrapperEntity rider, Point3d riderLocation) {
        if (super.addRider(rider, riderLocation)) {
            PartSeat seat = (PartSeat)this.getPartAtLocation((Point3d)this.locationRiderMap.inverse().get((Object)rider));
            if (seat != null && seat.placementDefinition.linkedVariables != null) {
                for (String variable : seat.placementDefinition.linkedVariables) {
                    this.setVariable(variable, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeRider(WrapperEntity rider, Iterator<WrapperEntity> iterator) {
        PartSeat seat = (PartSeat)this.getPartAtLocation((Point3d)this.locationRiderMap.inverse().get((Object)rider));
        if (seat != null && seat.placementDefinition.linkedVariables != null) {
            for (String variable : seat.placementDefinition.linkedVariables) {
                this.setVariable(variable, 1.0);
            }
        }
        super.removeRider(rider, iterator);
    }

    @Override
    public void attack(Damage damage) {
        APart part = this.getPartWithBox(damage.box);
        if (part != null && part.isValid) {
            part.attack(damage);
        } else {
            super.attack(damage);
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (APart part : this.parts) {
            part.remove();
        }
    }

    @Override
    public void updateText(List<String> textLines) {
        int linesChecked = 0;
        for (Map.Entry entry : this.text.entrySet()) {
            entry.setValue(textLines.get(linesChecked));
            ++linesChecked;
        }
        for (APart aPart : this.parts) {
            for (Map.Entry entry : aPart.text.entrySet()) {
                entry.setValue(textLines.get(linesChecked));
                ++linesChecked;
            }
        }
    }

    @Override
    public Collection<BoundingBox> getCollisionBoxes() {
        return this.allEntityCollisionBoxes;
    }

    @Override
    public Collection<BoundingBox> getInteractionBoxes() {
        return this.allInteractionBoxes;
    }

    @Override
    public boolean canCollideWith(AEntityB_Existing entityToCollide) {
        return !(entityToCollide instanceof APart);
    }

    @Override
    public void updatePostMovement() {
        this.world.beginProfiling("PartUpdates_" + this.parts.size(), true);
        Iterator<APart> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            APart part = iterator.next();
            part.update();
            if (part.isValid) continue;
            this.removePart(part, iterator);
        }
        this.world.endProfiling();
        super.updatePostMovement();
        this.world.beginProfiling("BoxAlignment_" + this.allInteractionBoxes.size(), true);
        this.sortBoxes();
        this.world.endProfiling();
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        int partNumber = AEntityF_Multipart.getVariableNumber(variable);
        if (partNumber != -1) {
            return AEntityF_Multipart.getSpecificPartAnimation(this, variable, partNumber, partialTicks);
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public void toggleVariable(String variable) {
        int partNumber = AEntityF_Multipart.getVariableNumber(variable);
        if (partNumber != -1) {
            APart foundPart = AEntityF_Multipart.getSpecificPart(this, variable, partNumber);
            if (foundPart != null) {
                variable = variable.substring(0, variable.lastIndexOf("_"));
                foundPart.toggleVariable(variable);
            }
        } else {
            super.toggleVariable(variable);
        }
    }

    @Override
    public void setVariable(String variable, double value) {
        int partNumber = AEntityF_Multipart.getVariableNumber(variable);
        if (partNumber != -1) {
            APart foundPart = AEntityF_Multipart.getSpecificPart(this, variable, partNumber);
            if (foundPart != null) {
                foundPart.setVariable(variable.substring(0, variable.lastIndexOf("_")), value);
            }
        } else {
            super.setVariable(variable, value);
        }
    }

    public boolean areVariablesBlocking(JSONPartDefinition partDef, WrapperPlayer player) {
        if (partDef.linkedVariables != null) {
            for (String variableName : partDef.linkedVariables) {
                double value;
                if (!(variableName.startsWith("!") ? (value = this.getRawVariableValue(variableName.substring(1), 0.0f)) == 0.0 || Double.isNaN(value) : (value = this.getRawVariableValue(variableName, 0.0f)) > 0.0 && !Double.isNaN(value))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public APart addPartFromItem(AItemPart partItem, WrapperPlayer playerAdding, WrapperNBT partData, Point3d offset, boolean addedDuringConstruction) {
        JSONPartDefinition newPartDef = this.getPackDefForLocation(offset);
        APart partToAdd = null;
        APart parentPart = null;
        if (this.getPartAtLocation(offset) == null && partItem.isPartValidForPackDef(newPartDef, this.subName, true)) {
            for (JSONPartDefinition partDef : ((AJSONPartProvider)this.definition).parts) {
                if (partDef.additionalParts != null) {
                    for (JSONPartDefinition additionalPartDef : partDef.additionalParts) {
                        if (!offset.equals(additionalPartDef.pos)) continue;
                        parentPart = this.getPartAtLocation(partDef.pos);
                        break;
                    }
                }
                if (parentPart == null) continue;
                break;
            }
            ArrayList<APart> partsToCheck = new ArrayList<APart>();
            partsToCheck.addAll(this.parts);
            partsToCheck.addAll(this.partsFromNBT);
            for (APart part : partsToCheck) {
                if (((JSONPart)part.definition).parts == null) continue;
                for (JSONPartDefinition subPartDef : ((JSONPart)part.definition).parts) {
                    JSONPartDefinition correctedDef = part.getPackForSubPart(subPartDef);
                    if (offset.equals(correctedDef.pos)) {
                        parentPart = part;
                        break;
                    }
                    if (subPartDef.additionalParts == null) continue;
                    for (JSONPartDefinition additionalPartDef : subPartDef.additionalParts) {
                        JSONPartDefinition correctedAdditionalDef = part.getPackForSubPart(additionalPartDef);
                        if (!offset.equals(correctedAdditionalDef.pos)) continue;
                        parentPart = this.getPartAtLocation(correctedDef.pos);
                        break;
                    }
                    if (parentPart == null) continue;
                    break;
                }
                if (parentPart == null) continue;
                break;
            }
            partItem.populateDefaultData(partData);
            partToAdd = partItem.createPart(this, playerAdding, newPartDef, partData, parentPart);
        }
        if (partToAdd != null) {
            if (addedDuringConstruction) {
                this.partsFromNBT.add(partToAdd);
                if (partToAdd instanceof PartSeat) {
                    this.ridableLocations.add(partToAdd.placementOffset);
                }
            } else {
                boolean newPart = partData == null || partData.getString("uniqueUUID").isEmpty();
                this.addPart(partToAdd, true);
                if (((JSONPart)partToAdd.definition).parts != null) {
                    for (JSONPartDefinition subPartPack : ((JSONPart)partToAdd.definition).parts) {
                        this.addDefaultPart(partToAdd.getPackForSubPart(subPartPack), playerAdding, (AJSONPartProvider)partToAdd.definition, addedDuringConstruction, !newPart);
                    }
                }
            }
        }
        return partToAdd;
    }

    public void addPart(APart part, boolean sendPacket) {
        this.parts.add(part);
        AItemPart partItem = (AItemPart)part.getItem();
        if (partItem != null) {
            if (!this.partsByItem.containsKey(partItem)) {
                this.partsByItem.put(partItem, new ArrayList());
            }
            this.partsByItem.get(partItem).add(part);
        }
        if (part instanceof PartSeat) {
            this.ridableLocations.add(part.placementOffset);
        }
        this.recalculatePartSlots();
        if (sendPacket && !this.world.isClient()) {
            InterfacePacket.sendToAllClients(new PacketPartChange(this, part));
        }
        this.world.addEntity(part);
    }

    public void removePart(APart part, Iterator<APart> iterator) {
        if (this.parts.contains(part)) {
            if (!part.childParts.isEmpty()) {
                if (iterator == null) {
                    while (!part.childParts.isEmpty()) {
                        this.removePart(part.childParts.get(0), null);
                    }
                } else {
                    for (APart childPart : part.childParts) {
                        childPart.isValid = false;
                    }
                }
            }
            if (iterator != null) {
                iterator.remove();
            } else {
                this.parts.remove(part);
            }
            AItemPart partItem = (AItemPart)part.getItem();
            if (this.partsByItem.containsKey(partItem)) {
                this.partsByItem.get(partItem).remove(part);
                if (part.equals(this.lastPrimaryPart.get(partItem))) {
                    this.lastPrimaryPart.remove(partItem);
                }
            }
            if (this.locationRiderMap.containsKey((Object)part.placementOffset)) {
                this.removeRider((WrapperEntity)this.locationRiderMap.get((Object)part.placementOffset), null);
            }
            part.remove();
            if (!this.world.isClient()) {
                InterfacePacket.sendToAllClients(new PacketPartChange(this, part.placementOffset));
            }
        } else if (this.partsFromNBT.contains(part)) {
            this.partsFromNBT.remove(part);
        }
        if (part instanceof PartSeat) {
            this.ridableLocations.remove(part.placementOffset);
        }
        this.recalculatePartSlots();
    }

    public APart getPartAtLocation(Point3d offset) {
        for (APart part : this.parts) {
            if (!part.placementOffset.equals(offset)) continue;
            return part;
        }
        for (APart part : this.partsFromNBT) {
            if (!part.placementOffset.equals(offset)) continue;
            return part;
        }
        return null;
    }

    public APart getPartWithBox(BoundingBox box) {
        for (APart part : this.parts) {
            if (!part.interactionBoxes.contains(box)) continue;
            return part;
        }
        return null;
    }

    public LinkedHashMap<Point3d, JSONPartDefinition> getAllPossiblePackParts() {
        LinkedHashMap<Point3d, JSONPartDefinition> partDefs = new LinkedHashMap<Point3d, JSONPartDefinition>();
        block0: for (JSONPartDefinition partDef : ((AJSONPartProvider)this.definition).parts) {
            partDefs.put(partDef.pos, partDef);
            if (partDef.additionalParts == null) continue;
            for (APart part : this.parts) {
                if (!part.placementOffset.equals(partDef.pos)) continue;
                for (JSONPartDefinition additionalPartDef : partDef.additionalParts) {
                    partDefs.put(additionalPartDef.pos, additionalPartDef);
                }
                continue block0;
            }
        }
        for (APart part : this.parts) {
            if (((JSONPart)part.definition).parts == null) continue;
            block4: for (JSONPartDefinition subPartDef : ((JSONPart)part.definition).parts) {
                JSONPartDefinition correctedPartDef = part.getPackForSubPart(subPartDef);
                partDefs.put(correctedPartDef.pos, correctedPartDef);
                if (subPartDef.additionalParts == null) continue;
                for (APart part2 : this.parts) {
                    if (!part2.placementOffset.equals(correctedPartDef.pos)) continue;
                    for (JSONPartDefinition additionalPartDef : subPartDef.additionalParts) {
                        correctedPartDef = part.getPackForSubPart(additionalPartDef);
                        partDefs.put(correctedPartDef.pos, correctedPartDef);
                    }
                    continue block4;
                }
            }
        }
        return partDefs;
    }

    public JSONPartDefinition getPackDefForLocation(Point3d offset) {
        for (JSONPartDefinition partDef : ((AJSONPartProvider)this.definition).parts) {
            if (partDef.pos.equals(offset)) {
                return partDef;
            }
            if (partDef.additionalParts == null) continue;
            for (JSONPartDefinition additionalPartDef : partDef.additionalParts) {
                if (!additionalPartDef.pos.equals(offset)) continue;
                return additionalPartDef;
            }
        }
        ArrayList<APart> allParts = new ArrayList<APart>();
        allParts.addAll(this.parts);
        allParts.addAll(this.partsFromNBT);
        for (APart part : allParts) {
            if (((JSONPart)part.definition).parts == null) continue;
            for (JSONPartDefinition subPartDef : ((JSONPart)part.definition).parts) {
                JSONPartDefinition correctedPartDef = part.getPackForSubPart(subPartDef);
                if (correctedPartDef.pos.equals(offset)) {
                    return correctedPartDef;
                }
                if (subPartDef.additionalParts == null) continue;
                for (JSONPartDefinition additionalPartDef : subPartDef.additionalParts) {
                    correctedPartDef = part.getPackForSubPart(additionalPartDef);
                    if (!correctedPartDef.pos.equals(offset)) continue;
                    return correctedPartDef;
                }
            }
        }
        return null;
    }

    public void addDefaultPart(JSONPartDefinition partDef, WrapperPlayer playerAdding, AJSONPartProvider providingDef, boolean addedDuringConstruction, boolean savedParent) {
        if (partDef.defaultPart != null && (!savedParent || partDef.isPermanent)) {
            try {
                String partPackID = partDef.defaultPart.substring(0, partDef.defaultPart.indexOf(58));
                String partSystemName = partDef.defaultPart.substring(partDef.defaultPart.indexOf(58) + 1);
                try {
                    APart addedPart = this.addPartFromItem((AItemPart)PackParserSystem.getItem(partPackID, partSystemName), playerAdding, new WrapperNBT(), partDef.pos, addedDuringConstruction);
                    if (addedPart != null) {
                        this.updatePartTone(addedPart);
                        if (partDef.additionalParts != null) {
                            for (JSONPartDefinition additionalPartDef : partDef.additionalParts) {
                                this.addDefaultPart(addedPart.placementDefinition.isSubPart ? addedPart.parentPart.getPackForSubPart(additionalPartDef) : additionalPartDef, playerAdding, providingDef, addedDuringConstruction, savedParent);
                            }
                        }
                        if (((JSONPart)addedPart.definition).parts != null) {
                            for (JSONPartDefinition subPartPack : ((JSONPart)addedPart.definition).parts) {
                                this.addDefaultPart(addedPart.getPackForSubPart(subPartPack), playerAdding, (AJSONPartProvider)addedPart.definition, addedDuringConstruction, savedParent);
                            }
                        }
                    }
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("Attempted to add defaultPart: " + partPackID + ":" + partSystemName + " to: " + providingDef.packID + ":" + providingDef.systemName + " but that part doesn't exist in the pack item registry.");
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Could not parse defaultPart definition: " + partDef.defaultPart + ".  Format should be \"packId:partName\"");
            }
        }
    }

    public void updatePartTone(APart part) {
        if (part.placementDefinition.toneIndex != 0) {
            List<String> partTones = null;
            for (JSONSubDefinition subDefinition : ((AJSONPartProvider)this.definition).definitions) {
                if (!subDefinition.subName.equals(this.subName)) continue;
                partTones = subDefinition.partTones;
            }
            if (partTones != null && partTones.size() >= part.placementDefinition.toneIndex) {
                String partTone = partTones.get(part.placementDefinition.toneIndex - 1);
                for (JSONSubDefinition subDefinition : ((JSONPart)part.definition).definitions) {
                    if (!subDefinition.subName.equals(partTone)) continue;
                    part.subName = partTone;
                    return;
                }
            }
        }
    }

    private void recalculatePartSlots() {
        this.allPartSlotBoxes.clear();
        this.allPartSlotRenderables.clear();
        for (Map.Entry<Point3d, JSONPartDefinition> packPartEntry : this.getAllPossiblePackParts().entrySet()) {
            if (this.getPartAtLocation(packPartEntry.getKey()) != null) continue;
            BoundingBox newSlotBox = new BoundingBox(packPartEntry.getKey(), packPartEntry.getKey().copy().rotateFine(this.angles).add(this.position), 0.375, 1.125, 0.375, false);
            this.allPartSlotBoxes.put(newSlotBox, packPartEntry.getValue());
            this.allPartSlotRenderables.put(newSlotBox, new RenderableObject(newSlotBox, new ColorRGB(), true));
        }
    }

    protected void sortBoxes() {
        this.allEntityCollisionBoxes.clear();
        this.allEntityCollisionBoxes.addAll(this.entityCollisionBoxes);
        this.allBlockCollisionBoxes.clear();
        this.allBlockCollisionBoxes.addAll(this.blockCollisionBoxes);
        this.allInteractionBoxes.clear();
        this.allInteractionBoxes.addAll(this.interactionBoxes);
        if (this.world.isClient() && !InterfaceClient.getClientPlayer().isHoldingItemType(JSONItem.ItemComponentType.SCANNER)) {
            this.allInteractionBoxes.addAll(this.activePartSlotBoxes.keySet());
        } else {
            this.allInteractionBoxes.addAll(this.allPartSlotBoxes.keySet());
        }
        for (APart part : this.parts) {
            this.allEntityCollisionBoxes.addAll(part.entityCollisionBoxes);
            this.allBlockCollisionBoxes.addAll(part.blockCollisionBoxes);
            if (this.world.isClient()) {
                WrapperPlayer clientPlayer = InterfaceClient.getClientPlayer();
                if (part instanceof PartSeat && part.placementOffset.equals(this.locationRiderMap.inverse().get((Object)clientPlayer)) || (!this.locationRiderMap.inverse().containsKey((Object)clientPlayer) || !(part instanceof PartSeat)) && this.areVariablesBlocking(part.placementDefinition, clientPlayer)) continue;
                if (clientPlayer.isHoldingItemType(JSONItem.ItemComponentType.WRENCH)) {
                    boolean partHasRemovablePart = false;
                    for (APart childPart : part.childParts) {
                        if (childPart.placementDefinition.isPermanent) continue;
                        partHasRemovablePart = true;
                        break;
                    }
                    if (partHasRemovablePart) continue;
                }
            }
            this.allInteractionBoxes.addAll(part.interactionBoxes);
        }
        for (APart part : this.parts) {
            if (part.isFake()) continue;
            this.encompassingBox.widthRadius = (float)Math.max(this.encompassingBox.widthRadius, Math.abs(part.encompassingBox.globalCenter.x - this.position.x + part.encompassingBox.widthRadius));
            this.encompassingBox.heightRadius = (float)Math.max(this.encompassingBox.heightRadius, Math.abs(part.encompassingBox.globalCenter.y - this.position.y + part.encompassingBox.heightRadius));
            this.encompassingBox.depthRadius = (float)Math.max(this.encompassingBox.depthRadius, Math.abs(part.encompassingBox.globalCenter.z - this.position.z + part.encompassingBox.depthRadius));
        }
        this.encompassingBox.updateToEntity(this, null);
    }

    public static APart getSpecificPart(AEntityD_Definable<? extends AJSONPartProvider> entityAnimating, String variable, int partNumber) {
        String partType = variable.substring(0, variable.indexOf("_"));
        JSONPartDefinition foundDef = null;
        for (JSONPartDefinition partDef : ((AJSONPartProvider)entityAnimating.definition).parts) {
            for (String defPartType : partDef.types) {
                if (!partType.equals("part") && !defPartType.startsWith(partType)) continue;
                if (partNumber == 0) {
                    foundDef = partDef;
                    break;
                }
                --partNumber;
                break;
            }
            if (foundDef == null && partDef.additionalParts != null) {
                for (JSONPartDefinition additionalDef : partDef.additionalParts) {
                    for (String defPartType : additionalDef.types) {
                        if (!partType.equals("part") && !defPartType.startsWith(partType)) continue;
                        if (partNumber == 0) {
                            foundDef = additionalDef;
                            break;
                        }
                        --partNumber;
                        break;
                    }
                    if (foundDef == null) continue;
                    break;
                }
            }
            if (foundDef == null) continue;
            if (entityAnimating instanceof APart) {
                APart part = (APart)entityAnimating;
                return part.entityOn.getPartAtLocation(part.getPackForSubPart((JSONPartDefinition)foundDef).pos);
            }
            AEntityF_Multipart provider = (AEntityF_Multipart)entityAnimating;
            return provider.getPartAtLocation(foundDef.pos);
        }
        return null;
    }

    public static double getSpecificPartAnimation(AEntityD_Definable<? extends AJSONPartProvider> entityAnimating, String variable, int partNumber, float partialTicks) {
        APart foundPart = AEntityF_Multipart.getSpecificPart(entityAnimating, variable, partNumber);
        if (foundPart != null) {
            return foundPart.getRawVariableValue(variable.substring(0, variable.lastIndexOf("_")), partialTicks);
        }
        return 0.0;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        ArrayList<APart> allParts = new ArrayList<APart>();
        allParts.addAll(this.parts);
        allParts.addAll(this.partsFromNBT);
        int totalParts = 0;
        for (APart part : allParts) {
            if (!part.isValid || part.isFake()) continue;
            WrapperNBT partData = part.save(new WrapperNBT());
            partData.setPoint3d("offset", part.placementOffset);
            data.setData("part_" + totalParts, partData);
            ++totalParts;
        }
        data.setInteger("totalParts", totalParts);
        return data;
    }
}

