/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.Iterator;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIHUD;
import minecrafttransportsimulator.guis.instances.GUIPanelAircraft;
import minecrafttransportsimulator.guis.instances.GUIPanelGround;
import minecrafttransportsimulator.guis.instances.GUIRadio;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceInput;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;

abstract class AEntityVehicleB_Rideable
extends AEntityF_Multipart<JSONVehicle> {
    public static boolean lockCameraToMovement = true;
    public static final double SPEED_FACTOR = (Double)ConfigSystem.configObject.general.speedFactor.value;

    public AEntityVehicleB_Rideable(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
        if (placingPlayer != null) {
            Point3d playerSightVector = placingPlayer.getLineOfSight(3.0);
            this.position.setTo(placingPlayer.getPosition().add(playerSightVector.x, 0.0, playerSightVector.z));
            this.prevPosition.setTo(this.position);
            this.angles.set(0.0, placingPlayer.getYaw() + 90.0f, 0.0);
            this.prevAngles.setTo(this.angles);
            this.motion.set(0.0, 0.0, 0.0);
            this.prevMotion.set(0.0, 0.0, 0.0);
        }
    }

    @Override
    public double getMass() {
        return super.getMass() + (double)((JSONVehicle)this.definition).motorized.emptyMass;
    }

    @Override
    public void updateRider(WrapperEntity rider, Iterator<WrapperEntity> iterator) {
        Point3d riderPositionOffset = (Point3d)this.locationRiderMap.inverse().get((Object)rider);
        PartSeat seat = (PartSeat)this.getPartAtLocation(riderPositionOffset);
        if (rider.isValid() && seat != null) {
            if (((JSONVehicle)this.definition).effects != null) {
                for (JSONPotionEffect effect : ((JSONVehicle)this.definition).effects) {
                    rider.addPotionEffect(effect);
                }
            }
            if (seat.placementDefinition.seatEffects != null) {
                for (JSONPotionEffect effect : seat.placementDefinition.seatEffects) {
                    rider.addPotionEffect(effect);
                }
            }
            double seatYPos = rider.getEyeHeight() + rider.getSeatOffset();
            if (((JSONPart)seat.definition).seat.heightScale != 0.0f) {
                seatYPos *= (double)((JSONPart)seat.definition).seat.heightScale;
            }
            Point3d seatLocationOffset = new Point3d(0.0, seatYPos, 0.0).rotateFine(seat.localAngles).add(seat.localOffset).rotateFine(this.angles).add(this.position).add(0.0, -rider.getEyeHeight(), 0.0);
            rider.setPosition(seatLocationOffset, false);
            rider.setVelocity(this.motion);
            boolean controllingGun = false;
            for (APart part : this.parts) {
                if (!(part instanceof PartGun) || !rider.equals(((PartGun)part).getController())) continue;
                controllingGun = true;
            }
            if (controllingGun || !this.world.isClient() || InterfaceClient.inFirstPerson() || lockCameraToMovement) {
                double playerYawDelta = (360.0 + (this.angles.y - (double)rider.getYaw()) % 360.0) % 360.0;
                if (playerYawDelta > 180.0) {
                    playerYawDelta -= 360.0;
                }
                rider.setYaw((double)rider.getYaw() + this.angles.y - this.prevAngles.y);
                rider.setPitch((double)rider.getPitch() + Math.cos(Math.toRadians(playerYawDelta)) * (this.angles.x - this.prevAngles.x) + Math.sin(Math.toRadians(playerYawDelta)) * (this.angles.z - this.prevAngles.z));
            }
            if (this.world.isClient() && !InterfaceClient.isChatOpen() && rider.equals(InterfaceClient.getClientPlayer())) {
                ControlSystem.controlVehicle((EntityVehicleF_Physics)this, seat.placementDefinition.isController);
                InterfaceInput.setMouseEnabled(!seat.placementDefinition.isController || (Boolean)ConfigSystem.configObject.clientControls.mouseYoke.value == false || !lockCameraToMovement);
            }
        } else {
            this.removeRider(rider, iterator);
        }
    }

    @Override
    public boolean addRider(WrapperEntity rider, Point3d riderLocation) {
        boolean riderAlreadyInSeat = this.locationRiderMap.containsValue((Object)rider);
        boolean success = super.addRider(rider, riderLocation);
        if (success) {
            PartSeat newSeat = (PartSeat)this.getPartAtLocation((Point3d)this.locationRiderMap.inverse().get((Object)rider));
            if (!riderAlreadyInSeat) {
                rider.setYaw(this.angles.y + newSeat.localAngles.y);
            } else {
                if (this.world.isClient() && InterfaceClient.getClientPlayer().equals(rider)) {
                    if (((JSONVehicle)this.definition).motorized.isAircraft) {
                        AGUIBase.closeIfOpen(GUIPanelAircraft.class);
                    } else {
                        AGUIBase.closeIfOpen(GUIPanelGround.class);
                    }
                }
                AGUIBase.closeIfOpen(GUIHUD.class);
            }
            if (this.world.isClient() && InterfaceClient.getClientPlayer().equals(rider)) {
                new GUIHUD((EntityVehicleF_Physics)this, newSeat);
            }
        }
        return success;
    }

    @Override
    public void removeRider(WrapperEntity rider, Iterator<WrapperEntity> iterator) {
        JSONPartDefinition packPart;
        Point3d riderLocation = (Point3d)this.locationRiderMap.inverse().get((Object)rider);
        super.removeRider(rider, iterator);
        if (((JSONVehicle)this.definition).effects != null) {
            for (Object effect : ((JSONVehicle)this.definition).effects) {
                rider.removePotionEffect((JSONPotionEffect)effect);
            }
        }
        if ((packPart = this.getPackDefForLocation(riderLocation)) != null) {
            Point3d dismountPosition;
            if (packPart.seatEffects != null) {
                for (JSONPotionEffect effect : packPart.seatEffects) {
                    rider.removePotionEffect(effect);
                }
            }
            APart partRiding = this.getPartAtLocation(riderLocation);
            if (packPart.dismountPos != null) {
                dismountPosition = partRiding != null ? packPart.dismountPos.copy().add(partRiding.localOffset).subtract(partRiding.placementOffset).rotateFine(this.angles).add(this.position) : packPart.dismountPos.copy().rotateFine(this.angles).add(this.position);
            } else if (partRiding != null) {
                Point3d partDelta = partRiding.localOffset.copy().subtract(partRiding.placementOffset);
                if (riderLocation.x < 0.0) {
                    partDelta.x = -partDelta.x;
                    dismountPosition = riderLocation.copy().add(-2.0, 0.0, 0.0).add(partDelta).rotateFine(this.angles).add(this.position);
                } else {
                    dismountPosition = riderLocation.copy().add(2.0, 0.0, 0.0).add(partDelta).rotateFine(this.angles).add(this.position);
                }
            } else {
                dismountPosition = riderLocation.copy().add(riderLocation.x > 0.0 ? 2.0 : -2.0, 0.0, 0.0).rotateFine(this.angles).add(this.position);
            }
            rider.setPosition(dismountPosition, false);
        }
        if (this.world.isClient() && InterfaceClient.getClientPlayer().equals(rider)) {
            InterfaceInput.setMouseEnabled(true);
            if (((JSONVehicle)this.definition).motorized.isAircraft) {
                AGUIBase.closeIfOpen(GUIPanelAircraft.class);
            } else {
                AGUIBase.closeIfOpen(GUIPanelGround.class);
            }
            AGUIBase.closeIfOpen(GUIHUD.class);
            AGUIBase.closeIfOpen(GUIRadio.class);
        }
    }

    public WrapperPlayer getController() {
        for (Point3d location : this.locationRiderMap.keySet()) {
            PartSeat seat = (PartSeat)this.getPartAtLocation(location);
            WrapperEntity rider = (WrapperEntity)this.locationRiderMap.get((Object)location);
            if (seat == null || !seat.placementDefinition.isController || !(rider instanceof WrapperPlayer)) continue;
            return (WrapperPlayer)rider;
        }
        return null;
    }
}

