/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.Iterator;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.AEntityVehicleB_Rideable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.systems.ConfigSystem;

abstract class AEntityVehicleC_Colliding
extends AEntityVehicleB_Rideable {
    private float hardnessHitThisTick = 0.0f;
    public double currentMass;
    public double axialVelocity;
    public final Point3d headingVector = new Point3d();
    public final Point3d verticalVector = new Point3d();
    public final Point3d sideVector = new Point3d();
    public final Point3d normalizedVelocityVector = new Point3d();

    public AEntityVehicleC_Colliding(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.world.beginProfiling("VehicleC_Level", true);
            this.world.beginProfiling("SetVectors", true);
            this.headingVector.set(0.0, 0.0, 1.0).rotateFine(this.angles);
            this.verticalVector.set(0.0, 1.0, 0.0).rotateFine(this.angles);
            this.sideVector.setTo(this.verticalVector.crossProduct(this.headingVector));
            this.normalizedVelocityVector.setTo(this.motion).normalize();
            this.axialVelocity = Math.abs(this.motion.dotProduct(this.headingVector));
            this.world.beginProfiling("SetMass", false);
            this.currentMass = this.getMass();
            if (this.velocity > 0.5 && this.ticksExisted % 20L == 0L) {
                this.world.beginProfiling("CloseDoors", false);
                Iterator variableIterator = this.variables.keySet().iterator();
                while (variableIterator.hasNext()) {
                    if (!((String)variableIterator.next()).startsWith("door")) continue;
                    variableIterator.remove();
                }
            }
            this.hardnessHitThisTick = 0.0f;
            this.world.endProfiling();
            this.world.endProfiling();
            return true;
        }
        return false;
    }

    protected double getCollisionForAxis(BoundingBox box, boolean xAxis, boolean yAxis, boolean zAxis) {
        Point3d collisionMotion = this.motion.copy().multiply(SPEED_FACTOR);
        if (box.updateCollidingBlocks(this.world, collisionMotion)) {
            float hardnessHitThisBox = 0.0f;
            for (Point3d blockPosition : box.collidingBlockPositions) {
                float blockHardness = this.world.getBlockHardness(blockPosition);
                if (this.world.isBlockLiquid(blockPosition)) continue;
                if (((Boolean)ConfigSystem.configObject.general.blockBreakage.value).booleanValue() && (double)blockHardness <= this.velocity * this.currentMass / 250.0 && blockHardness >= 0.0f) {
                    hardnessHitThisBox += blockHardness;
                    if (!yAxis) {
                        this.hardnessHitThisTick += blockHardness;
                    }
                    this.motion.multiply(Math.max(1.0 - (double)(blockHardness * 0.5f) / ((1000.0 + this.currentMass) / 1000.0), 0.0));
                    if (this.world.isClient()) continue;
                    if (this.ticksExisted > 500L) {
                        this.world.destroyBlock(blockPosition, true);
                        continue;
                    }
                    this.motion.set(0.0, 0.0, 0.0);
                    return -1.0;
                }
                this.hardnessHitThisTick = 0.0f;
                this.motion.set(0.0, 0.0, 0.0);
                return -2.0;
            }
            if (((Boolean)ConfigSystem.configObject.general.vehicleDestruction.value).booleanValue() && (double)this.hardnessHitThisTick > this.currentMass / (0.75 + this.velocity) / 250.0) {
                if (!this.world.isClient()) {
                    APart partHit = this.getPartWithBox(box);
                    if (partHit != null) {
                        this.hardnessHitThisTick -= hardnessHitThisBox;
                        this.removePart(partHit, null);
                    } else {
                        this.destroy(box);
                    }
                }
                return -1.0;
            }
            if (xAxis) {
                return box.currentCollisionDepth.x;
            }
            if (yAxis) {
                return box.currentCollisionDepth.y;
            }
            if (zAxis) {
                return box.currentCollisionDepth.z;
            }
            throw new IllegalArgumentException("Collision requested but no axis was specified!");
        }
        return 0.0;
    }

    @Override
    public void destroy(BoundingBox box) {
        super.destroy(box);
        ArrayList<WrapperItemStack> drops = new ArrayList<WrapperItemStack>();
        this.addDropsToList(drops);
        for (APart part : this.parts) {
            part.addDropsToList(drops);
        }
        for (WrapperItemStack stack : drops) {
            this.world.spawnItemStack(stack, box.globalCenter);
        }
        WrapperPlayer controller = this.getController();
        Damage controllerCrashDamage = new Damage("crash", (Double)ConfigSystem.configObject.damage.crashDamageFactor.value * this.velocity * 20.0, null, this, null);
        Damage passengerCrashDamage = new Damage("crash", (Double)ConfigSystem.configObject.damage.crashDamageFactor.value * this.velocity * 20.0, null, this, controller);
        for (WrapperEntity rider : this.locationRiderMap.values()) {
            if (rider.equals(controller)) {
                rider.attack(controllerCrashDamage);
                continue;
            }
            rider.attack(passengerCrashDamage);
        }
        Iterator<WrapperEntity> riderIterator = this.locationRiderMap.inverse().keySet().iterator();
        while (riderIterator.hasNext()) {
            this.removeRider((WrapperEntity)riderIterator.next(), riderIterator);
        }
    }
}

