/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.Iterator;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.TrailerConnection;
import minecrafttransportsimulator.baseclasses.VehicleGroundDeviceCollection;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.RoadFollowingState;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.AEntityVehicleC_Colliding;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketVehicleServerMovement;
import minecrafttransportsimulator.systems.ConfigSystem;

abstract class AEntityVehicleD_Moving
extends AEntityVehicleC_Colliding {
    public static final String LEFTTURNLIGHT_VARIABLE = "left_turn_signal";
    public static final String RIGHTTURNLIGHT_VARIABLE = "right_turn_signal";
    public static final String BRAKE_VARIABLE = "brake";
    public static final String PARKINGBRAKE_VARIABLE = "p_brake";
    public double brake;
    public boolean parkingBrakeOn;
    public static final double MAX_BRAKE = 1.0;
    public boolean goingInReverse;
    public boolean slipping;
    public boolean skidSteerActive;
    public boolean lockedOnRoad;
    public double groundVelocity;
    public double weightTransfer = 0.0;
    public float currentDownForce;
    public float currentBrakingFactor;
    public float currentOverSteer;
    public float currentUnderSteer;
    private RoadFollowingState frontFollower;
    private RoadFollowingState rearFollower;
    private RoadLane.LaneSelectionRequest selectedSegment = RoadLane.LaneSelectionRequest.NONE;
    private double totalPathDelta;
    private double prevTotalPathDelta;
    private final Point3d serverDeltaM;
    private final Point3d serverDeltaR;
    private double serverDeltaP;
    private final Point3d clientDeltaM;
    private final Point3d clientDeltaR;
    private double clientDeltaP;
    private final Point3d clientDeltaMApplied = new Point3d();
    private final Point3d clientDeltaRApplied = new Point3d();
    private double clientDeltaPApplied;
    private final Point3d roadMotion = new Point3d();
    private final Point3d roadRotation = new Point3d();
    private final Point3d collisionMotion = new Point3d();
    private final Point3d collisionRotation = new Point3d();
    private final Point3d motionApplied = new Point3d();
    private final Point3d rotationApplied = new Point3d();
    private double pathingApplied;
    private final Point3d tempBoxPosition = new Point3d();
    private final Point3d tempBoxRotation = new Point3d();
    private final Point3d normalizedGroundVelocityVector = new Point3d();
    private final Point3d normalizedGroundHeadingVector = new Point3d();
    private AEntityE_Interactable<?> lastCollidedEntity;
    public VehicleGroundDeviceCollection groundDeviceCollective;

    public AEntityVehicleD_Moving(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
        this.prevTotalPathDelta = this.totalPathDelta = data.getDouble("totalPathDelta");
        this.serverDeltaM = data.getPoint3d("serverDeltaM");
        this.serverDeltaR = data.getPoint3d("serverDeltaR");
        this.serverDeltaP = data.getDouble("serverDeltaP");
        this.clientDeltaM = this.serverDeltaM.copy();
        this.clientDeltaR = this.serverDeltaR.copy();
        this.clientDeltaP = this.serverDeltaP;
        this.groundDeviceCollective = new VehicleGroundDeviceCollection((EntityVehicleF_Physics)this);
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.world.beginProfiling("VehicleD_Level", true);
            if (this.ticksExisted == 1L && this.placingPlayer != null && !this.world.isClient()) {
                double furthestDownPoint = 0.0;
                for (JSONCollisionGroup collisionGroup : ((JSONVehicle)this.definition).collisionGroups) {
                    for (JSONCollisionBox collisionBox : collisionGroup.collisions) {
                        furthestDownPoint = Math.min(collisionBox.pos.y - (double)(collisionBox.height / 2.0f), furthestDownPoint);
                    }
                }
                for (APart part : this.parts) {
                    furthestDownPoint = Math.min(part.placementOffset.y - (double)(part.getHeight() / 2.0f), furthestDownPoint);
                }
                this.motionApplied.set(0.0, -(furthestDownPoint += -0.1), 0.0);
                this.rotationApplied.set(0.0, 0.0, 0.0);
                this.position.add(this.motionApplied);
                for (BoundingBox coreBox : this.allBlockCollisionBoxes) {
                    coreBox.updateToEntity(this, null);
                    if (coreBox.updateCollidingBlocks(this.world, new Point3d(0.0, -furthestDownPoint, 0.0))) {
                        this.remove();
                        this.placingPlayer.sendPacket(new PacketPlayerChatMessage(this.placingPlayer, "interact.failure.nospace"));
                        if (!this.placingPlayer.isCreative()) {
                            this.placingPlayer.setHeldStack(((AItemBase)this.getItem()).getNewStack(this.save(new WrapperNBT())));
                        }
                        return false;
                    }
                    this.addToServerDeltas(this.motionApplied, this.rotationApplied, this.pathingApplied);
                    InterfacePacket.sendToAllClients(new PacketVehicleServerMovement((EntityVehicleF_Physics)this, this.motionApplied, this.rotationApplied, this.pathingApplied));
                }
            }
            this.brake = this.getVariable(BRAKE_VARIABLE);
            this.parkingBrakeOn = this.isVariableActive(PARKINGBRAKE_VARIABLE);
            this.world.beginProfiling("GroundDevices", true);
            if (this.ticksExisted == 1L) {
                this.groundDeviceCollective.updateBounds();
            }
            for (APart part : this.parts) {
                if (!(part instanceof PartGroundDevice)) continue;
                if (part.prevActive != part.isActive) {
                    this.groundDeviceCollective.updateMembers();
                    this.groundDeviceCollective.updateBounds();
                    break;
                }
                if (part.localOffset.equals(part.prevLocalOffset)) continue;
                this.groundDeviceCollective.updateBounds();
                break;
            }
            if (!((Boolean)ConfigSystem.configObject.general.noclipVehicles.value).booleanValue() || this.groundDeviceCollective.isReady()) {
                this.world.beginProfiling("GroundForces", false);
                this.getForcesAndMotions();
                this.world.beginProfiling("GroundOperations", false);
                this.performGroundOperations();
                this.world.beginProfiling("TotalMovement", false);
                this.moveVehicle();
                if (!this.world.isClient()) {
                    this.adjustControlSurfaces();
                }
            }
            this.world.beginProfiling("PostMovement", false);
            this.updatePostMovement();
            this.world.endProfiling();
            this.world.endProfiling();
            return true;
        }
        return false;
    }

    @Override
    public void addPart(APart part, boolean sendPacket) {
        super.addPart(part, sendPacket);
        this.groundDeviceCollective.updateMembers();
        this.groundDeviceCollective.updateBounds();
    }

    @Override
    public void removePart(APart part, Iterator<APart> iterator) {
        super.removePart(part, iterator);
        this.groundDeviceCollective.updateMembers();
        this.groundDeviceCollective.updateBounds();
    }

    @Override
    protected void sortBoxes() {
        super.sortBoxes();
        if (this.ticksExisted == 1L) {
            this.groundDeviceCollective.updateMembers();
            this.groundDeviceCollective.updateBounds();
            this.groundDeviceCollective.updateCollisions();
        }
    }

    @Override
    public boolean needsChunkloading() {
        return this.rearFollower != null || this.towedByConnection != null && this.towedByConnection.hitchVehicle.rearFollower != null;
    }

    @Override
    public boolean canCollideWith(AEntityB_Existing entityToCollide) {
        if (this.towedByConnection != null && entityToCollide.equals(this.towedByConnection.hitchVehicle)) {
            return false;
        }
        if (!this.towingConnections.isEmpty()) {
            for (TrailerConnection connection : this.towingConnections) {
                if (!entityToCollide.equals(connection.hookupVehicle)) continue;
                return false;
            }
        }
        return super.canCollideWith(entityToCollide);
    }

    @Override
    public void connectAsTrailer(TrailerConnection connection) {
        super.connectAsTrailer(connection);
        if (this.parkingBrakeOn) {
            this.toggleVariable(PARKINGBRAKE_VARIABLE);
        }
        this.setVariable(BRAKE_VARIABLE, 0.0);
        this.frontFollower = null;
        this.rearFollower = null;
    }

    @Override
    public void disconnectAsTrailer() {
        super.disconnectAsTrailer();
        if (((JSONVehicle)this.definition).motorized.isTrailer) {
            this.parkingBrakeOn = true;
        }
    }

    private RoadFollowingState getFollower() {
        Point3d contactPoint = this.groundDeviceCollective.getContactPoint(false);
        if (contactPoint != null) {
            TileEntityRoad road;
            contactPoint.rotateFine(this.angles).add(this.position);
            Point3d testPoint = new Point3d();
            ABlockBase block = this.world.getBlock(contactPoint);
            if (block instanceof BlockCollision && (road = ((BlockCollision)block).getMasterRoad(this.world, contactPoint)) != null) {
                for (RoadLane lane : road.lanes) {
                    for (BezierCurve curve : lane.curves) {
                        for (float f = 0.0f; f < curve.pathLength; f += 1.0f) {
                            boolean oppositeDirection;
                            curve.setPointToPositionAt(testPoint, f);
                            testPoint.add(road.position.x, road.position.y, road.position.z);
                            if (!(testPoint.distanceTo(contactPoint) < 1.0)) continue;
                            curve.setPointToRotationAt(testPoint, f);
                            boolean sameDirection = Math.abs(testPoint.getClampedYDelta(this.angles.y)) < 10.0;
                            boolean bl = oppositeDirection = Math.abs(testPoint.getClampedYDelta(this.angles.y)) > 170.0;
                            if (!sameDirection && !oppositeDirection) continue;
                            return new RoadFollowingState(lane, curve, sameDirection, f);
                        }
                    }
                }
            }
        }
        return null;
    }

    private void performGroundOperations() {
        float skiddingFactor;
        float brakingFactor;
        float f = brakingFactor = this.towedByConnection == null ? this.getBrakingForce() * this.currentBrakingFactor : 0.0f;
        if (brakingFactor > 0.0f) {
            double brakingForce = (double)(20.0f * brakingFactor) / this.currentMass;
            if (brakingForce > this.velocity) {
                this.motion.x = 0.0;
                this.motion.z = 0.0;
                this.rotation.y = 0.0;
            } else {
                this.motion.x -= brakingForce * this.motion.x / this.velocity;
                this.motion.z -= brakingForce * this.motion.z / this.velocity;
            }
        }
        this.normalizedGroundVelocityVector.set(this.motion.x, 0.0, this.motion.z);
        this.groundVelocity = this.normalizedGroundVelocityVector.length();
        this.normalizedGroundVelocityVector.normalize();
        this.normalizedGroundHeadingVector.set(this.headingVector.x, 0.0, this.headingVector.z).normalize();
        double turningForce = this.getTurningForce();
        double dotProduct = this.normalizedGroundVelocityVector.dotProduct(this.normalizedGroundHeadingVector);
        if (this.skidSteerActive) {
            this.goingInReverse = false;
        } else if (!this.goingInReverse && dotProduct < -0.75 && (turningForce == 0.0 || this.velocity < 0.1)) {
            this.goingInReverse = true;
        } else if (this.goingInReverse && dotProduct > 0.75 && (turningForce == 0.0 || this.velocity < 0.1)) {
            this.goingInReverse = false;
        }
        if (turningForce != 0.0) {
            this.rotation.y = this.rotation.y + (this.goingInReverse ? -turningForce : turningForce);
        }
        if ((skiddingFactor = this.getSkiddingForce()) != 0.0f && this.groundVelocity > 0.01) {
            Point3d crossProduct = this.normalizedGroundVelocityVector.crossProduct(this.normalizedGroundHeadingVector);
            double vectorDelta = Math.toDegrees(Math.atan2(crossProduct.y, dotProduct));
            if (this.goingInReverse && dotProduct < 0.0) {
                if (vectorDelta >= 90.0) {
                    vectorDelta = -(180.0 - vectorDelta);
                } else if (vectorDelta <= -90.0) {
                    vectorDelta = 180.0 + vectorDelta;
                }
            }
            if (this.towedByConnection == null) {
                double overSteerForce = Math.max(this.velocity / 4.0, 1.0);
                if (((JSONVehicle)this.definition).motorized.overSteerAccel != 0.0f) {
                    this.weightTransfer += (this.motion.dotProduct(this.motion) - this.prevMotion.dotProduct(this.prevMotion)) * this.weightTransfer * (double)this.currentOverSteer;
                    if (Math.abs(this.weightTransfer) > (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerAccel) && Math.abs(this.weightTransfer) > (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerDecel)) {
                        this.weightTransfer = ((JSONVehicle)this.definition).motorized.overSteerAccel;
                    } else if (Math.abs(this.weightTransfer) < (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerDecel) && this.weightTransfer < (double)Math.abs(((JSONVehicle)this.definition).motorized.overSteerAccel)) {
                        this.weightTransfer = ((JSONVehicle)this.definition).motorized.overSteerDecel;
                    }
                } else {
                    this.weightTransfer = this.currentOverSteer;
                }
                this.rotation.y += crossProduct.y * this.weightTransfer + Math.abs(crossProduct.y) * (double)(-this.currentUnderSteer) * turningForce * overSteerForce;
            }
            if (Math.abs(vectorDelta) > 0.001) {
                double motionFactor = vectorDelta > (double)skiddingFactor ? (double)skiddingFactor / vectorDelta : (vectorDelta < (double)(-skiddingFactor) ? (double)(-skiddingFactor) / vectorDelta : 1.0);
                Point3d idealMotion = this.goingInReverse ? this.normalizedGroundHeadingVector.copy().multiply(-this.groundVelocity) : this.normalizedGroundHeadingVector.copy().multiply(this.groundVelocity);
                idealMotion.multiply(motionFactor).add(this.motion.x * (1.0 - motionFactor), 0.0, this.motion.z * (1.0 - motionFactor));
                this.motion.x = idealMotion.x;
                this.motion.z = idealMotion.z;
                this.slipping = this.towedByConnection == null ? this.world.isClient() && motionFactor != 1.0 && this.velocity > 0.75 : this.towedByConnection != null && this.towedByConnection.hitchVehicle.slipping;
            }
        }
    }

    private float getBrakingForce() {
        double brakingPower = this.parkingBrakeOn ? 1.0 : this.brake;
        float brakingFactor = 0.0f;
        if (brakingPower > 0.0) {
            for (PartGroundDevice groundDevice : this.groundDeviceCollective.groundedGroundDevices) {
                float groundDevicePower = groundDevice.getMotiveFriction();
                if (groundDevicePower == 0.0f) continue;
                brakingFactor += Math.max(groundDevicePower - groundDevice.getFrictionLoss(), 0.0f);
            }
            if (brakingPower > 0.0) {
                brakingFactor = (float)((double)brakingFactor + 0.15 * brakingPower * (double)this.groundDeviceCollective.getNumberBoxesInLiquid());
            }
        }
        return brakingFactor += 2.0f * (float)this.groundDeviceCollective.getNumberCollidedLiquidBoxes();
    }

    private float getSkiddingForce() {
        float skiddingFactor = 0.0f;
        for (PartGroundDevice groundDevice : this.groundDeviceCollective.groundedGroundDevices) {
            skiddingFactor += Math.max(groundDevice.getLateralFriction() - groundDevice.getFrictionLoss(), 0.0f);
        }
        return (skiddingFactor = (float)((double)skiddingFactor + 0.5 * (double)this.groundDeviceCollective.getNumberBoxesInLiquid())) > 0.0f ? skiddingFactor : 0.0f;
    }

    private double getTurningForce() {
        double steeringAngle = this.getSteeringAngle() * 45.0;
        this.skidSteerActive = false;
        if (steeringAngle != 0.0) {
            double turningDistance = 0.0;
            boolean treadsOnly = true;
            for (PartGroundDevice groundDevice : this.groundDeviceCollective.groundedGroundDevices) {
                if (!groundDevice.placementDefinition.turnsWithSteer || groundDevice.isFake()) continue;
                turningDistance = Math.max(turningDistance, Math.abs(groundDevice.placementOffset.z));
                if (!treadsOnly || ((JSONPart)groundDevice.definition).ground.isTread) continue;
                treadsOnly = false;
            }
            if (treadsOnly) {
                turningDistance *= 2.0;
            }
            if (turningDistance == 0.0) {
                for (APart part : this.parts) {
                    if (!(part instanceof PartPropeller) || !part.isInLiquid()) continue;
                    turningDistance = Math.max(turningDistance, Math.abs(part.placementOffset.z));
                    break;
                }
            }
            if (turningDistance > 0.0) {
                if (((JSONVehicle)this.definition).motorized.hasSkidSteer) {
                    if (this.groundDeviceCollective.isReady() && this.groundVelocity < 0.05) {
                        boolean foundNeutralEngine = false;
                        boolean leftWheelGrounded = false;
                        boolean rightWheelGrounded = false;
                        for (APart part : this.parts) {
                            if (part instanceof PartGroundDevice) {
                                if (!this.groundDeviceCollective.groundedGroundDevices.contains(part)) continue;
                                if (part.placementOffset.x > 0.0) {
                                    leftWheelGrounded = true;
                                    continue;
                                }
                                rightWheelGrounded = true;
                                continue;
                            }
                            if (!(part instanceof PartEngine) || ((PartEngine)part).currentGear != 0 || !((PartEngine)part).running) continue;
                            foundNeutralEngine = true;
                        }
                        boolean bl = this.skidSteerActive = foundNeutralEngine && leftWheelGrounded && rightWheelGrounded;
                    }
                    if (this.skidSteerActive) {
                        return steeringAngle / 20.0;
                    }
                }
                double turningForce = steeringAngle / turningDistance;
                if (this.groundVelocity > 0.35) {
                    turningForce *= Math.pow(0.3f, this.groundVelocity * (double)(1.0f - this.currentDownForce) - 0.35);
                }
                return turningForce * this.groundVelocity * (SPEED_FACTOR / 0.35) / 2.0;
            }
        }
        return 0.0;
    }

    private void moveVehicle() {
        this.world.beginProfiling("GDBInit", true);
        this.collidedEntities.clear();
        this.groundDeviceCollective.updateCollisions();
        this.world.beginProfiling("RoadChecks", false);
        if (((JSONVehicle)this.definition).motorized.isAircraft || this.towedByConnection != null && !this.towedByConnection.hitchVehicle.lockedOnRoad) {
            this.frontFollower = null;
            this.rearFollower = null;
        } else if ((this.frontFollower == null || this.rearFollower == null) && this.ticksExisted % 20L == 0L) {
            Point3d frontContact = this.groundDeviceCollective.getContactPoint(true);
            Point3d rearContact = this.groundDeviceCollective.getContactPoint(false);
            if (frontContact != null && rearContact != null) {
                this.rearFollower = this.getFollower();
                if (this.rearFollower != null) {
                    float pointDelta = (float)rearContact.distanceTo(frontContact);
                    if (this.towedByConnection == null) {
                        this.frontFollower = new RoadFollowingState(this.rearFollower.lane, this.rearFollower.curve, this.rearFollower.goingForwards, this.rearFollower.currentSegment).updateCurvePoints(pointDelta, RoadLane.LaneSelectionRequest.NONE);
                    } else {
                        float segmentDelta = (float)(this.towedByConnection.getHitchCurrentPosition().subtract(this.towedByConnection.hitchVehicle.position).length() + this.towedByConnection.getHookupCurrentPosition().subtract(this.towedByConnection.hookupVehicle.position).length());
                        if (this.towedByConnection.hitchEntity instanceof APart ? ((APart)this.towedByConnection.hitchEntity).localOffset.z <= 0.0 : this.towedByConnection.hitchConnection.pos.z <= 0.0) {
                            segmentDelta = -segmentDelta;
                        }
                        this.rearFollower = new RoadFollowingState(this.towedByConnection.hitchVehicle.rearFollower);
                        this.rearFollower.updateCurvePoints(segmentDelta, this.towedByConnection.hitchVehicle.selectedSegment);
                        this.frontFollower = new RoadFollowingState(this.rearFollower);
                        this.frontFollower.updateCurvePoints(pointDelta, this.towedByConnection.hitchVehicle.selectedSegment);
                    }
                }
            }
        }
        this.roadMotion.set(0.0, 0.0, 0.0);
        this.roadRotation.set(0.0, 0.0, 0.0);
        if (this.frontFollower != null && this.rearFollower != null) {
            RoadLane.LaneSelectionRequest requestedSegment;
            this.world.beginProfiling("RoadOperations", false);
            if (!(this.isVariableActive(LEFTTURNLIGHT_VARIABLE) ^ this.isVariableActive(RIGHTTURNLIGHT_VARIABLE))) {
                requestedSegment = RoadLane.LaneSelectionRequest.NONE;
            } else if (this.isVariableActive(LEFTTURNLIGHT_VARIABLE)) {
                requestedSegment = this.goingInReverse ? RoadLane.LaneSelectionRequest.RIGHT : RoadLane.LaneSelectionRequest.LEFT;
            } else {
                RoadLane.LaneSelectionRequest laneSelectionRequest = requestedSegment = this.goingInReverse ? RoadLane.LaneSelectionRequest.LEFT : RoadLane.LaneSelectionRequest.RIGHT;
            }
            if (this.frontFollower.equals(this.rearFollower)) {
                this.selectedSegment = requestedSegment;
            }
            float segmentDelta = (float)(this.totalPathDelta - this.prevTotalPathDelta);
            this.prevTotalPathDelta = this.totalPathDelta;
            this.frontFollower = this.frontFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
            this.rearFollower = this.rearFollower.updateCurvePoints(segmentDelta, this.selectedSegment);
            Point3d rearPoint = this.groundDeviceCollective.getContactPoint(false);
            if (this.frontFollower != null && this.rearFollower != null && rearPoint != null) {
                rearPoint.rotateFine(this.angles).add(this.position);
                Point3d rearDesiredPoint = this.rearFollower.getCurrentPoint();
                this.roadMotion.setTo(rearDesiredPoint).subtract(rearPoint);
                if (this.roadMotion.length() > 1.0) {
                    this.roadMotion.set(0.0, 0.0, 0.0);
                    this.frontFollower = null;
                    this.rearFollower = null;
                } else {
                    this.motion.y = 0.0;
                    Point3d desiredVector = this.frontFollower.getCurrentPoint().subtract(rearDesiredPoint);
                    double yawDelta = Math.toDegrees(Math.atan2(desiredVector.x, desiredVector.z));
                    double pitchDelta = -Math.toDegrees(Math.atan2(desiredVector.y, Math.hypot(desiredVector.x, desiredVector.z)));
                    double rollDelta = 0.0;
                    this.roadRotation.set(pitchDelta - this.angles.x, yawDelta, rollDelta - this.angles.z);
                    this.roadRotation.y = this.roadRotation.getClampedYDelta(this.angles.y);
                    if (!this.world.isClient()) {
                        this.addToSteeringAngle((float)(this.goingInReverse ? -this.roadRotation.y : this.roadRotation.y) * 1.5f);
                    }
                }
            } else {
                this.frontFollower = null;
                this.rearFollower = null;
            }
        }
        double groundCollisionBoost = 0.0;
        double groundRotationBoost = 0.0;
        boolean bl = this.lockedOnRoad = this.frontFollower != null && this.rearFollower != null;
        if (!this.lockedOnRoad) {
            if (this.towedByConnection == null) {
                this.world.beginProfiling("GroundBoostCheck", false);
                groundCollisionBoost = this.groundDeviceCollective.getMaxCollisionDepth() / SPEED_FACTOR;
                if (groundCollisionBoost > 0.0) {
                    this.world.beginProfiling("GroundBoostApply", false);
                    if (this.motion.y + groundCollisionBoost > 0.0) {
                        groundCollisionBoost = Math.min(groundCollisionBoost, (Double)ConfigSystem.configObject.general.climbSpeed.value / SPEED_FACTOR);
                        this.motion.y += groundCollisionBoost;
                        groundCollisionBoost = this.motion.y;
                    } else {
                        this.motion.y += groundCollisionBoost;
                        groundCollisionBoost = 0.0;
                    }
                    this.groundDeviceCollective.updateCollisions();
                }
            }
            this.world.beginProfiling("CollisionCheck_" + this.allBlockCollisionBoxes.size(), false);
            if (this.isCollisionBoxCollided()) {
                this.world.beginProfiling("CollisionHandling", false);
                if (this.towedByConnection != null) {
                    Point3d initalMotion = this.motion.copy();
                    if (this.correctCollidingMovement()) {
                        return;
                    }
                    this.towedByConnection.hitchVehicle.motion.add(this.motion).subtract(initalMotion);
                } else if (this.correctCollidingMovement()) {
                    return;
                }
            } else if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
                this.world.beginProfiling("GroundHandlingPitch", false);
                groundRotationBoost = this.groundDeviceCollective.performPitchCorrection(groundCollisionBoost);
                if (this.groundDeviceCollective.canDoRollChecks()) {
                    this.world.beginProfiling("GroundHandlingRoll", false);
                    groundRotationBoost = this.groundDeviceCollective.performRollCorrection(groundCollisionBoost + groundRotationBoost);
                }
                if (((JSONVehicle)this.definition).motorized.maxTiltAngle != 0.0f) {
                    this.rotation.z = -this.angles.z - (double)((JSONVehicle)this.definition).motorized.maxTiltAngle * 2.0 * Math.min(0.5, this.velocity / 2.0) * this.getSteeringAngle();
                    if (Double.isNaN(this.rotation.z)) {
                        this.rotation.z = 0.0;
                    }
                }
            }
        }
        if (!this.collidedEntities.isEmpty()) {
            this.world.beginProfiling("EntityMoveAlong", false);
            for (AEntityE_Interactable interactable : this.collidedEntities) {
                if (!(interactable instanceof AEntityVehicleD_Moving)) continue;
                AEntityVehicleD_Moving mainVehicle = (AEntityVehicleD_Moving)interactable;
                this.collisionRotation.setTo(mainVehicle.angles).subtract(mainVehicle.prevAngles);
                Point3d centerOffset = this.position.copy().subtract(mainVehicle.prevPosition);
                this.collisionMotion.setTo(centerOffset).rotateFine(this.collisionRotation).subtract(centerOffset);
                this.collisionMotion.add(mainVehicle.position).subtract(mainVehicle.prevPosition);
                if (this.lastCollidedEntity == null) {
                    this.lastCollidedEntity = interactable;
                    this.motion.subtract(this.lastCollidedEntity.motion);
                }
                break;
            }
        } else if (this.lastCollidedEntity != null) {
            this.motion.add(this.lastCollidedEntity.motion);
            this.lastCollidedEntity = null;
        }
        this.world.beginProfiling("ApplyMotions", false);
        this.motionApplied.setTo(this.motion).multiply(SPEED_FACTOR).add(this.roadMotion).add(this.collisionMotion);
        this.rotationApplied.setTo(this.rotation).add(this.roadRotation).add(this.collisionRotation);
        this.pathingApplied = this.lockedOnRoad ? (this.towedByConnection != null ? this.towedByConnection.hitchVehicle.pathingApplied : (this.goingInReverse ? -this.velocity * SPEED_FACTOR : this.velocity * SPEED_FACTOR)) : 0.0;
        this.collisionMotion.set(0.0, 0.0, 0.0);
        this.collisionRotation.set(0.0, 0.0, 0.0);
        if (!this.world.isClient()) {
            if (!this.motionApplied.isZero() || !this.rotationApplied.isZero()) {
                this.addToServerDeltas(this.motionApplied, this.rotationApplied, this.pathingApplied);
                InterfacePacket.sendToAllClients(new PacketVehicleServerMovement((EntityVehicleF_Physics)this, this.motionApplied, this.rotationApplied, this.pathingApplied));
            }
        } else if (!this.serverDeltaM.isZero() || !this.serverDeltaR.isZero()) {
            this.clientDeltaMApplied.setTo(this.serverDeltaM).subtract(this.clientDeltaM);
            this.clientDeltaMApplied.x *= Math.abs(this.clientDeltaMApplied.x);
            this.clientDeltaMApplied.y *= Math.abs(this.clientDeltaMApplied.y);
            this.clientDeltaMApplied.z *= Math.abs(this.clientDeltaMApplied.z);
            this.clientDeltaMApplied.multiply(0.04);
            if (this.clientDeltaMApplied.x > 5.0) {
                this.clientDeltaMApplied.x = 5.0;
            }
            if (this.clientDeltaMApplied.y > 5.0) {
                this.clientDeltaMApplied.y = 5.0;
            }
            if (this.clientDeltaMApplied.z > 5.0) {
                this.clientDeltaMApplied.z = 5.0;
            }
            this.motionApplied.add(this.clientDeltaMApplied);
            this.clientDeltaRApplied.setTo(this.serverDeltaR).subtract(this.clientDeltaR);
            this.clientDeltaRApplied.x *= Math.abs(this.clientDeltaRApplied.x);
            this.clientDeltaRApplied.y *= Math.abs(this.clientDeltaRApplied.y);
            this.clientDeltaRApplied.z *= Math.abs(this.clientDeltaRApplied.z);
            this.clientDeltaRApplied.multiply(0.04);
            this.rotationApplied.add(this.clientDeltaRApplied);
            if (this.rotationApplied.y > 5.0) {
                this.rotationApplied.y = 5.0;
            } else if (this.rotationApplied.y < -5.0) {
                this.rotationApplied.y = -5.0;
            }
            this.clientDeltaPApplied = this.serverDeltaP - this.clientDeltaP;
            this.clientDeltaPApplied *= Math.abs(this.clientDeltaPApplied);
            this.clientDeltaPApplied *= 0.04;
            if (this.clientDeltaPApplied > 5.0) {
                this.clientDeltaPApplied = 5.0;
            }
            this.pathingApplied += this.clientDeltaPApplied;
            this.clientDeltaM.add(this.motionApplied);
            this.clientDeltaR.add(this.rotationApplied);
            this.clientDeltaP += this.pathingApplied;
        }
        this.position.add(this.motionApplied);
        this.angles.add(this.rotationApplied);
        this.totalPathDelta += this.pathingApplied;
        this.orientation.axis.set(0.0, 0.0, 1.0).rotateFine(this.angles);
        this.orientation.updateQuaternion(false);
        this.motion.y -= groundCollisionBoost + groundRotationBoost;
        this.world.endProfiling();
    }

    private boolean isCollisionBoxCollided() {
        if (this.motion.length() > 0.001) {
            boolean clearedCache = false;
            for (BoundingBox box : this.allBlockCollisionBoxes) {
                this.tempBoxPosition.setTo(box.globalCenter).subtract(this.position).rotateFine(this.rotation).subtract(box.globalCenter).add(this.position).addScaled(this.motion, SPEED_FACTOR);
                if (!box.collidesWithLiquids && this.world.checkForCollisions(box, this.tempBoxPosition, !clearedCache)) {
                    return true;
                }
                clearedCache = true;
            }
        }
        return false;
    }

    private boolean correctCollidingMovement() {
        double collisionDepth;
        if (this.motion.x != 0.0) {
            for (BoundingBox box : this.allBlockCollisionBoxes) {
                collisionDepth = this.getCollisionForAxis(box, true, false, false);
                if (collisionDepth == -1.0) {
                    return true;
                }
                if (collisionDepth == -2.0) break;
                if (this.motion.x > 0.0) {
                    this.motion.x = Math.max(this.motion.x - collisionDepth / SPEED_FACTOR, 0.0);
                    continue;
                }
                if (!(this.motion.x < 0.0)) continue;
                this.motion.x = Math.min(this.motion.x + collisionDepth / SPEED_FACTOR, 0.0);
            }
        }
        if (this.motion.z != 0.0) {
            for (BoundingBox box : this.allBlockCollisionBoxes) {
                collisionDepth = this.getCollisionForAxis(box, false, false, true);
                if (collisionDepth == -1.0) {
                    return true;
                }
                if (collisionDepth == -2.0) break;
                if (this.motion.z > 0.0) {
                    this.motion.z = Math.max(this.motion.z - collisionDepth / SPEED_FACTOR, 0.0);
                    continue;
                }
                if (!(this.motion.z < 0.0)) continue;
                this.motion.z = Math.min(this.motion.z + collisionDepth / SPEED_FACTOR, 0.0);
            }
        }
        if (this.motion.y != 0.0) {
            for (BoundingBox box : this.allBlockCollisionBoxes) {
                collisionDepth = this.getCollisionForAxis(box, false, true, false);
                if (collisionDepth == -1.0) {
                    return true;
                }
                if (collisionDepth == -2.0) break;
                if (collisionDepth == 0.0) continue;
                if (this.motion.y > 0.0) {
                    this.motion.y = Math.max(this.motion.y - collisionDepth / SPEED_FACTOR, 0.0);
                    continue;
                }
                if (!(this.motion.y < 0.0)) continue;
                this.motion.y = Math.min(this.motion.y + collisionDepth / SPEED_FACTOR, 0.0);
            }
        }
        if (this.rotation.y != 0.0) {
            this.tempBoxRotation.set(0.0, this.rotation.y, 0.0);
            block3: for (BoundingBox box : this.allBlockCollisionBoxes) {
                while (this.rotation.y != 0.0) {
                    this.tempBoxPosition.setTo(box.globalCenter).subtract(this.position).rotateFine(this.tempBoxRotation).add(this.position).add(this.motion.x * SPEED_FACTOR, this.motion.y * SPEED_FACTOR, this.motion.z * SPEED_FACTOR);
                    this.tempBoxPosition.add(0.0, 0.1, 0.0);
                    if (!box.updateCollidingBlocks(this.world, this.tempBoxPosition.subtract(box.globalCenter))) continue block3;
                    if (this.rotation.y > 0.0) {
                        this.rotation.y = Math.max(this.rotation.y - (double)0.1f, 0.0);
                        continue;
                    }
                    this.rotation.y = Math.min(this.rotation.y + (double)0.1f, 0.0);
                }
            }
        }
        if (this.rotation.x != 0.0) {
            this.tempBoxRotation.set(this.rotation.x, this.rotation.y, 0.0);
            block5: for (BoundingBox box : this.allBlockCollisionBoxes) {
                while (this.rotation.x != 0.0) {
                    this.tempBoxPosition.setTo(box.globalCenter).subtract(this.position).rotateFine(this.tempBoxRotation).add(this.position).add(this.motion.x * SPEED_FACTOR, this.motion.y * SPEED_FACTOR, this.motion.z * SPEED_FACTOR);
                    if (!box.updateCollidingBlocks(this.world, this.tempBoxPosition.subtract(box.globalCenter))) continue block5;
                    if (this.rotation.x > 0.0) {
                        this.rotation.x = Math.max(this.rotation.x - (double)0.1f, 0.0);
                        continue;
                    }
                    this.rotation.x = Math.min(this.rotation.x + (double)0.1f, 0.0);
                }
            }
        }
        if (this.rotation.z != 0.0) {
            this.tempBoxRotation.setTo(this.rotation);
            block7: for (BoundingBox box : this.allBlockCollisionBoxes) {
                while (this.rotation.z != 0.0) {
                    this.tempBoxPosition.setTo(box.globalCenter).subtract(this.position).rotateFine(this.tempBoxRotation).add(this.position).add(this.motion.x * SPEED_FACTOR, this.motion.y * SPEED_FACTOR, this.motion.z * SPEED_FACTOR);
                    if (!box.updateCollidingBlocks(this.world, this.tempBoxPosition.subtract(box.globalCenter))) continue block7;
                    if (this.rotation.z > 0.0) {
                        this.rotation.z = Math.max(this.rotation.z - (double)0.1f, 0.0);
                        continue;
                    }
                    this.rotation.z = Math.min(this.rotation.z + (double)0.1f, 0.0);
                }
            }
        }
        return false;
    }

    public void addToServerDeltas(Point3d motionAdded, Point3d rotationAdded, double pathingAdded) {
        this.serverDeltaM.add(motionAdded);
        this.serverDeltaR.add(rotationAdded);
        this.serverDeltaP += pathingAdded;
    }

    protected abstract double getSteeringAngle();

    protected abstract void addToSteeringAngle(float var1);

    protected abstract void getForcesAndMotions();

    protected abstract void adjustControlSurfaces();

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setPoint3d("serverDeltaM", this.serverDeltaM);
        data.setPoint3d("serverDeltaR", this.serverDeltaR);
        data.setDouble("serverDeltaP", this.serverDeltaP);
        return data;
    }
}

