/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.NavBeacon;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.AEntityVehicleD_Moving;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.systems.ConfigSystem;

abstract class AEntityVehicleE_Powered
extends AEntityVehicleD_Moving {
    public static final String RUNNINGLIGHT_VARIABLE = "running_light";
    public static final String HEADLIGHT_VARIABLE = "headlight";
    public static final String NAVIGATIONLIGHT_VARIABLE = "navigation_light";
    public static final String STROBELIGHT_VARIABLE = "strobe_light";
    public static final String TAXILIGHT_VARIABLE = "taxi_light";
    public static final String LANDINGLIGHT_VARIABLE = "landing_light";
    public static final String HORN_VARIABLE = "horn";
    public static final String GEAR_VARIABLE = "gear_setpoint";
    public static final String THROTTLE_VARIABLE = "throttle";
    public static final String REVERSE_THRUST_VARIABLE = "reverser";
    public boolean reverseThrust;
    public boolean beingFueled;
    public boolean enginesOn;
    public boolean enginesRunning;
    public double throttle;
    public static final double MAX_THROTTLE = 1.0;
    public int gearMovementTime;
    public double electricPower;
    public double electricUsage;
    public double electricFlow;
    public String selectedBeaconName;
    public NavBeacon selectedBeacon;
    public EntityFluidTank fuelTank;
    public final BiMap<Byte, PartEngine> engines = HashBiMap.create();
    public final List<EntityBullet> missilesIncoming = new ArrayList<EntityBullet>();

    public AEntityVehicleE_Powered(WrapperWorld world, WrapperPlayer placingPlayer, WrapperNBT data) {
        super(world, placingPlayer, data);
        this.electricPower = data.getDouble("electricPower");
        this.selectedBeaconName = data.getString("selectedBeaconName");
        this.selectedBeacon = NavBeacon.getByNameFromWorld(world, this.selectedBeaconName);
        this.fuelTank = new EntityFluidTank(world, data.getDataOrNew("fuelTank"), ((JSONVehicle)this.definition).motorized.fuelCapacity);
        world.addEntity(this.fuelTank);
        if (this.newlyCreated) {
            this.electricPower = 12.0;
        }
    }

    @Override
    public boolean update() {
        block17: {
            block20: {
                block18: {
                    block19: {
                        if (!super.update()) break block17;
                        this.world.beginProfiling("VehicleE_Level", true);
                        this.throttle = this.getVariable(THROTTLE_VARIABLE);
                        this.reverseThrust = this.isVariableActive(REVERSE_THRUST_VARIABLE);
                        if (!this.world.isClient() && this.fuelTank.getFluidLevel() < (double)(((JSONVehicle)this.definition).motorized.fuelCapacity - 100)) {
                            for (APart part : this.parts) {
                                double amountFilled;
                                EntityFluidTank tank;
                                if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles || (tank = ((PartInteractable)part).tank) == null || !((amountFilled = tank.drain(this.fuelTank.getFluid(), 1.0, true)) > 0.0)) continue;
                                this.fuelTank.fill(this.fuelTank.getFluid(), amountFilled, true);
                            }
                        }
                        if (((JSONVehicle)this.definition).motorized.isAircraft && this.ticksExisted % 20L == 0L) {
                            this.selectedBeacon = !this.selectedBeaconName.isEmpty() ? NavBeacon.getByNameFromWorld(this.world, this.selectedBeaconName) : null;
                        }
                        if (!((JSONVehicle)this.definition).motorized.isTrailer) break block18;
                        if (this.towedByConnection == null) break block19;
                        if (this.parkingBrakeOn) {
                            this.toggleVariable("p_brake");
                        }
                        this.setVariable("brake", this.towedByConnection.hitchVehicle.brake);
                        break block20;
                    }
                    if (!this.parkingBrakeOn) {
                        this.toggleVariable("p_brake");
                    }
                    if (this.brake == 0.0) break block20;
                    this.setVariable("brake", 0.0);
                    break block20;
                }
                this.enginesOn = false;
                this.enginesRunning = false;
                for (PartEngine engine : this.engines.values()) {
                    if (!engine.magnetoOn) continue;
                    this.enginesOn = true;
                    if (!engine.running) continue;
                    this.enginesRunning = true;
                    break;
                }
            }
            if (((JSONVehicle)this.definition).motorized.isTrailer) {
                if (this.towedByConnection != null) {
                    this.electricPower = this.towedByConnection.hitchVehicle.electricPower;
                }
            } else if (this.damageAmount < (double)((JSONVehicle)this.definition).general.health) {
                if (this.electricPower > 2.0 && this.renderTextLit()) {
                    this.electricUsage += (double)0.001f;
                }
                this.electricPower = Math.max(0.0, Math.min(13.0, this.electricPower -= this.electricUsage));
                this.electricFlow = this.electricUsage;
                this.electricUsage = 0.0;
            } else {
                this.electricPower = 0.0;
                this.electricFlow = 0.0;
                this.electricUsage = 0.0;
            }
            if (this.isVariableActive(GEAR_VARIABLE)) {
                if (this.gearMovementTime < ((JSONVehicle)this.definition).motorized.gearSequenceDuration) {
                    ++this.gearMovementTime;
                }
            } else if (this.gearMovementTime > 0) {
                --this.gearMovementTime;
            }
            Iterator<EntityBullet> iterator = this.missilesIncoming.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isValid) continue;
                iterator.remove();
            }
            this.missilesIncoming.sort(new Comparator<EntityBullet>(){

                @Override
                public int compare(EntityBullet missle1, EntityBullet missile2) {
                    return missle1.targetDistance < missile2.targetDistance ? -1 : 1;
                }
            });
            this.world.endProfiling();
            return true;
        }
        return false;
    }

    @Override
    public boolean addRider(WrapperEntity rider, Point3d riderLocation) {
        if (super.addRider(rider, riderLocation)) {
            if (this.world.isClient() && ((Boolean)ConfigSystem.configObject.clientControls.autostartEng.value).booleanValue() && rider.equals(InterfaceClient.getClientPlayer()) && rider instanceof WrapperPlayer && this.locationRiderMap.containsValue((Object)rider) && this.getPartAtLocation((Point3d)((Point3d)this.locationRiderMap.inverse().get((Object)rider))).placementDefinition.isController && this.canPlayerStartEngines((WrapperPlayer)rider)) {
                for (PartEngine engine : this.engines.values()) {
                    InterfacePacket.sendToServer(new PacketPartEngine(engine, PacketPartEngine.Signal.AS_ON));
                }
                if (this.parkingBrakeOn) {
                    InterfacePacket.sendToServer(new PacketEntityVariableToggle(this, "p_brake"));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeRider(WrapperEntity rider, Iterator<WrapperEntity> iterator) {
        if (this.world.isClient() && ((Boolean)ConfigSystem.configObject.clientControls.autostartEng.value).booleanValue() && rider.equals(InterfaceClient.getClientPlayer()) && rider instanceof WrapperPlayer && this.locationRiderMap.containsValue((Object)rider)) {
            APart riddenPart = this.getPartAtLocation((Point3d)this.locationRiderMap.inverse().get((Object)rider));
            boolean otherController = false;
            if (riddenPart.placementDefinition.isController) {
                for (APart part : this.parts) {
                    if (part.equals(riddenPart) || !this.locationRiderMap.containsKey((Object)part.placementOffset) || !part.placementDefinition.isController) continue;
                    otherController = true;
                    break;
                }
                if (!otherController) {
                    for (PartEngine engine : this.engines.values()) {
                        if (engine.magnetoOn) {
                            InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_magneto"));
                        }
                        if (!engine.electricStarterEngaged) continue;
                        InterfacePacket.sendToServer(new PacketEntityVariableToggle(engine, "engine_starter"));
                    }
                    InterfacePacket.sendToServer(new PacketEntityVariableSet(this, "brake", 0.0));
                    if (!this.parkingBrakeOn) {
                        InterfacePacket.sendToServer(new PacketEntityVariableToggle(this, "p_brake"));
                    }
                }
            }
        }
        super.removeRider(rider, iterator);
    }

    @Override
    public void destroy(BoundingBox box) {
        super.destroy(box);
        for (ItemInstrument instrument : this.instruments.values()) {
            this.world.spawnItem(instrument, null, box.globalCenter);
        }
        if (((Boolean)ConfigSystem.configObject.damage.explosions.value).booleanValue()) {
            double explosivePower = 0.0;
            for (APart part : this.parts) {
                if (!(part instanceof PartInteractable)) continue;
                explosivePower += ((PartInteractable)part).getExplosiveContribution();
            }
            this.world.spawnExplosion(box.globalCenter, explosivePower + this.fuelTank.getExplosiveness() + 1.0, true);
        }
    }

    @Override
    public double getMass() {
        return super.getMass() + this.fuelTank.getMass();
    }

    @Override
    public void addPart(APart part, boolean sendPacket) {
        super.addPart(part, sendPacket);
        if (part instanceof PartEngine) {
            byte by;
            byte engineNumber = 0;
            block0: for (JSONPartDefinition partDef : ((JSONVehicle)this.definition).parts) {
                for (String type : partDef.types) {
                    if (!type.startsWith("engine")) continue;
                    if (part.placementOffset.equals(partDef.pos)) {
                        this.engines.put((Object)engineNumber, (Object)((PartEngine)part));
                        return;
                    }
                    engineNumber = (byte)(engineNumber + 1);
                    continue block0;
                }
            }
            do {
                by = engineNumber;
                engineNumber = (byte)(engineNumber + 1);
            } while (this.engines.containsKey((Object)by));
            engineNumber = (byte)(engineNumber - 1);
            this.engines.put((Object)engineNumber, (Object)((PartEngine)part));
        }
    }

    @Override
    public void removePart(APart part, Iterator<APart> iterator) {
        super.removePart(part, iterator);
        this.engines.inverse().remove((Object)part);
    }

    public void acquireMissile(EntityBullet missile) {
        if (!this.missilesIncoming.contains(missile)) {
            this.missilesIncoming.add(missile);
        }
    }

    public boolean canPlayerStartEngines(WrapperPlayer player) {
        String uniqueUUIDString;
        if (!((Boolean)ConfigSystem.configObject.general.keyRequiredToStartVehicles.value).booleanValue()) {
            return true;
        }
        if (player.isHoldingItemType(JSONItem.ItemComponentType.KEY) && !(uniqueUUIDString = player.getHeldStack().getData().getString("vehicle")).isEmpty() && this.uniqueUUID.equals(UUID.fromString(uniqueUUIDString))) {
            return true;
        }
        if (this.world.isClient()) {
            player.displayChatMessage(InterfaceCore.translate("interact.key.failure.needvehiclekey"));
        }
        return false;
    }

    @Override
    public boolean hasRadio() {
        return true;
    }

    @Override
    public boolean renderTextLit() {
        if (((JSONVehicle)this.definition).motorized.hasRunningLights && this.isVariableActive(RUNNINGLIGHT_VARIABLE)) {
            return this.electricPower > 3.0 && super.renderTextLit();
        }
        if (((JSONVehicle)this.definition).motorized.hasHeadlights && this.isVariableActive(HEADLIGHT_VARIABLE)) {
            return this.electricPower > 3.0 && super.renderTextLit();
        }
        if (((JSONVehicle)this.definition).motorized.hasNavLights && this.isVariableActive(NAVIGATIONLIGHT_VARIABLE)) {
            return this.electricPower > 3.0 && super.renderTextLit();
        }
        if (((JSONVehicle)this.definition).motorized.hasStrobeLights && this.isVariableActive(STROBELIGHT_VARIABLE)) {
            return this.electricPower > 3.0 && super.renderTextLit();
        }
        if (((JSONVehicle)this.definition).motorized.hasTaxiLights && this.isVariableActive(TAXILIGHT_VARIABLE)) {
            return this.electricPower > 3.0 && super.renderTextLit();
        }
        if (((JSONVehicle)this.definition).motorized.hasLandingLights && this.isVariableActive(LANDINGLIGHT_VARIABLE)) {
            return this.electricPower > 3.0 && super.renderTextLit();
        }
        return false;
    }

    @Override
    public WrapperNBT save(WrapperNBT data) {
        super.save(data);
        data.setDouble("electricPower", this.electricPower);
        data.setString("selectedBeaconName", this.selectedBeaconName);
        data.setData("fuelTank", this.fuelTank.save(new WrapperNBT()));
        return data;
    }
}

