/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.TrailerConnection;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.rendering.components.DurationDelayClock;
import minecrafttransportsimulator.rendering.instances.RenderPart;

public abstract class APart
extends AEntityE_Interactable<JSONPart> {
    private static final Point3d ZERO_POINT = new Point3d();
    private static RenderPart renderer;
    public final JSONPartDefinition placementDefinition;
    public final Point3d placementOffset;
    public final Point3d placementAngles;
    public final boolean disableMirroring;
    public final AEntityF_Multipart<?> entityOn;
    public final EntityVehicleF_Physics vehicleOn;
    public final APart parentPart;
    public final List<APart> childParts = new ArrayList<APart>();
    private final List<DurationDelayClock> activeClocks = new ArrayList<DurationDelayClock>();
    private final List<DurationDelayClock> movementClocks = new ArrayList<DurationDelayClock>();
    private final Map<JSONPartDefinition, JSONPartDefinition> subpackMappings = new HashMap<JSONPartDefinition, JSONPartDefinition>();
    public boolean isDisabled;
    public boolean isActive = true;
    public boolean prevActive = true;
    public final Point3d localOffset;
    public final Point3d prevLocalOffset;
    public final Point3d localAngles;

    public APart(AEntityF_Multipart<?> entityOn, WrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, WrapperNBT data, APart parentPart) {
        super(entityOn.world, placingPlayer, data);
        this.entityOn = entityOn;
        this.vehicleOn = entityOn instanceof EntityVehicleF_Physics ? (EntityVehicleF_Physics)entityOn : null;
        this.placementOffset = placementDefinition.pos;
        this.localOffset = this.placementOffset.copy();
        this.prevLocalOffset = this.localOffset.copy();
        this.placementDefinition = placementDefinition;
        this.boundingBox = new BoundingBox(this.placementOffset, this.position, (double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0, (double)this.getWidth() / 2.0, ((JSONPart)this.definition).ground != null ? ((JSONPart)this.definition).ground.canFloat : false);
        this.placementAngles = placementDefinition.rot != null ? placementDefinition.rot : new Point3d();
        this.localAngles = this.placementAngles.copy();
        if (!this.isFake() && parentPart != null) {
            this.parentPart = parentPart;
            parentPart.childParts.add(this);
            this.disableMirroring = placementDefinition.isSubPart ? parentPart.disableMirroring || ((JSONPart)this.definition).generic.disableMirroring : ((JSONPart)this.definition).generic.disableMirroring;
        } else {
            this.disableMirroring = ((JSONPart)this.definition).generic.disableMirroring;
            this.parentPart = null;
        }
        this.position.setTo(this.localOffset).rotateFine(entityOn.angles).add(entityOn.position);
        this.angles.setTo(this.localAngles).add(entityOn.angles);
        this.angles.setTo(this.placementAngles);
        this.prevAngles.setTo(this.angles);
        this.mirrored = (this.placementOffset.x < 0.0 && !placementDefinition.inverseMirroring || this.placementOffset.x >= 0.0 && placementDefinition.inverseMirroring) && !this.disableMirroring;
    }

    @Override
    protected void initializeDefinition() {
        super.initializeDefinition();
        this.movementClocks.clear();
        if (((JSONPart)this.definition).generic.movementAnimations != null) {
            for (JSONAnimationDefinition animation : ((JSONPart)this.definition).generic.movementAnimations) {
                this.movementClocks.add(new DurationDelayClock(animation));
            }
        }
        if (this.placementDefinition.animations != null) {
            for (JSONAnimationDefinition animation : this.placementDefinition.animations) {
                this.movementClocks.add(new DurationDelayClock(animation));
            }
        }
        this.activeClocks.clear();
        if (((JSONPart)this.definition).generic.activeAnimations != null) {
            for (JSONAnimationDefinition animation : ((JSONPart)this.definition).generic.activeAnimations) {
                this.activeClocks.add(new DurationDelayClock(animation));
            }
        }
        if (this.placementDefinition.activeAnimations != null) {
            for (JSONAnimationDefinition animation : this.placementDefinition.activeAnimations) {
                this.activeClocks.add(new DurationDelayClock(animation));
            }
        }
    }

    @Override
    public boolean update() {
        if (super.update()) {
            this.prevActive = this.isActive;
            boolean bl = this.isActive = this.placementDefinition.isSubPart ? this.parentPart.isActive : true;
            if (this.isActive && !this.activeClocks.isEmpty()) {
                boolean inhibitAnimations = false;
                for (DurationDelayClock clock : this.activeClocks) {
                    switch (clock.animation.animationType) {
                        case VISIBILITY: {
                            double variableValue;
                            if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) < (double)clock.animation.clampMin) && !(variableValue > (double)clock.animation.clampMax)) break;
                            this.isActive = false;
                            break;
                        }
                        case INHIBITOR: {
                            double variableValue;
                            if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                            inhibitAnimations = true;
                            break;
                        }
                        case ACTIVATOR: {
                            double variableValue;
                            if (!inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                            inhibitAnimations = false;
                            break;
                        }
                        case TRANSLATION: {
                            break;
                        }
                        case ROTATION: {
                            break;
                        }
                    }
                    if (this.isActive) continue;
                    break;
                }
            }
            this.prevMotion.setTo(this.entityOn.prevMotion);
            this.motion.setTo(this.entityOn.motion);
            this.prevLocalOffset.setTo(this.localOffset);
            this.isDisabled = this.updateLocals();
            if (this.parentPart != null && this.placementDefinition.isSubPart) {
                this.localOffset.subtract(this.parentPart.placementOffset);
                this.localOffset.rotateFine(this.parentPart.localAngles);
                this.localAngles.add(this.parentPart.localAngles);
                this.localOffset.add(this.parentPart.localOffset);
            }
            this.position.setTo(this.localOffset).rotateFine(this.entityOn.angles).add(this.entityOn.position);
            this.angles.setTo(this.localAngles).add(this.entityOn.angles);
            this.updatePostMovement();
            return true;
        }
        return false;
    }

    @Override
    protected void updateCollisionBoxes() {
        if (!this.isFake()) {
            super.updateCollisionBoxes();
            this.interactionBoxes.add(this.boundingBox);
        }
    }

    @Override
    public void attack(Damage damage) {
        if (((JSONPart)this.definition).generic.canBeRemovedByHand && !this.placementDefinition.isPermanent && damage.entityResponsible instanceof WrapperPlayer) {
            WrapperPlayer player = (WrapperPlayer)damage.entityResponsible;
            if (this.entityOn.locked) {
                player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.vehiclelocked"));
            } else if (player.getInventory().addStack(((AItemBase)this.getItem()).getNewStack(this.save(new WrapperNBT())))) {
                this.disconnectAllConnections();
                this.entityOn.removePart(this, null);
            }
        } else {
            super.attack(damage);
        }
    }

    @Override
    public AEntityE_Interactable.PlayerOwnerState getOwnerState(WrapperPlayer player) {
        return this.entityOn.getOwnerState(player);
    }

    @Override
    public double getMass() {
        return ((JSONPart)this.definition).generic.mass;
    }

    @Override
    public void remove() {
        super.remove();
        if (this.parentPart != null) {
            this.parentPart.childParts.remove(this);
        }
    }

    @Override
    public boolean shouldSavePosition() {
        return false;
    }

    @Override
    public void connectTrailer(TrailerConnection connection) {
        this.entityOn.connectTrailer(connection);
    }

    @Override
    public void disconnectTrailer(TrailerConnection connection) {
        this.entityOn.disconnectTrailer(connection);
    }

    @Override
    public void connectAsTrailer(TrailerConnection connection) {
        this.entityOn.connectAsTrailer(connection);
    }

    @Override
    public void disconnectAsTrailer() {
        this.entityOn.disconnectAsTrailer();
    }

    @Override
    public Set<TrailerConnection> getTowingConnections() {
        return this.entityOn.getTowingConnections();
    }

    private boolean updateLocals() {
        boolean inhibitAnimations = false;
        boolean disablePart = false;
        this.scale = this.placementDefinition.isSubPart && this.parentPart != null ? this.parentPart.scale : 1.0f;
        this.localOffset.set(0.0, 0.0, 0.0);
        this.localAngles.set(0.0, 0.0, 0.0);
        if (!this.movementClocks.isEmpty()) {
            for (DurationDelayClock clock : this.movementClocks) {
                switch (clock.animation.animationType) {
                    case TRANSLATION: {
                        if (inhibitAnimations) break;
                        double variableValue = this.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, 0.0f);
                        Point3d appliedTranslation = clock.animationAxisNormalized.copy().multiply(variableValue);
                        this.localOffset.add(appliedTranslation.rotateFine(this.localAngles));
                        break;
                    }
                    case ROTATION: {
                        if (inhibitAnimations) break;
                        double variableValue = this.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, 0.0f);
                        Point3d appliedRotation = clock.animationAxisNormalized.copy().multiply(variableValue);
                        if (!clock.animation.centerPoint.isZero()) {
                            this.localOffset.add(clock.animation.centerPoint.copy().multiply(-1.0).rotateFine(appliedRotation).add(clock.animation.centerPoint).rotateFine(this.localAngles));
                        }
                        this.localAngles.add(appliedRotation);
                        break;
                    }
                    case SCALING: {
                        if (inhibitAnimations) break;
                        this.scale = (float)((double)this.scale * this.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, 0.0f));
                        this.boundingBox.widthRadius = (double)this.getWidth() / 2.0;
                        this.boundingBox.heightRadius = (double)this.getHeight() / 2.0;
                        this.boundingBox.depthRadius = (double)this.getWidth() / 2.0;
                        break;
                    }
                    case VISIBILITY: {
                        double variableValue;
                        if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) < (double)clock.animation.clampMin) && !(variableValue > (double)clock.animation.clampMax)) break;
                        disablePart = true;
                        break;
                    }
                    case INHIBITOR: {
                        double variableValue;
                        if (inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                        inhibitAnimations = true;
                        break;
                    }
                    case ACTIVATOR: {
                        double variableValue;
                        if (!inhibitAnimations || !((variableValue = this.getAnimatedVariableValue(clock, 0.0f)) >= (double)clock.animation.clampMin) || !(variableValue <= (double)clock.animation.clampMax)) break;
                        inhibitAnimations = false;
                    }
                }
                if (!disablePart) continue;
                break;
            }
        }
        if (this.placementDefinition.isSubPart && this.parentPart != null && this.parentPart.scale != 1.0f) {
            this.localOffset.add(this.placementOffset.copy().multiply(this.parentPart.scale));
        } else {
            this.localOffset.add(this.placementOffset);
        }
        this.localAngles.add(this.placementAngles);
        return disablePart;
    }

    public JSONPartDefinition getPackForSubPart(JSONPartDefinition subPartDef) {
        if (!this.subpackMappings.containsKey(subPartDef)) {
            JSONPartDefinition correctedPartDef = JSONParser.duplicateJSON(subPartDef);
            correctedPartDef.isSubPart = true;
            correctedPartDef.pos.add(this.placementOffset);
            if (this.mirrored) {
                correctedPartDef.pos.x -= 2.0 * subPartDef.pos.x;
            }
            correctedPartDef.turnsWithSteer = this.placementDefinition.turnsWithSteer;
            correctedPartDef.inverseMirroring = this.placementDefinition.inverseMirroring;
            correctedPartDef.isSpare = this.placementDefinition.isSpare;
            this.subpackMappings.put(subPartDef, correctedPartDef);
        }
        return this.subpackMappings.get(subPartDef);
    }

    public Point3d getRenderingRotation(float partialTicks) {
        return this.parentPart != null ? this.parentPart.getRenderingRotation(partialTicks) : ZERO_POINT;
    }

    public boolean isInLiquid() {
        return this.world.isBlockLiquid(this.position);
    }

    public boolean isFake() {
        return false;
    }

    public float getWidth() {
        return ((JSONPart)this.definition).generic.width != 0.0f ? ((JSONPart)this.definition).generic.width : 0.75f;
    }

    public float getHeight() {
        return ((JSONPart)this.definition).generic.height != 0.0f ? ((JSONPart)this.definition).generic.height : 0.75f;
    }

    @Override
    public float getLightProvided() {
        return this.entityOn.getLightProvided();
    }

    @Override
    public boolean shouldRenderBeams() {
        return this.entityOn.shouldRenderBeams();
    }

    @Override
    public String getTexture() {
        return ((JSONPart)this.definition).generic.useVehicleTexture ? this.entityOn.getTexture() : super.getTexture();
    }

    @Override
    public boolean renderTextLit() {
        return this.entityOn.renderTextLit();
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        int partNumber;
        if (variable.startsWith("parent_")) {
            return this.parentPart.getRawVariableValue(variable.substring("parent_".length()), partialTicks);
        }
        if (((JSONPart)this.definition).parts != null && (partNumber = APart.getVariableNumber(variable)) != -1) {
            return AEntityF_Multipart.getSpecificPartAnimation(this, variable, partNumber, partialTicks);
        }
        switch (variable) {
            case "part_present": {
                return 1.0;
            }
        }
        double value = super.getRawVariableValue(variable, partialTicks);
        if (!Double.isNaN(value)) {
            return value;
        }
        if (this.parentPart != null) {
            return this.parentPart.getRawVariableValue(variable, partialTicks);
        }
        return this.entityOn.getRawVariableValue(variable, partialTicks);
    }

    public RenderPart getRenderer() {
        if (renderer == null) {
            renderer = new RenderPart();
        }
        return renderer;
    }
}

